/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;

public class Debug {
    private static AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("debug");

    public static void out(String string) {
        Debug.out(string, null);
    }

    public static void out(Throwable throwable) {
        Debug.out("", throwable);
    }

    public static void outNoStack(String string) {
        Debug.outNoStack(string, false);
    }

    public static void outNoStack(String string, boolean bl) {
        Debug.diagLoggerLogAndOut("DEBUG::" + new Date(SystemTime.getCurrentTime()).toString() + "  " + string, bl);
    }

    public static void outDiagLoggerOnly(String string) {
        Debug.diagLoggerLog(string);
    }

    public static void out(String string, Throwable throwable) {
        String string2 = "DEBUG::";
        string2 = string2 + new Date(SystemTime.getCurrentTime()).toString() + "::";
        String string3 = null;
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[2];
            String string4 = stackTraceElement.getClassName() + "::";
            String string5 = stackTraceElement.getMethodName() + "::";
            int n = stackTraceElement.getLineNumber();
            string3 = Debug.getCompressedStackTrace(exception, 3, 200);
            Debug.diagLoggerLogAndOut(string2 + string4 + string5 + n + ":", true);
            if (string.length() > 0) {
                Debug.diagLoggerLogAndOut("  " + string, true);
            }
            if (string3 != null) {
                Debug.diagLoggerLogAndOut("    " + string3, true);
            }
            if (throwable != null) {
                Debug.diagLoggerLogAndOut(throwable);
            }
            return;
        }
    }

    public static String getLastCaller() {
        return Debug.getLastCaller(0);
    }

    public static String getLastCaller(int n) {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
                return "??";
            }
            if (stackTraceElementArray.length > 3 + n) {
                return stackTraceElementArray[3 + n].toString();
            }
            return stackTraceElementArray[stackTraceElementArray.length - 1].toString();
        }
    }

    public static void outStackTrace() {
        Debug.diagLoggerLogAndOut(Debug.getStackTrace(1), false);
    }

    private static String getStackTrace(int n) {
        String string = "";
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 1; i < stackTraceElementArray.length - n; ++i) {
                if (stackTraceElementArray[i].getMethodName().endsWith("StackTrace")) continue;
                string = string + stackTraceElementArray[i].toString() + "\n";
            }
            if (exception.getCause() != null) {
                string = string + "\tCaused By: " + Debug.getStackTrace(exception.getCause()) + "\n";
            }
            return string;
        }
    }

    public static void killAWTThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.killAWTThreads(threadGroup);
    }

    private static String getCompressedStackTrace(Throwable throwable, int n) {
        return Debug.getCompressedStackTrace(throwable, n, 200);
    }

    public static String getCompressedStackTrace(Throwable throwable, int n, int n2) {
        String string = "";
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n3 = Math.min(stackTraceElementArray.length, n2 + n);
        for (int i = n; i < n3; ++i) {
            if (i > n) {
                string = string + ",";
            }
            String string2 = stackTraceElementArray[i].getClassName();
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
            string = string + string2 + "::" + stackTraceElementArray[i].getMethodName() + "::" + stackTraceElementArray[i].getLineNumber();
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            string = string + "\n\tCaused By: " + Debug.getCompressedStackTrace(throwable2, 0);
        }
        return string;
    }

    public static String getStackTrace(boolean bl, boolean bl2) {
        return Debug.getStackTrace(bl, bl2, bl2 ? 0 : 1, 200);
    }

    public static String getStackTrace(boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            return Debug.getCompressedStackTrace(bl2 ? 2 + n : 3 + n, n2);
        }
        return Debug.getStackTrace(1);
    }

    private static String getCompressedStackTrace(int n, int n2) {
        String string = null;
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            string = Debug.getCompressedStackTrace(exception, n, n2);
            return string;
        }
    }

    public static void killAWTThreads(ThreadGroup threadGroup) {
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            String string;
            Thread thread = threadArray[i];
            if (thread == null || !(string = thread.getName()).startsWith("AWT")) continue;
            Debug.out("Interrupting thread '".concat(thread.toString()).concat("'"));
            thread.interrupt();
        }
        if (threadGroup.getParent() != null) {
            Debug.killAWTThreads(threadGroup.getParent());
        }
    }

    public static void dumpThreads(String string) {
        Debug.out(string + ":");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.dumpThreads(threadGroup, "\t");
    }

    public static void dumpThreads(ThreadGroup threadGroup, String string) {
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            if (thread == null) continue;
            Debug.out(string.concat("active thread = ").concat(thread.toString()).concat(", daemon = ").concat(String.valueOf(thread.isDaemon())));
        }
        if (threadGroup.getParent() != null) {
            Debug.dumpThreads(threadGroup.getParent(), string + "\t");
        }
    }

    public static void dumpThreadsLoop(final String string) {
        new AEThread("Thread Dumper"){

            public void runSupport() {
                while (true) {
                    Debug.dumpThreads(string);
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public static void dumpSystemProperties() {
        Debug.out("System Properties:");
        Properties properties = System.getProperties();
        for (String string : properties.keySet()) {
            Debug.out("\t".concat(string).concat(" = '").concat(properties.get(string).toString()).concat("'"));
        }
    }

    public static String getNestedExceptionMessage(Throwable throwable) {
        String string = "";
        while (throwable != null) {
            String string2 = throwable instanceof UnknownHostException ? "Unknown host " + throwable.getMessage() : (throwable instanceof FileNotFoundException ? "File not found: " + throwable.getMessage() : throwable.getMessage());
            if (string2 == null) {
                string2 = throwable.getClass().getName();
                int n = string2.lastIndexOf(".");
                string2 = string2.substring(n + 1).trim();
            }
            if (string2.length() > 0 && string.indexOf(string2) == -1) {
                string = string + (string.length() == 0 ? "" : ", ") + string2;
            }
            throwable = throwable.getCause();
        }
        return string;
    }

    public static String getNestedExceptionMessageAndStack(Throwable throwable) {
        return Debug.getNestedExceptionMessage(throwable) + ", " + Debug.getCompressedStackTrace(throwable, 0);
    }

    public static String getCompressedStackTrace() {
        return Debug.getCompressedStackTrace(new Throwable(), 2);
    }

    public static String getCompressedStackTrace(int n) {
        return Debug.getCompressedStackTrace(new Throwable(), 2, n);
    }

    public static String getExceptionMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null || string.length() == 0) {
            string = throwable.getClass().getName();
            int n = string.lastIndexOf(".");
            string = string.substring(n + 1);
        } else if (throwable instanceof ClassNotFoundException && string.toLowerCase().indexOf("found") == -1) {
            string = "Class " + string + " not found";
        }
        return string;
    }

    public static void printStackTrace(Throwable throwable) {
        Debug.printStackTrace(throwable, null);
    }

    public static void printStackTrace(Throwable throwable, Object object) {
        String string = "DEBUG::";
        string = string + new Date(SystemTime.getCurrentTime()).toString() + "::";
        String string2 = "?::";
        String string3 = "?::";
        int n = -1;
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            Object object2 = exception.getStackTrace();
            for (int i = 1; i < ((StackTraceElement[])object2).length; ++i) {
                StackTraceElement stackTraceElement = object2[i];
                string2 = stackTraceElement.getClassName() + "::";
                string3 = stackTraceElement.getMethodName() + "::";
                n = stackTraceElement.getLineNumber();
                if (string2.indexOf(".logging.") == -1 && !string2.endsWith(".Debug::")) break;
            }
            Debug.diagLoggerLogAndOut(string + string2 + string3 + n + ":", true);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object2 = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
                if (object != null) {
                    ((PrintWriter)object2).print("  ");
                    ((PrintWriter)object2).println(object);
                }
                ((PrintWriter)object2).print("  ");
                throwable.printStackTrace((PrintWriter)object2);
                ((PrintWriter)object2).close();
                String string4 = byteArrayOutputStream.toString();
                Debug.diagLoggerLogAndOut(string4, true);
            }
            catch (Throwable throwable2) {
                throwable.printStackTrace();
            }
            return;
        }
    }

    public static String getStackTrace(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
            throwable.printStackTrace(printWriter);
            printWriter.close();
            return byteArrayOutputStream.toString();
        }
        catch (Throwable throwable2) {
            return "";
        }
    }

    private static void diagLoggerLog(String string) {
        diag_logger.log(string);
    }

    private static void diagLoggerLogAndOut(String string, boolean bl) {
        if (diag_logger == null) {
            if (bl) {
                System.err.println(string);
            } else {
                System.out.println(string);
            }
        } else {
            diag_logger.logAndOut(string, bl);
        }
    }

    private static void diagLoggerLogAndOut(Throwable throwable) {
        if (diag_logger == null) {
            throwable.printStackTrace();
        } else {
            diag_logger.logAndOut(throwable);
        }
    }

    public static String secretFileName(String string) {
        if (string == null) {
            return "";
        }
        String string2 = File.separator;
        String string3 = "([\\" + string2 + "]?[^\\" + string2 + "]{0,3}+)[^\\" + string2 + "]*";
        String string4 = string.replaceAll(string3, "$1");
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string4 = string4 + string.substring(n);
        }
        return string4;
    }

    public static void main(String[] stringArray) {
        System.out.println(Debug.secretFileName("c:\\temp\\hello there.txt"));
        System.out.println(Debug.secretFileName("hello there.txt"));
    }

    static {
        diag_logger.setForced();
    }
}

