/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.ReferenceCountedDirectByteBuffer;

public class DirectByteBuffer {
    public static final byte AL_NONE = 0;
    public static final byte AL_EXTERNAL = 1;
    public static final byte AL_OTHER = 2;
    public static final byte AL_PT_READ = 3;
    public static final byte AL_PT_LENGTH = 4;
    public static final byte AL_CACHE_READ = 5;
    public static final byte AL_DM_READ = 6;
    public static final byte AL_DM_ZERO = 7;
    public static final byte AL_DM_CHECK = 8;
    public static final byte AL_BT_PIECE = 9;
    public static final byte AL_CACHE_WRITE = 10;
    public static final byte AL_PROXY_RELAY = 11;
    public static final byte AL_MSG = 12;
    public static final byte AL_MSG_AZ_HAND = 13;
    public static final byte AL_MSG_AZ_PEX = 14;
    public static final byte AL_MSG_BT_CANCEL = 15;
    public static final byte AL_MSG_BT_HAND = 16;
    public static final byte AL_MSG_BT_HAVE = 17;
    public static final byte AL_MSG_BT_PIECE = 18;
    public static final byte AL_MSG_BT_REQUEST = 19;
    public static final byte AL_MSG_BT_KEEPALIVE = 20;
    public static final byte AL_MSG_BT_HEADER = 21;
    public static final byte AL_MSG_AZ_HEADER = 22;
    public static final byte AL_MSG_BT_PAYLOAD = 23;
    public static final byte AL_MSG_AZ_PAYLOAD = 24;
    public static final byte AL_FILE = 25;
    public static final byte AL_NET_CRYPT = 26;
    public static final byte AL_MSG_LT_EXT_MESSAGE = 27;
    public static final byte AL_MSG_LT_HANDSHAKE = 28;
    public static final byte AL_MSG_UT_PEX = 29;
    public static final byte AL_MSG_BT_DHT_PORT = 30;
    public static final String[] AL_DESCS = new String[]{"None", "Ext", "Other", "PeerRead", "PeerLen", "CacheRead", "DiskRead", "DiskZero", "DiskCheck", "BTPiece", "CacheWrite", "ProxyRelay", "Messaging", "AZHandshake", "AZPEX", "BTCancel", "BTHandshake", "BTHave", "BTPiece", "BTRequest", "BTKeepAlive", "BTHeader", "AZHeader", "BTPayload", "AZPayload", "File", "MsgCrypt", "LTExtMsg", "LTExtHandshake", "UTPEX", "BTDHTPort"};
    public static final byte SS_NONE = 0;
    public static final byte SS_EXTERNAL = 1;
    public static final byte SS_OTHER = 2;
    public static final byte SS_CACHE = 3;
    public static final byte SS_FILE = 4;
    public static final byte SS_NET = 5;
    public static final byte SS_BT = 6;
    public static final byte SS_DR = 7;
    public static final byte SS_DW = 8;
    public static final byte SS_PEER = 9;
    public static final byte SS_PROXY = 10;
    public static final byte SS_MSG = 11;
    public static final String[] SS_DESCS = new String[]{"None", "Ext", "Other", "Cache", "File", "Net", "BT", "DiskRead", "DiskWrite", "Peer", "Proxy", "Messaging"};
    public static final byte OP_LIMIT = 0;
    public static final byte OP_LIMIT_INT = 1;
    public static final byte OP_POSITION = 2;
    public static final byte OP_POSITION_INT = 3;
    public static final byte OP_CLEAR = 4;
    public static final byte OP_FLIP = 5;
    public static final byte OP_REMANING = 6;
    public static final byte OP_CAPACITY = 7;
    public static final byte OP_PUT_BYTEARRAY = 8;
    public static final byte OP_PUT_DBB = 9;
    public static final byte OP_PUT_BB = 10;
    public static final byte OP_PUTINT = 11;
    public static final byte OP_PUT_BYTE = 12;
    public static final byte OP_GET = 13;
    public static final byte OP_GET_INT = 14;
    public static final byte OP_GET_BYTEARRAY = 15;
    public static final byte OP_GETINT = 16;
    public static final byte OP_GETINT_INT = 17;
    public static final byte OP_HASREMAINING = 18;
    public static final byte OP_READ_FC = 19;
    public static final byte OP_WRITE_FC = 20;
    public static final byte OP_READ_SC = 21;
    public static final byte OP_WRITE_SC = 22;
    public static final byte OP_GETBUFFER = 23;
    public static final byte OP_GETSHORT = 24;
    public static final byte OP_PUTSHORT = 25;
    public static final String[] OP_DESCS = new String[]{"limit", "limit(int)", "position", "position(int)", "clear", "flip", "remaining", "capacity", "put(byte[])", "put(dbb)", "put(bbb)", "putInt", "put(byte)", "get", "get(int)", "get(byte[])", "getInt", "getInt(int", "hasRemaining", "read(fc)", "write(fc)", "read(sc)", "write(sc)", "getBuffer", "getShort", "putShort"};
    protected static final boolean TRACE = false;
    protected static final int TRACE_BUFFER_SIZE = 64;
    private ByteBuffer buffer;
    private DirectByteBufferPool pool;
    private byte allocator;
    private boolean was_returned_to_pool = false;

    public DirectByteBuffer(ByteBuffer byteBuffer) {
        this(0, byteBuffer, null);
    }

    public DirectByteBuffer(byte by, ByteBuffer byteBuffer, DirectByteBufferPool directByteBufferPool) {
        if (byteBuffer == null) {
            throw new NullPointerException("buffer is null");
        }
        this.allocator = by;
        this.buffer = byteBuffer;
        this.pool = directByteBufferPool;
    }

    protected DirectByteBuffer(DirectByteBuffer directByteBuffer) {
        this.allocator = directByteBuffer.allocator;
        this.buffer = directByteBuffer.buffer;
        this.pool = null;
        if (this.buffer == null) {
            throw new NullPointerException("basis.buffer is null");
        }
    }

    public ReferenceCountedDirectByteBuffer getReferenceCountedBuffer() {
        ReferenceCountedDirectByteBuffer referenceCountedDirectByteBuffer = new ReferenceCountedDirectByteBuffer(this);
        return referenceCountedDirectByteBuffer;
    }

    protected void traceUsage(byte by, byte by2) {
    }

    protected String getTraceString() {
        return null;
    }

    protected void dumpTrace(Throwable throwable) {
    }

    protected ByteBuffer getBufferInternal() {
        return this.buffer;
    }

    protected byte getAllocator() {
        return this.allocator;
    }

    public int limit(byte by) {
        return this.buffer.limit();
    }

    public void limit(byte by, int n) {
        if (this.buffer == null) {
            System.out.println("Trying to limit null buffer - returned? " + this.was_returned_to_pool);
        }
        this.buffer.limit(n);
    }

    public int position(byte by) {
        return this.buffer.position();
    }

    public void position(byte by, int n) {
        this.buffer.position(n);
    }

    public void clear(byte by) {
        this.buffer.clear();
    }

    public void flip(byte by) {
        this.buffer.flip();
    }

    public int remaining(byte by) {
        return this.buffer.remaining();
    }

    public int capacity(byte by) {
        return this.buffer.capacity();
    }

    public void put(byte by, byte[] byArray) {
        this.buffer.put(byArray);
    }

    public void put(byte by, byte[] byArray, int n, int n2) {
        this.buffer.put(byArray, n, n2);
    }

    public void put(byte by, DirectByteBuffer directByteBuffer) {
        this.buffer.put(directByteBuffer.buffer);
    }

    public void put(byte by, ByteBuffer byteBuffer) {
        this.buffer.put(byteBuffer);
    }

    public void put(byte by, byte by2) {
        this.buffer.put(by2);
    }

    public void putShort(byte by, short s) {
        this.buffer.putShort(s);
    }

    public void putInt(byte by, int n) {
        this.buffer.putInt(n);
    }

    public byte get(byte by) {
        return this.buffer.get();
    }

    public byte get(byte by, int n) {
        return this.buffer.get(n);
    }

    public void get(byte by, byte[] byArray) {
        this.buffer.get(byArray);
    }

    public short getShort(byte by) {
        return this.buffer.getShort();
    }

    public int getInt(byte by) {
        return this.buffer.getInt();
    }

    public int getInt(byte by, int n) {
        return this.buffer.getInt(n);
    }

    public boolean hasRemaining(byte by) {
        return this.buffer.hasRemaining();
    }

    public int read(byte by, FileChannel fileChannel) throws IOException {
        try {
            return fileChannel.read(this.buffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.dumpTrace(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public int write(byte by, FileChannel fileChannel) throws IOException {
        try {
            return fileChannel.write(this.buffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.dumpTrace(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public int read(byte by, SocketChannel socketChannel) throws IOException {
        try {
            return socketChannel.read(this.buffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.dumpTrace(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public int write(byte by, SocketChannel socketChannel) throws IOException {
        try {
            return socketChannel.write(this.buffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.dumpTrace(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public ByteBuffer getBuffer(byte by) {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool() {
        if (this.pool != null) {
            DirectByteBuffer directByteBuffer = this;
            synchronized (directByteBuffer) {
                if (this.buffer == null) {
                    Debug.out("Buffer already returned to pool");
                } else {
                    this.pool.returnBufferSupport(this);
                    this.buffer = null;
                    this.was_returned_to_pool = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPoolIfNotFree() {
        if (this.pool != null) {
            DirectByteBuffer directByteBuffer = this;
            synchronized (directByteBuffer) {
                if (this.buffer != null) {
                    this.pool.returnBufferSupport(this);
                    this.buffer = null;
                    this.was_returned_to_pool = true;
                }
            }
        }
    }
}

