/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DirectByteBufferPoolReal
extends DirectByteBufferPool {
    private static final boolean disable_gc;
    protected static final boolean DEBUG_TRACK_HANDEDOUT = false;
    protected static final boolean DEBUG_PRINT_MEM = false;
    protected static final int DEBUG_PRINT_TIME = 120000;
    protected static final boolean DEBUG_HANDOUT_SIZES = false;
    protected static final boolean DEBUG_FREE_SIZES = false;
    private static final int START_POWER = 12;
    private static final int END_POWER = 25;
    private static final int[] EXTRA_BUCKETS;
    public static final int MAX_SIZE;
    private static final DirectByteBufferPoolReal pool;
    private final Map buffersMap = new LinkedHashMap(14);
    private final Object poolsLock = new Object();
    private static final int SLICE_END_SIZE = 2048;
    private static final int SLICE_ALLOC_CHUNK_SIZE = 4096;
    private static final short[] SLICE_ENTRY_SIZES;
    private static final short[] SLICE_ALLOC_MAXS;
    private static final short[] SLICE_ENTRY_ALLOC_SIZES;
    private static final List[] slice_entries;
    private static final boolean[][] slice_allocs;
    private static final boolean[] slice_alloc_fails;
    private static final long[] slice_use_count;
    private final Map handed_out = new IdentityHashMap();
    private final Map size_counts = new TreeMap();
    private static final long COMPACTION_CHECK_PERIOD = 120000L;
    private static final long MAX_FREE_BYTES = 0xA00000L;
    private static final long MIN_FREE_BYTES = 0x100000L;
    private long bytesIn = 0L;
    private long bytesOut = 0L;

    protected DirectByteBufferPoolReal() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 12; n <= 25; ++n) {
            arrayList.add(new Integer(BigInteger.valueOf(2L).pow(n).intValue()));
        }
        for (n = 0; n < EXTRA_BUCKETS.length; ++n) {
            arrayList.add(new Integer(EXTRA_BUCKETS[n]));
        }
        Object[] objectArray = new Integer[arrayList.size()];
        arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            ArrayList arrayList2 = new ArrayList();
            this.buffersMap.put(objectArray[i], arrayList2);
        }
        SimpleTimer.addPeriodicEvent("DirectBB:compact", 120000L, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                DirectByteBufferPoolReal.this.compactBuffers();
            }
        });
    }

    private ByteBuffer allocateNewBuffer(int n) {
        try {
            return ByteBuffer.allocateDirect(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.clearBufferPools();
            this.runGarbageCollection();
            try {
                return ByteBuffer.allocateDirect(n);
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                String string = "Memory allocation failed: Out of direct memory space.\nTo fix: Use the -XX:MaxDirectMemorySize=512m command line option,\nor upgrade your Java JRE to version 1.4.2_05 or 1.5 series or newer.";
                Debug.out(string);
                Logger.log(new LogAlert(false, 3, string));
                this.printInUse(true);
                throw outOfMemoryError2;
            }
        }
    }

    protected DirectByteBuffer getBufferSupport(byte by, int n) {
        if (n < 1) {
            Debug.out("requested length [" + n + "] < 1");
            return null;
        }
        if (n > MAX_SIZE) {
            Debug.out("requested length [" + n + "] > MAX_SIZE [" + MAX_SIZE + "]");
            return null;
        }
        return pool.getBufferHelper(by, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectByteBuffer getBufferHelper(byte by, int n) {
        ByteBuffer byteBuffer;
        DirectByteBuffer directByteBuffer;
        if (n <= 2048) {
            directByteBuffer = this.getSliceBuffer(by, n);
        } else {
            byteBuffer = null;
            Integer n2 = new Integer(n);
            for (Integer n3 : this.buffersMap.keySet()) {
                if (n2.compareTo(n3) > 0) continue;
                ArrayList arrayList = (ArrayList)this.buffersMap.get(n3);
                Object object = this.poolsLock;
                synchronized (object) {
                    if (arrayList.isEmpty()) {
                        byteBuffer = this.allocateNewBuffer(n3);
                    } else {
                        ArrayList arrayList2 = arrayList;
                        synchronized (arrayList2) {
                            byteBuffer = (ByteBuffer)arrayList.remove(arrayList.size() - 1);
                        }
                    }
                    break;
                }
            }
            if (byteBuffer == null) {
                Debug.out("Unable to find an appropriate buffer pool");
                throw new RuntimeException("Unable to find an appropriate buffer pool");
            }
            directByteBuffer = new DirectByteBuffer(by, byteBuffer, this);
        }
        byteBuffer = directByteBuffer.getBufferInternal();
        byteBuffer.clear();
        byteBuffer.limit(n);
        this.bytesOut += (long)byteBuffer.capacity();
        return directByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnBufferSupport(DirectByteBuffer directByteBuffer) {
        ByteBuffer byteBuffer = directByteBuffer.getBufferInternal();
        int n = byteBuffer.capacity();
        this.bytesIn += (long)n;
        if (n <= 2048) {
            this.freeSliceBuffer(directByteBuffer);
        } else {
            Integer n2 = new Integer(n);
            ArrayList arrayList = (ArrayList)this.buffersMap.get(n2);
            if (arrayList != null) {
                ArrayList arrayList2 = arrayList;
                synchronized (arrayList2) {
                    arrayList.add(byteBuffer);
                }
            } else {
                Debug.out("Invalid buffer given; could not find proper buffer pool");
            }
        }
    }

    private void clearBufferPools() {
        for (ArrayList arrayList : this.buffersMap.values()) {
            arrayList.clear();
        }
    }

    private void runGarbageCollection() {
        if (!disable_gc) {
            System.runFinalization();
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactBuffers() {
        Object object = this.poolsLock;
        synchronized (object) {
            long l = this.bytesFree();
            if (l < 0x100000L) {
            } else {
                float f = l > 0xA00000L ? 5242880.0f / (float)l : 1.0f - 0.5f * (float)l / 1.048576E7f;
                ArrayList arrayList = new ArrayList(this.buffersMap.values());
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    ArrayList arrayList2 = (ArrayList)arrayList.get(i);
                    int n = (int)((float)arrayList2.size() * f);
                    for (int j = arrayList2.size() - 1; j >= n; --j) {
                        arrayList2.remove(j);
                    }
                }
                this.runGarbageCollection();
            }
        }
        this.compactSlices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long bytesFree() {
        long l = 0L;
        Object object = this.poolsLock;
        synchronized (object) {
            for (Integer n : this.buffersMap.keySet()) {
                ArrayList arrayList = (ArrayList)this.buffersMap.get(n);
                l += (long)(n * arrayList.size());
            }
        }
        return l;
    }

    private void printInUse(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectByteBuffer getSliceBuffer(byte by, int n) {
        List list;
        int n2 = this.getSliceIndex(n);
        List list2 = list = slice_entries[n2];
        synchronized (list2) {
            boolean[] blArray = slice_allocs[n2];
            sliceBuffer sliceBuffer2 = null;
            if (list.size() > 0) {
                sliceBuffer2 = (sliceBuffer)list.remove(0);
                int n3 = n2;
                slice_use_count[n3] = slice_use_count[n3] + 1L;
            } else {
                short s;
                short s2 = -1;
                for (s = 0; s < blArray.length; s = (short)((short)(s + 1))) {
                    if (blArray[s]) continue;
                    s2 = s;
                    break;
                }
                if (s2 != -1) {
                    s = SLICE_ENTRY_SIZES[n2];
                    short s3 = SLICE_ENTRY_ALLOC_SIZES[n2];
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(s * s3);
                    blArray[s2] = true;
                    for (short s4 = 0; s4 < s3; s4 = (short)(s4 + 1)) {
                        byteBuffer.limit((s4 + 1) * s);
                        byteBuffer.position(s4 * s);
                        ByteBuffer byteBuffer2 = byteBuffer.slice();
                        sliceBuffer sliceBuffer3 = new sliceBuffer(byteBuffer2, s2, s4);
                        if (s4 == 0) {
                            sliceBuffer2 = sliceBuffer3;
                            int n4 = n2;
                            slice_use_count[n4] = slice_use_count[n4] + 1L;
                            continue;
                        }
                        list.add(sliceBuffer3);
                    }
                } else {
                    if (!slice_alloc_fails[n2]) {
                        DirectByteBufferPoolReal.slice_alloc_fails[n2] = true;
                        Debug.out("Run out of slice space for '" + SLICE_ENTRY_SIZES[n2] + ", reverting to normal allocation");
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                    return new DirectByteBuffer(by, byteBuffer, this);
                }
            }
            sliceDBB sliceDBB2 = new sliceDBB(by, sliceBuffer2);
            return sliceDBB2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSliceBuffer(DirectByteBuffer directByteBuffer) {
        if (directByteBuffer instanceof sliceDBB) {
            List list;
            int n = this.getSliceIndex(directByteBuffer.getBufferInternal().capacity());
            List list2 = list = slice_entries[n];
            synchronized (list2) {
                list.add(0, ((sliceDBB)directByteBuffer).getSliceBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactSlices() {
        for (int i = 0; i < slice_entries.length; ++i) {
            int n = SLICE_ENTRY_ALLOC_SIZES[i];
            List list = slice_entries[i];
            if (list.size() < n) continue;
            List list2 = list;
            synchronized (list2) {
                sliceBuffer sliceBuffer2;
                Collections.sort(list, new Comparator(){

                    public int compare(Object object, Object object2) {
                        sliceBuffer sliceBuffer2 = (sliceBuffer)object;
                        sliceBuffer sliceBuffer3 = (sliceBuffer)object2;
                        int n = sliceBuffer2.getAllocID() - sliceBuffer3.getAllocID();
                        if (n == 0) {
                            n = sliceBuffer2.getSliceID() - sliceBuffer3.getSliceID();
                        }
                        return n;
                    }
                });
                boolean[] blArray = slice_allocs[i];
                Iterator iterator = list.iterator();
                short s = -1;
                int n2 = 0;
                boolean bl = false;
                while (iterator.hasNext()) {
                    sliceBuffer2 = (sliceBuffer)iterator.next();
                    short s2 = sliceBuffer2.getAllocID();
                    if (s2 != s) {
                        if (n2 == n) {
                            bl = true;
                            blArray[s2] = false;
                        }
                        s = s2;
                        n2 = 1;
                        continue;
                    }
                    ++n2;
                }
                if (n2 == n) {
                    bl = true;
                    blArray[s] = false;
                }
                if (bl) {
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        sliceBuffer2 = (sliceBuffer)iterator.next();
                        if (blArray[sliceBuffer2.getAllocID()]) continue;
                        iterator.remove();
                    }
                }
                continue;
            }
        }
    }

    private int getSliceIndex(int n) {
        for (int i = 0; i < SLICE_ENTRY_SIZES.length; ++i) {
            if (n > SLICE_ENTRY_SIZES[i]) continue;
            return i;
        }
        Debug.out("eh?");
        return 0;
    }

    static {
        int n;
        disable_gc = System.getProperty("az.disable.explicit.gc", "0").equals("1");
        if (disable_gc) {
            System.out.println("Explicit GC disabled");
        }
        EXTRA_BUCKETS = new int[]{16512};
        MAX_SIZE = BigInteger.valueOf(2L).pow(25).intValue();
        pool = new DirectByteBufferPoolReal();
        SLICE_ENTRY_SIZES = new short[]{8, 16, 32, 64, 128, 256, 512, 1024, 2048};
        SLICE_ALLOC_MAXS = new short[]{256, 256, 128, 64, 64, 64, 64, 64, 64};
        SLICE_ENTRY_ALLOC_SIZES = new short[SLICE_ENTRY_SIZES.length];
        slice_entries = new List[SLICE_ENTRY_SIZES.length];
        slice_allocs = new boolean[SLICE_ENTRY_SIZES.length][];
        slice_alloc_fails = new boolean[SLICE_ENTRY_SIZES.length];
        int n2 = COConfigurationManager.getIntParameter("memory.slice.limit.multiplier");
        if (n2 > 1) {
            n = 0;
            while (n < SLICE_ALLOC_MAXS.length) {
                int n3 = n++;
                SLICE_ALLOC_MAXS[n3] = (short)(SLICE_ALLOC_MAXS[n3] * n2);
            }
        }
        for (n = 0; n < SLICE_ENTRY_SIZES.length; ++n) {
            DirectByteBufferPoolReal.SLICE_ENTRY_ALLOC_SIZES[n] = (short)(4096 / SLICE_ENTRY_SIZES[n]);
            DirectByteBufferPoolReal.slice_allocs[n] = new boolean[SLICE_ALLOC_MAXS[n]];
            DirectByteBufferPoolReal.slice_entries[n] = new LinkedList();
        }
        slice_use_count = new long[SLICE_ENTRY_SIZES.length];
    }

    private static class myInteger {
        int value;

        private myInteger() {
        }
    }

    private static class sliceDBB
    extends DirectByteBuffer {
        private sliceBuffer slice_buffer;

        protected sliceDBB(byte by, sliceBuffer sliceBuffer2) {
            super(by, sliceBuffer2.getBuffer(), pool);
            this.slice_buffer = sliceBuffer2;
        }

        protected sliceBuffer getSliceBuffer() {
            return this.slice_buffer;
        }
    }

    private static class sliceBuffer {
        private ByteBuffer buffer;
        private short alloc_id;
        private short slice_id;

        protected sliceBuffer(ByteBuffer byteBuffer, short s, short s2) {
            this.buffer = byteBuffer;
            this.alloc_id = s;
            this.slice_id = s2;
        }

        protected ByteBuffer getBuffer() {
            return this.buffer;
        }

        protected short getAllocID() {
            return this.alloc_id;
        }

        protected short getSliceID() {
            return this.slice_id;
        }
    }
}

