/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.MD4Hasher;

public class ED2KHasher {
    public static final int BLOCK_SIZE = 9728000;
    protected MD4Hasher current_hasher = new MD4Hasher();
    protected MD4Hasher block_hasher;
    protected int current_bytes;

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = n2;
        while (n3 > 0) {
            int n4 = 9728000 - this.current_bytes;
            if (n3 <= n4) {
                this.current_hasher.update(byArray, n, n3);
                this.current_bytes += n3;
                break;
            }
            if (this.block_hasher == null) {
                this.block_hasher = new MD4Hasher();
            }
            if (n4 == 0) {
                this.block_hasher.update(this.current_hasher.getDigest());
                this.current_hasher = new MD4Hasher();
                this.current_bytes = 0;
                continue;
            }
            this.current_hasher.update(byArray, n, n4);
            n += n4;
            n3 -= n4;
            this.current_bytes += n4;
        }
    }

    public byte[] getDigest() {
        if (this.current_bytes == 9728000) {
            if (this.block_hasher == null) {
                this.block_hasher = new MD4Hasher();
            }
            this.block_hasher.update(this.current_hasher.getDigest());
            this.current_hasher = new MD4Hasher();
        }
        if (this.block_hasher == null) {
            return this.current_hasher.getDigest();
        }
        if (this.current_bytes > 0) {
            this.block_hasher.update(this.current_hasher.getDigest());
        }
        return this.block_hasher.getDigest();
    }
}

