/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager<T> {
    private static final boolean TIME_LISTENERS = false;
    protected String name;
    protected ListenerManagerDispatcher<T> target;
    protected ListenerManagerDispatcherWithException target_with_exception;
    protected boolean async;
    protected AEThread2 async_thread;
    protected List<T> listeners = new ArrayList<T>(0);
    protected List<Object[]> dispatch_queue;
    protected AESemaphore dispatch_sem;

    public static <T> ListenerManager<T> createManager(String string, ListenerManagerDispatcher<T> listenerManagerDispatcher) {
        return new ListenerManager<T>(string, listenerManagerDispatcher, false);
    }

    public static <T> ListenerManager<T> createAsyncManager(String string, ListenerManagerDispatcher<T> listenerManagerDispatcher) {
        return new ListenerManager<T>(string, listenerManagerDispatcher, true);
    }

    protected ListenerManager(String string, ListenerManagerDispatcher<T> listenerManagerDispatcher, boolean bl) {
        this.name = string;
        this.target = listenerManagerDispatcher;
        this.async = bl;
        if (this.target instanceof ListenerManagerDispatcherWithException) {
            this.target_with_exception = (ListenerManagerDispatcherWithException)this.target;
        }
        if (this.async) {
            this.dispatch_sem = new AESemaphore("ListenerManager::" + this.name);
            this.dispatch_queue = new LinkedList<Object[]>();
            if (this.target_with_exception != null) {
                throw new RuntimeException("Can't have an async manager with exceptions!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(T t) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList<T> arrayList = new ArrayList<T>(this.listeners);
            if (arrayList.contains(t)) {
                Logger.log(new LogEvent(LogIDs.CORE, 1, "addListener called but listener already added for " + this.name + "\n\t" + Debug.getStackTrace(true, false)));
            }
            arrayList.add(t);
            if (arrayList.size() > 50) {
                Logger.log(new LogEvent(LogIDs.CORE, 1, "addListener: over 50 listeners added for " + this.name + "\n\t" + Debug.getStackTrace(true, false)));
            }
            this.listeners = arrayList;
            if (this.async && this.async_thread == null) {
                this.async_thread = new AEThread2(this.name, true){

                    public void run() {
                        ListenerManager.this.dispatchLoop();
                    }
                };
                this.async_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object object) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList<T> arrayList = new ArrayList<T>(this.listeners);
            arrayList.remove(object);
            this.listeners = arrayList;
            if (this.async && this.listeners.size() == 0) {
                this.async_thread = null;
                this.dispatch_sem.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListener(T t) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            return this.listeners.contains(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            this.listeners = new ArrayList<T>();
            if (this.async) {
                this.async_thread = null;
                this.dispatch_sem.release();
            }
        }
    }

    public List<T> getListenersCopy() {
        return this.listeners;
    }

    public void dispatch(int n, Object object) {
        this.dispatch(n, object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(int n, Object object, boolean bl) {
        if (this.async) {
            AESemaphore aESemaphore = null;
            if (bl) {
                aESemaphore = new AESemaphore("ListenerManager:blocker");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.listeners.size() == 0) {
                    return;
                }
                this.dispatch_queue.add(new Object[]{this.listeners, new Integer(n), object, aESemaphore});
            }
            this.dispatch_sem.release();
            if (aESemaphore != null) {
                aESemaphore.reserve();
            }
        } else {
            List<T> list;
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                list = this.listeners;
            }
            try {
                this.dispatchInternal((T)list, n, object);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchWithException(int n, Object object) throws Throwable {
        List<T> list;
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            list = this.listeners;
        }
        this.dispatchInternal((T)list, n, object);
    }

    public void dispatch(T t, int n, Object object) {
        this.dispatch(t, n, object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(T t, int n, Object object, boolean bl) {
        if (this.async) {
            AESemaphore aESemaphore = null;
            if (bl) {
                aESemaphore = new AESemaphore("ListenerManager:blocker");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                this.dispatch_queue.add(new Object[]{t, new Integer(n), object, aESemaphore, null});
                if (this.async_thread == null) {
                    this.async_thread = new AEThread2(this.name, true){

                        public void run() {
                            ListenerManager.this.dispatchLoop();
                        }
                    };
                    this.async_thread.start();
                }
            }
            this.dispatch_sem.release();
            if (aESemaphore != null) {
                aESemaphore.reserve();
            }
        } else {
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            this.doDispatch(t, n, object);
        }
    }

    protected String getListenerName(T t) {
        Class<?> clazz = t.getClass();
        String string = clazz.getName();
        try {
            Method method = clazz.getMethod("getString", new Class[0]);
            if (method != null) {
                String string2 = (String)method.invoke(t, new Object[0]);
                string = string + " (" + string2 + ")";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    protected void doDispatch(T t, int n, Object object) {
        try {
            this.target.dispatch(t, n, object);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void doDispatchWithException(T t, int n, Object object) throws Throwable {
        this.target_with_exception.dispatchWithException(t, n, object);
    }

    protected void dispatchInternal(List<T> list, int n, Object object) throws Throwable {
        for (int i = 0; i < list.size(); ++i) {
            if (this.target_with_exception != null) {
                this.doDispatchWithException(list.get(i), n, object);
                continue;
            }
            this.doDispatch(list.get(i), n, object);
        }
    }

    protected void dispatchInternal(T t, int n, Object object) throws Throwable {
        if (this.target_with_exception != null) {
            this.doDispatchWithException(t, n, object);
        } else {
            this.doDispatch(t, n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchLoop() {
        while (true) {
            this.dispatch_sem.reserve();
            Object[] objectArray = null;
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.async_thread == null || !this.async_thread.isCurrentThread()) {
                    this.dispatch_sem.release();
                    return;
                }
                if (this.dispatch_queue.size() > 0) {
                    objectArray = this.dispatch_queue.remove(0);
                }
                if (objectArray == null) continue;
            }
            try {
                if (objectArray.length == 4) {
                    this.dispatchInternal((T)((List)objectArray[0]), (int)((Integer)objectArray[1]), objectArray[2]);
                    continue;
                }
                this.dispatchInternal(objectArray[0], (int)((Integer)objectArray[1]), objectArray[2]);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                continue;
            }
            finally {
                if (objectArray[3] == null) continue;
                ((AESemaphore)objectArray[3]).release();
                continue;
            }
            break;
        }
    }

    public static <T> void dispatchWithTimeout(List<T> list, final ListenerManagerDispatcher<T> listenerManagerDispatcher, long l) {
        int n;
        final ArrayList<T> arrayList = new ArrayList<T>(list);
        final boolean[] blArray = new boolean[arrayList.size()];
        final AESemaphore aESemaphore = new AESemaphore("ListenerManager:dwt:timeout");
        int n2 = 0;
        while (n2 < arrayList.size()) {
            n = n2++;
            new AEThread2("ListenerManager:dwt:dispatcher", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        listenerManagerDispatcher.dispatch(arrayList.get(n), -1, null);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                    finally {
                        blArray[n] = true;
                        aESemaphore.release();
                    }
                }
            }.start();
        }
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (l <= 0L) {
                n2 = 1;
                break;
            }
            long l2 = SystemTime.getCurrentTime();
            if (!aESemaphore.reserve(l)) {
                n2 = 1;
                break;
            }
            long l3 = SystemTime.getCurrentTime();
            if (l3 <= l2) continue;
            l -= l3 - l2;
        }
        if (n2 != 0) {
            String string = "";
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                string = string + (string.length() == 0 ? "" : ",") + arrayList.get(i);
            }
            if (string.length() > 0) {
                Debug.out("Listener dispatch timeout: failed = " + string);
            }
        }
    }

    public long size() {
        if (this.listeners == null) {
            return 0L;
        }
        return this.listeners.size();
    }
}

