/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class MD5 {
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int length;
    private ByteBuffer finalBuffer = ByteBuffer.allocate(64);

    public MD5() {
        this.finalBuffer.position(0);
        this.finalBuffer.limit(64);
        this.reset();
    }

    public void transform(ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        int n6 = byteBuffer.getInt();
        int n7 = byteBuffer.getInt();
        int n8 = byteBuffer.getInt();
        int n9 = byteBuffer.getInt();
        int n10 = byteBuffer.getInt();
        int n11 = byteBuffer.getInt();
        int n12 = byteBuffer.getInt();
        int n13 = byteBuffer.getInt();
        int n14 = byteBuffer.getInt();
        int n15 = byteBuffer.getInt();
        int n16 = byteBuffer.getInt();
        byteBuffer.order(byteOrder);
        int n17 = this.h0;
        int n18 = this.h1;
        int n19 = this.h2;
        int n20 = this.h3;
        n17 += (n18 & n19 | ~n18 & n20) + n + -680876936;
        n17 = n18 + (n17 << 7 | n17 >>> 25);
        n20 += (n17 & n18 | ~n17 & n19) + n2 + -389564586;
        n20 = n17 + (n20 << 12 | n20 >>> 20);
        n19 += (n20 & n17 | ~n20 & n18) + n3 + 606105819;
        n19 = n20 + (n19 << 17 | n19 >>> 15);
        n18 += (n19 & n20 | ~n19 & n17) + n4 + -1044525330;
        n18 = n19 + (n18 << 22 | n18 >>> 10);
        n17 += (n18 & n19 | ~n18 & n20) + n5 + -176418897;
        n17 = n18 + (n17 << 7 | n17 >>> 25);
        n20 += (n17 & n18 | ~n17 & n19) + n6 + 1200080426;
        n20 = n17 + (n20 << 12 | n20 >>> 20);
        n19 += (n20 & n17 | ~n20 & n18) + n7 + -1473231341;
        n19 = n20 + (n19 << 17 | n19 >>> 15);
        n18 += (n19 & n20 | ~n19 & n17) + n8 + -45705983;
        n18 = n19 + (n18 << 22 | n18 >>> 10);
        n17 += (n18 & n19 | ~n18 & n20) + n9 + 1770035416;
        n17 = n18 + (n17 << 7 | n17 >>> 25);
        n20 += (n17 & n18 | ~n17 & n19) + n10 + -1958414417;
        n20 = n17 + (n20 << 12 | n20 >>> 20);
        n19 += (n20 & n17 | ~n20 & n18) + n11 + -42063;
        n19 = n20 + (n19 << 17 | n19 >>> 15);
        n18 += (n19 & n20 | ~n19 & n17) + n12 + -1990404162;
        n18 = n19 + (n18 << 22 | n18 >>> 10);
        n17 += (n18 & n19 | ~n18 & n20) + n13 + 1804603682;
        n17 = n18 + (n17 << 7 | n17 >>> 25);
        n20 += (n17 & n18 | ~n17 & n19) + n14 + -40341101;
        n20 = n17 + (n20 << 12 | n20 >>> 20);
        n19 += (n20 & n17 | ~n20 & n18) + n15 + -1502002290;
        n19 = n20 + (n19 << 17 | n19 >>> 15);
        n18 += (n19 & n20 | ~n19 & n17) + n16 + 1236535329;
        n18 = n19 + (n18 << 22 | n18 >>> 10);
        n17 += (n18 & n20 | n19 & ~n20) + n2 + -165796510;
        n17 = n18 + (n17 << 5 | n17 >>> 27);
        n20 += (n17 & n19 | n18 & ~n19) + n7 + -1069501632;
        n20 = n17 + (n20 << 9 | n20 >>> 23);
        n19 += (n20 & n18 | n17 & ~n18) + n12 + 643717713;
        n19 = n20 + (n19 << 14 | n19 >>> 18);
        n18 += (n19 & n17 | n20 & ~n17) + n + -373897302;
        n18 = n19 + (n18 << 20 | n18 >>> 12);
        n17 += (n18 & n20 | n19 & ~n20) + n6 + -701558691;
        n17 = n18 + (n17 << 5 | n17 >>> 27);
        n20 += (n17 & n19 | n18 & ~n19) + n11 + 38016083;
        n20 = n17 + (n20 << 9 | n20 >>> 23);
        n19 += (n20 & n18 | n17 & ~n18) + n16 + -660478335;
        n19 = n20 + (n19 << 14 | n19 >>> 18);
        n18 += (n19 & n17 | n20 & ~n17) + n5 + -405537848;
        n18 = n19 + (n18 << 20 | n18 >>> 12);
        n17 += (n18 & n20 | n19 & ~n20) + n10 + 568446438;
        n17 = n18 + (n17 << 5 | n17 >>> 27);
        n20 += (n17 & n19 | n18 & ~n19) + n15 + -1019803690;
        n20 = n17 + (n20 << 9 | n20 >>> 23);
        n19 += (n20 & n18 | n17 & ~n18) + n4 + -187363961;
        n19 = n20 + (n19 << 14 | n19 >>> 18);
        n18 += (n19 & n17 | n20 & ~n17) + n9 + 1163531501;
        n18 = n19 + (n18 << 20 | n18 >>> 12);
        n17 += (n18 & n20 | n19 & ~n20) + n14 + -1444681467;
        n17 = n18 + (n17 << 5 | n17 >>> 27);
        n20 += (n17 & n19 | n18 & ~n19) + n3 + -51403784;
        n20 = n17 + (n20 << 9 | n20 >>> 23);
        n19 += (n20 & n18 | n17 & ~n18) + n8 + 1735328473;
        n19 = n20 + (n19 << 14 | n19 >>> 18);
        n18 += (n19 & n17 | n20 & ~n17) + n13 + -1926607734;
        n18 = n19 + (n18 << 20 | n18 >>> 12);
        n17 += (n18 ^ n19 ^ n20) + n6 + -378558;
        n17 = n18 + (n17 << 4 | n17 >>> 28);
        n20 += (n17 ^ n18 ^ n19) + n9 + -2022574463;
        n20 = n17 + (n20 << 11 | n20 >>> 21);
        n19 += (n20 ^ n17 ^ n18) + n12 + 1839030562;
        n19 = n20 + (n19 << 16 | n19 >>> 16);
        n18 += (n19 ^ n20 ^ n17) + n15 + -35309556;
        n18 = n19 + (n18 << 23 | n18 >>> 9);
        n17 += (n18 ^ n19 ^ n20) + n2 + -1530992060;
        n17 = n18 + (n17 << 4 | n17 >>> 28);
        n20 += (n17 ^ n18 ^ n19) + n5 + 1272893353;
        n20 = n17 + (n20 << 11 | n20 >>> 21);
        n19 += (n20 ^ n17 ^ n18) + n8 + -155497632;
        n19 = n20 + (n19 << 16 | n19 >>> 16);
        n18 += (n19 ^ n20 ^ n17) + n11 + -1094730640;
        n18 = n19 + (n18 << 23 | n18 >>> 9);
        n17 += (n18 ^ n19 ^ n20) + n14 + 681279174;
        n17 = n18 + (n17 << 4 | n17 >>> 28);
        n20 += (n17 ^ n18 ^ n19) + n + -358537222;
        n20 = n17 + (n20 << 11 | n20 >>> 21);
        n19 += (n20 ^ n17 ^ n18) + n4 + -722521979;
        n19 = n20 + (n19 << 16 | n19 >>> 16);
        n18 += (n19 ^ n20 ^ n17) + n7 + 76029189;
        n18 = n19 + (n18 << 23 | n18 >>> 9);
        n17 += (n18 ^ n19 ^ n20) + n10 + -640364487;
        n17 = n18 + (n17 << 4 | n17 >>> 28);
        n20 += (n17 ^ n18 ^ n19) + n13 + -421815835;
        n20 = n17 + (n20 << 11 | n20 >>> 21);
        n19 += (n20 ^ n17 ^ n18) + n16 + 530742520;
        n19 = n20 + (n19 << 16 | n19 >>> 16);
        n18 += (n19 ^ n20 ^ n17) + n3 + -995338651;
        n18 = n19 + (n18 << 23 | n18 >>> 9);
        n17 += (n19 ^ (n18 | ~n20)) + n + -198630844;
        n17 = n18 + (n17 << 6 | n17 >>> 26);
        n20 += (n18 ^ (n17 | ~n19)) + n8 + 1126891415;
        n20 = n17 + (n20 << 10 | n20 >>> 22);
        n19 += (n17 ^ (n20 | ~n18)) + n15 + -1416354905;
        n19 = n20 + (n19 << 15 | n19 >>> 17);
        n18 += (n20 ^ (n19 | ~n17)) + n6 + -57434055;
        n18 = n19 + (n18 << 21 | n18 >>> 11);
        n17 += (n19 ^ (n18 | ~n20)) + n13 + 1700485571;
        n17 = n18 + (n17 << 6 | n17 >>> 26);
        n20 += (n18 ^ (n17 | ~n19)) + n4 + -1894986606;
        n20 = n17 + (n20 << 10 | n20 >>> 22);
        n19 += (n17 ^ (n20 | ~n18)) + n11 + -1051523;
        n19 = n20 + (n19 << 15 | n19 >>> 17);
        n18 += (n20 ^ (n19 | ~n17)) + n2 + -2054922799;
        n18 = n19 + (n18 << 21 | n18 >>> 11);
        n17 += (n19 ^ (n18 | ~n20)) + n9 + 1873313359;
        n17 = n18 + (n17 << 6 | n17 >>> 26);
        n20 += (n18 ^ (n17 | ~n19)) + n16 + -30611744;
        n20 = n17 + (n20 << 10 | n20 >>> 22);
        n19 += (n17 ^ (n20 | ~n18)) + n7 + -1560198380;
        n19 = n20 + (n19 << 15 | n19 >>> 17);
        n18 += (n20 ^ (n19 | ~n17)) + n14 + 1309151649;
        n18 = n19 + (n18 << 21 | n18 >>> 11);
        n17 += (n19 ^ (n18 | ~n20)) + n5 + -145523070;
        n17 = n18 + (n17 << 6 | n17 >>> 26);
        n20 += (n18 ^ (n17 | ~n19)) + n12 + -1120210379;
        n20 = n17 + (n20 << 10 | n20 >>> 22);
        n19 += (n17 ^ (n20 | ~n18)) + n3 + 718787259;
        n19 = n20 + (n19 << 15 | n19 >>> 17);
        n18 += (n20 ^ (n19 | ~n17)) + n10 + -343485551;
        n18 = n19 + (n18 << 21 | n18 >>> 11);
        this.h0 += n17;
        this.h1 += n18;
        this.h2 += n19;
        this.h3 += n20;
    }

    public void reset() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.length = 0;
        this.finalBuffer.clear();
    }

    private void completeFinalBuffer(ByteBuffer byteBuffer) {
        if (this.finalBuffer.position() == 0) {
            return;
        }
        while (byteBuffer.remaining() > 0 && this.finalBuffer.remaining() > 0) {
            this.finalBuffer.put(byteBuffer.get());
        }
        if (this.finalBuffer.remaining() == 0) {
            this.finalBuffer.position(0);
            this.transform(this.finalBuffer);
            this.finalBuffer.position(0);
        }
    }

    public void update(ByteBuffer byteBuffer) {
        this.length += byteBuffer.remaining();
        int n = byteBuffer.position();
        this.completeFinalBuffer(byteBuffer);
        while (byteBuffer.remaining() >= 64) {
            this.transform(byteBuffer);
        }
        if (byteBuffer.remaining() != 0) {
            this.finalBuffer.put(byteBuffer);
        }
        byteBuffer.position(n);
    }

    public byte[] digest() {
        byte[] byArray = new byte[16];
        this.finalBuffer.put((byte)-128);
        if (this.finalBuffer.remaining() < 8) {
            while (this.finalBuffer.remaining() > 0) {
                this.finalBuffer.put((byte)0);
            }
            this.finalBuffer.position(0);
            this.transform(this.finalBuffer);
            this.finalBuffer.position(0);
        }
        while (this.finalBuffer.remaining() > 8) {
            this.finalBuffer.put((byte)0);
        }
        this.finalBuffer.putLong(this.length << 3);
        this.finalBuffer.position(0);
        this.transform(this.finalBuffer);
        this.finalBuffer.position(0);
        this.finalBuffer.putInt(this.h3);
        this.finalBuffer.putInt(this.h2);
        this.finalBuffer.putInt(this.h1);
        this.finalBuffer.putInt(this.h0);
        this.finalBuffer.position(0);
        for (int i = 0; i < 16; ++i) {
            byArray[15 - i] = this.finalBuffer.get();
        }
        return byArray;
    }

    public byte[] digest(ByteBuffer byteBuffer) {
        this.update(byteBuffer);
        return this.digest();
    }

    public static void main(String[] stringArray) throws Exception {
        MD5 mD5 = new MD5();
        BrokenMd5Hasher brokenMd5Hasher = new BrokenMd5Hasher();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        System.out.println("Gudy : " + ByteFormatter.nicePrint(mD5.digest()));
        mD5.reset();
        brokenMd5Hasher.finalDigest(byteBuffer);
        byteBuffer.rewind();
        byte[] byArray = byteBuffer.array();
        System.out.println("Jmule: " + ByteFormatter.nicePrint(byArray));
        System.out.println("Sun: " + ByteFormatter.nicePrint(messageDigest.digest()));
        for (int i = 0; i < 1; ++i) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(i);
            while (byteBuffer2.remaining() > 0) {
                byteBuffer2.put((byte)(Math.random() * 256.0));
            }
            byteBuffer2.rewind();
            byte[] byArray2 = mD5.digest(byteBuffer2);
            mD5.reset();
            brokenMd5Hasher.update(byteBuffer2);
            byteBuffer.rewind();
            brokenMd5Hasher.finalDigest(byteBuffer);
            byteBuffer.rewind();
            byArray = byteBuffer.array();
            byteBuffer2.rewind();
            messageDigest.update(byteBuffer2.array());
            byte[] byArray3 = messageDigest.digest();
            System.out.println("Gudy : " + ByteFormatter.nicePrint(byArray2));
            System.out.println("Jmule: " + ByteFormatter.nicePrint(byArray));
            System.out.println("Sun: " + ByteFormatter.nicePrint(byArray3));
        }
    }
}

