/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.security.SecureRandom;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class RandomUtils {
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final int LISTEN_PORT_MIN = 10000;
    public static final int LISTEN_PORT_MAX = 65535;

    public static byte[] generateRandomBytes(int n) {
        byte[] byArray = new byte[n];
        RANDOM.nextBytes(byArray);
        return byArray;
    }

    public static String generateRandomAlphanumerics(int n) {
        String string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(RANDOM.nextDouble() * (double)string.length());
            stringBuffer.append(string.charAt(n2));
        }
        return stringBuffer.toString();
    }

    public static int generateRandomNetworkListenPort() {
        int n;
        int n2;
        int n3 = COConfigurationManager.getIntParameter("TCP.Listen.Port");
        int n4 = COConfigurationManager.getIntParameter("UDP.Listen.Port");
        int n5 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port");
        while ((n2 = (n = 10000) + RANDOM.nextInt(65536 - n)) >= 45100 && n2 <= 45110 || n2 == n3 || n2 == n4 || n2 == n5) {
        }
        return n2;
    }

    public static int generateRandomPlusMinus1() {
        return RANDOM.nextBoolean() ? -1 : 1;
    }

    public static float nextFloat() {
        return RANDOM.nextFloat();
    }

    public static void nextBytes(byte[] byArray) {
        RANDOM.nextBytes(byArray);
    }

    public static void nextSecureBytes(byte[] byArray) {
        SECURE_RANDOM.nextBytes(byArray);
    }

    public static byte[] nextSecureHash() {
        byte[] byArray = new byte[20];
        SECURE_RANDOM.nextBytes(byArray);
        return byArray;
    }

    public static byte[] nextHash() {
        byte[] byArray = new byte[20];
        RANDOM.nextBytes(byArray);
        return byArray;
    }

    public static int nextInt(int n) {
        return RANDOM.nextInt(n);
    }

    public static byte nextByte() {
        return (byte)RANDOM.nextInt();
    }

    public static int nextInt() {
        return RANDOM.nextInt();
    }

    public static long nextLong() {
        return RANDOM.nextLong();
    }

    public static int generateRandomIntUpto(int n) {
        return RandomUtils.nextInt(n);
    }

    public static int generateRandomIntBetween(int n, int n2) {
        return n + RandomUtils.generateRandomIntUpto(n2 + 1 - n);
    }
}

