/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;

public abstract class ThreadPoolTask
extends AERunnable {
    static final int RELEASE_AUTO = 0;
    static final int RELEASE_MANUAL = 1;
    static final int RELEASE_MANUAL_ALLOWED = 2;
    int manualRelease;
    protected ThreadPool.threadPoolWorker worker;

    public void setTaskState(String string) {
        this.worker.setState(string);
    }

    public String getTaskState() {
        return this.worker == null ? "" : this.worker.getState();
    }

    public String getName() {
        return null;
    }

    public abstract void interruptTask();

    public void taskStarted() {
    }

    public void taskCompleted() {
    }

    synchronized void join() {
        while (this.manualRelease != 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
        }
    }

    synchronized boolean isAutoReleaseAndAllowManual() {
        if (this.manualRelease == 1) {
            this.manualRelease = 2;
        }
        return this.manualRelease == 0;
    }

    public synchronized void releaseToPool() {
        if (this.manualRelease == 1) {
            this.manualRelease = 0;
        } else if (this.manualRelease == 2) {
            this.taskCompleted();
            this.worker.getOwner().releaseManual(this);
            this.manualRelease = 0;
        } else if (this.manualRelease == 0) {
            Debug.out("this should not happen");
        }
        this.notifyAll();
    }
}

