/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class TimeFormatter {
    static final String[] TIME_SUFFIXES = new String[]{"s", "m", "h", "d", "y"};
    public static final String[] DATEFORMATS_DESC = new String[]{"EEEE, MMMM d, yyyy GG", "EEEE, MMMM d, yyyy", "EEE, MMMM d, yyyy", "MMMM d, ''yy", "EEE, MMM d, ''yy", "MMM d, yyyy", "MMM d, ''yy", "yyyy/MM/dd", "''yy/MM/dd", "MMM dd", "MM/dd"};
    private static final SimpleDateFormat http_date_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public static String format(long l) {
        int n;
        if (l == 31536000L || l >= 1827387392L) {
            return "\u221e";
        }
        if (l < 0L) {
            return "";
        }
        int[] nArray = new int[]{(int)l % 60, (int)(l / 60L) % 60, (int)(l / 3600L) % 24, (int)(l / 86400L) % 365, (int)(l / 31536000L)};
        for (n = nArray.length - 1; nArray[n] == 0 && n > 0; --n) {
        }
        String string = nArray[n] + TIME_SUFFIXES[n];
        if (--n >= 0) {
            string = string + " " + TimeFormatter.twoDigits(nArray[n]) + TIME_SUFFIXES[n];
        }
        return string;
    }

    public static String format100ths(long l) {
        long l2 = l / 1000L;
        int n = (int)(l - l2 * 1000L) / 10;
        if (l == 0L || l2 >= 60L) {
            return TimeFormatter.format(l2);
        }
        return l2 + "." + TimeFormatter.twoDigits(n) + TIME_SUFFIXES[0];
    }

    public static String formatColon(long l) {
        if (l == 31536000L || l >= 1827387392L) {
            return "\u221e";
        }
        if (l < 0L) {
            return "";
        }
        int n = (int)l % 60;
        int n2 = (int)(l / 60L) % 60;
        int n3 = (int)(l / 3600L) % 24;
        int n4 = (int)(l / 86400L) % 365;
        int n5 = (int)(l / 31536000L);
        String string = "";
        if (n5 > 0) {
            string = string + n5 + "y ";
        }
        if (n5 > 0 || n4 > 0) {
            string = string + n4 + "d ";
        }
        string = string + TimeFormatter.twoDigits(n3) + ":" + TimeFormatter.twoDigits(n2) + ":" + TimeFormatter.twoDigits(n);
        return string;
    }

    private static String twoDigits(int n) {
        return n < 10 ? "0" + n : String.valueOf(n);
    }

    public static int parseColon(String string) {
        int[] nArray = new int[]{1, 60, 3600, 86400, 31536000};
        String[] stringArray = string.split(":");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[stringArray.length - (i + 1)].trim();
            if (string2.length() <= 0) continue;
            n += nArray[i] * Integer.parseInt(string2);
        }
        return n;
    }

    public static String formatNanoAsMilli(long l) {
        l -= l / 60000000000L * 60000000000L;
        return String.valueOf((double)l / 1000000.0) + " ms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHTTPDate(long l) {
        SimpleDateFormat simpleDateFormat = http_date_format;
        synchronized (simpleDateFormat) {
            return http_date_format.format(new Date(l));
        }
    }

    public static long parseHTTPDate(String string) {
        try {
            return http_date_format.parse(string).getTime();
        }
        catch (Throwable throwable) {
            Debug.out("Failed to parse HTTP date '" + string + "'");
            return 0L;
        }
    }

    public static String milliStamp() {
        long l = SystemTime.getHighPrecisionCounter();
        l -= l / 60000000000L * 60000000000L;
        String string = String.valueOf(l / 1000000L);
        while (string.length() < 5) {
            string = "0" + string;
        }
        return string + ": ";
    }

    public static void milliTrace(String string) {
        System.out.println(TimeFormatter.milliStamp() + string);
    }

    static {
        http_date_format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

