/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploader;

public class UrlUtils {
    private static final ThreadPool connect_pool = new ThreadPool("URLConnectWithTimeout", 8, true);
    private static final String[] prefixes;
    private static int MAGNETURL_STARTS_AT;
    private static final Object[] XMLescapes;
    private static String last_headers;
    private static final String default_headers = "SG9zdDogbG9jYWxob3N0OjQ1MTAwClVzZXItQWdlbnQ6IE1vemlsbGEvNS4wIChXaW5kb3dzOyBVOyBXaW5kb3dzIE5UIDUuMTsgZW4tVVM7IHJ2OjEuOC4xLjE0KSBHZWNrby8yMDA4MDQwNCBGaXJlZm94LzIuMC4wLjE0CkFjY2VwdDogdGV4dC94bWwsYXBwbGljYXRpb24veG1sLGFwcGxpY2F0aW9uL3hodG1sK3htbCx0ZXh0L2h0bWw7cT0wLjksdGV4dC9wbGFpbjtxPTAuOCxpbWFnZS9wbmcsKi8qO3E9MC41CkFjY2VwdC1MYW5ndWFnZTogZW4tdXMsZW47cT0wLjUKQWNjZXB0LUVuY29kaW5nOiBnemlwLGRlZmxhdGUKQWNjZXB0LUNoYXJzZXQ6IElTTy04ODU5LTEsdXRmLTg7cT0wLjcsKjtxPTAuNwpLZWVwLUFsaXZlOiAzMDAKQ29ubmVjdGlvbjoga2VlcC1hbGl2ZQ==";

    public static String getMagnetURI(byte[] byArray) {
        return "magnet:?xt=urn:btih:" + Base32.encode(byArray);
    }

    public static String normaliseMagnetURI(String string) {
        byte[] byArray = UrlUtils.decodeSHA1Hash(string);
        if (byArray != null) {
            return UrlUtils.getMagnetURI(byArray);
        }
        return null;
    }

    public static byte[] decodeSHA1Hash(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        byte[] byArray = null;
        try {
            if (string.length() == 40) {
                byArray = ByteFormatter.decodeString(string);
            } else if (string.length() == 32) {
                byArray = Base32.decode(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (byArray != null && byArray.length != 20) {
            byArray = null;
        }
        return byArray;
    }

    public static boolean isURL(String string) {
        return UrlUtils.parseTextForURL(string, true) != null;
    }

    public static boolean isURL(String string, boolean bl) {
        return UrlUtils.parseTextForURL(string, true, bl) != null;
    }

    public static String parseTextForURL(String string, boolean bl) {
        return UrlUtils.parseTextForURL(string, bl, true);
    }

    public static String getURL(String string) {
        return UrlUtils.parseTextForURL(string, false, false);
    }

    public static String parseTextForURL(String string, boolean bl, boolean bl2) {
        Object object;
        String string2;
        String string3;
        if (string == null || string.length() < 5) {
            return null;
        }
        String string4 = UrlUtils.parseHTMLforURL(string);
        if (string4 != null) {
            return string4;
        }
        try {
            string = string.trim();
            string = URLDecoder.decode(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string3 = string.toLowerCase();
        }
        catch (Throwable throwable) {
            string3 = string;
        }
        int n = bl ? prefixes.length : MAGNETURL_STARTS_AT;
        int n2 = -1;
        int n3 = string3.length();
        String string5 = null;
        for (int i = 0; i < n; ++i) {
            int n4 = string3.indexOf(prefixes[i]);
            if (n4 < 0 || n4 >= n3) continue;
            n2 = string.indexOf("\n", n4 + prefixes[i].length());
            string2 = n2 >= 0 ? string.substring(n4, n2 - 1) : string.substring(n4);
            try {
                object = new URL(string2);
                string5 = ((URL)object).toExternalForm();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                if (i < MAGNETURL_STARTS_AT) continue;
                string5 = string2;
            }
        }
        if (string5 != null) {
            return string5;
        }
        if (new File(string).exists()) {
            return null;
        }
        if (bl && string.matches("^[a-fA-F0-9]{40}$")) {
            byte[] byArray = ByteFormatter.decodeString(string.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(byArray);
        }
        if (bl && string.matches("^[a-zA-Z2-7]{32}$")) {
            return "magnet:?xt=urn:btih:" + string;
        }
        if (bl && bl2) {
            Pattern pattern = Pattern.compile("[^a-zA-Z2-7][a-zA-Z2-7]{32}[^a-zA-Z2-7]");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                string2 = string.substring(matcher.start() + 1, matcher.start() + 33);
                return "magnet:?xt=urn:btih:" + string2;
            }
            pattern = Pattern.compile("[^a-fA-F0-9][a-fA-F0-9]{40}[^a-fA-F0-9]");
            matcher = pattern.matcher(string);
            if (matcher.find()) {
                string2 = string.substring(matcher.start() + 1, matcher.start() + 41);
                object = ByteFormatter.decodeString(string2.toUpperCase());
                return "magnet:?xt=urn:btih:" + Base32.encode((byte[])object);
            }
        }
        return null;
    }

    public static String parseHTMLforURL(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("<.*a\\s++.*href=\"?([^\\'\"\\s>]++).*", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                string2 = URLDecoder.decode(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        MagnetURIHandler.getSingleton();
        byte[] byArray = ByteFormatter.decodeString("1234567890123456789012345678901234567890");
        String[] stringArray2 = new String[]{"http://moo.com", "http%3A%2F/moo%2Ecom", "magnet:?moo", "magnet%3A%3Fxt=urn:btih:26", "magnet%3A//%3Fmooo", "magnet:?xt=urn:btih:" + Base32.encode(byArray), "aaaaaaaaaabbbbbbbbbbccccccccccdddddddddd", "magnet:?dn=OpenOffice.org_2.0.3_Win32Intel_install.exe&xt=urn:sha1:PEMIGLKMNFI4HZ4CCHZNPKZJNMAAORKN&xt=urn:tree:tiger:JMIJVWHCQUX47YYH7O4XIBCORNU2KYKHBBC6DHA&xt=urn:ed2k:1c0804541f34b6583a383bb8f2cec682&xl=96793015&xs=http://mirror.switch.ch/ftp/mirror/OpenOffice/stable/2.0.3/OOo_2.0.3_Win32Intel_install.exe"};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("decode: " + stringArray2[i] + " -> " + URLDecoder.decode(stringArray2[i]));
            System.out.println("isURL: " + stringArray2[i] + " -> " + UrlUtils.isURL(stringArray2[i]));
            System.out.println("parse: " + stringArray2[i] + " -> " + UrlUtils.parseTextForURL(stringArray2[i], true));
        }
    }

    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLEncoder.encode(string).replaceAll("\\+", "%20");
        }
    }

    public static String decode(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLDecoder.decode(string);
        }
    }

    public static String escapeXML(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] stringArray = (String[])XMLescapes[i];
            string2 = string2.replaceAll(stringArray[0], stringArray[1]);
        }
        return string2;
    }

    public static String unescapeXML(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] stringArray = (String[])XMLescapes[i];
            string2 = string2.replaceAll(stringArray[1], stringArray[0]);
        }
        return string2;
    }

    public static String convertIPV6Host(String string) {
        if (string.indexOf(58) != -1) {
            return "[" + string + "]";
        }
        return string;
    }

    public static String expandIPV6Host(String string) {
        if (string.indexOf(58) != -1) {
            try {
                return InetAddress.getByAddress(InetAddress.getByName(string).getAddress()).getHostAddress();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return string;
    }

    public static void connectWithTimeout(URLConnection uRLConnection, long l) throws IOException {
        UrlUtils.connectWithTimeouts(uRLConnection, l, -1L);
    }

    public static void connectWithTimeouts(final URLConnection uRLConnection, long l, long l2) throws IOException {
        if (Java15Utils.isAvailable()) {
            if (l != -1L) {
                Java15Utils.setConnectTimeout(uRLConnection, (int)l);
            }
            if (l2 != -1L) {
                Java15Utils.setReadTimeout(uRLConnection, (int)l2);
            }
            uRLConnection.connect();
        } else {
            final AESemaphore aESemaphore = new AESemaphore("URLUtils:cwt");
            final Throwable[] throwableArray = new Throwable[]{null};
            if (connect_pool.isFull()) {
                Debug.out("Connect pool is full, forcing timeout");
                throw new IOException("Timeout");
            }
            connect_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        try {
                            uRLConnection.connect();
                        }
                        catch (Throwable throwable) {
                            throwableArray[0] = throwable;
                            Object var3_2 = null;
                            aESemaphore.release();
                        }
                        Object var3_1 = null;
                        aESemaphore.release();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        aESemaphore.release();
                        throw throwable;
                    }
                }
            });
            boolean bl = aESemaphore.reserve(l);
            if (bl) {
                Throwable throwable = throwableArray[0];
                if (throwable != null) {
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw new IOException(Debug.getNestedExceptionMessage(throwable));
                }
            } else {
                throw new IOException("Timeout");
            }
        }
    }

    public static void setBrowserHeaders(ResourceDownloader resourceDownloader, String string) {
        UrlUtils.setBrowserHeaders(resourceDownloader, null, string);
    }

    public static void setBrowserHeaders(ResourceDownloader resourceDownloader, String string, String string2) {
        String string3 = UrlUtils.getBrowserHeadersToUse(string);
        try {
            String string4 = new String(Base64.decode(string3), "UTF-8");
            String[] stringArray = string4.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                int n = string5.indexOf(58);
                if (n == -1) continue;
                String string6 = string5.substring(0, n).trim();
                String string7 = string5.substring(n + 1).trim();
                if (string6.equalsIgnoreCase("Host") || string6.equalsIgnoreCase("Referer")) continue;
                resourceDownloader.setProperty("URL_" + string6, string7);
            }
            if (string2 != null && string2.length() > 0) {
                resourceDownloader.setProperty("URL_Referer", string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(ResourceUploader resourceUploader, String string, String string2) {
        String string3 = UrlUtils.getBrowserHeadersToUse(string);
        try {
            String string4 = new String(Base64.decode(string3), "UTF-8");
            String[] stringArray = string4.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                int n = string5.indexOf(58);
                if (n == -1) continue;
                String string6 = string5.substring(0, n).trim();
                String string7 = string5.substring(n + 1).trim();
                if (string6.equalsIgnoreCase("Host") || string6.equalsIgnoreCase("Referer")) continue;
                resourceUploader.setProperty("URL_" + string6, string7);
            }
            if (string2 != null && string2.length() > 0) {
                resourceUploader.setProperty("URL_Referer", string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(URLConnection uRLConnection, String string) {
        UrlUtils.setBrowserHeaders(uRLConnection, null, string);
    }

    public static void setBrowserHeaders(URLConnection uRLConnection, String string, String string2) {
        String string3 = UrlUtils.getBrowserHeadersToUse(string);
        try {
            String string4 = new String(Base64.decode(string3), "UTF-8");
            String[] stringArray = string4.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                int n = string5.indexOf(58);
                if (n == -1) continue;
                String string6 = string5.substring(0, n).trim();
                String string7 = string5.substring(n + 1).trim();
                if (string6.equalsIgnoreCase("Host") || string6.equalsIgnoreCase("Referer")) continue;
                uRLConnection.setRequestProperty(string6, string7);
            }
            if (string2 != null && string2.length() > 0) {
                uRLConnection.setRequestProperty("Referer", string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Map getBrowserHeaders(String string) {
        String string2 = UrlUtils.getBrowserHeadersToUse(null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string3 = new String(Base64.decode(string2), "UTF-8");
            String[] stringArray = string3.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                int n = string4.indexOf(58);
                if (n == -1) continue;
                String string5 = string4.substring(0, n).trim();
                String string6 = string4.substring(n + 1).trim();
                if (string5.equalsIgnoreCase("Host") || string5.equalsIgnoreCase("Referer")) continue;
                hashMap.put(string5, string6);
            }
            if (string != null && string.length() > 0) {
                hashMap.put("Referer", string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBrowserHeadersToUse(String string) {
        String string2 = string;
        Class<UrlUtils> clazz = UrlUtils.class;
        synchronized (UrlUtils.class) {
            if (string2 == null) {
                string2 = last_headers != null ? last_headers : default_headers;
            } else {
                if (last_headers == null || !string2.equals(last_headers)) {
                    COConfigurationManager.setParameter("metasearch.web.last.headers", string2);
                }
                last_headers = string2;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return string2;
        }
    }

    public static boolean queryHasParameter(String string, String string2, boolean bl) {
        if (!bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (string.charAt(0) == '?') {
            string = '&' + string.substring(1);
        } else if (string.charAt(0) != '&') {
            string = '&' + string;
        }
        return string.indexOf("&" + string2 + "=") != -1;
    }

    public static boolean containsPasskey(URL uRL) {
        String string = uRL.toExternalForm();
        return string.matches(".*[0-9a-z]{20,40}.*");
    }

    public static URL setPort(URL uRL, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(":");
        String string = uRL.getAuthority();
        if (string != null && string.length() > 0) {
            stringBuffer.append("//");
            int n2 = string.indexOf(64);
            if (n2 != -1) {
                stringBuffer.append(string.substring(0, n2 + 1));
                string = string.substring(n2 + 1);
            }
            if ((n2 = string.lastIndexOf(58)) == -1) {
                stringBuffer.append(string + ":" + n);
            } else {
                stringBuffer.append(string.substring(0, n2 + 1) + n);
            }
        }
        if (uRL.getPath() != null) {
            stringBuffer.append(uRL.getPath());
        }
        if (uRL.getQuery() != null) {
            stringBuffer.append('?');
            stringBuffer.append(uRL.getQuery());
        }
        if (uRL.getRef() != null) {
            stringBuffer.append("#");
            stringBuffer.append(uRL.getRef());
        }
        try {
            return new URL(stringBuffer.toString());
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return uRL;
        }
    }

    public static URL setHost(URL uRL, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(":");
        String string2 = uRL.getAuthority();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("//");
            int n = string2.indexOf(64);
            if (n != -1) {
                stringBuffer.append(string2.substring(0, n + 1));
                string2 = string2.substring(n + 1);
            }
            if ((n = string2.lastIndexOf(58)) == -1) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string + string2.substring(n));
            }
        }
        if (uRL.getPath() != null) {
            stringBuffer.append(uRL.getPath());
        }
        if (uRL.getQuery() != null) {
            stringBuffer.append('?');
            stringBuffer.append(uRL.getQuery());
        }
        if (uRL.getRef() != null) {
            stringBuffer.append("#");
            stringBuffer.append(uRL.getRef());
        }
        try {
            return new URL(stringBuffer.toString());
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return uRL;
        }
    }

    public static URL getIPV4Fallback(URL uRL) {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(uRL.getHost());
            if (inetAddressArray.length > 0) {
                InetAddress inetAddress = null;
                InetAddress inetAddress2 = null;
                for (InetAddress inetAddress3 : inetAddressArray) {
                    if (inetAddress3 instanceof Inet4Address) {
                        inetAddress = inetAddress3;
                        continue;
                    }
                    inetAddress2 = inetAddress3;
                }
                if (inetAddress != null && inetAddress2 != null) {
                    uRL = UrlUtils.setHost(uRL, inetAddress.getHostAddress());
                    return uRL;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static long getContentLength(HttpURLConnection httpURLConnection) {
        long l = httpURLConnection.getContentLength();
        if (l == -1L) {
            try {
                String string = httpURLConnection.getHeaderField("content-length");
                if (string != null) {
                    l = Long.parseLong(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return l;
    }

    static {
        connect_pool.setWarnWhenFull();
        prefixes = new String[]{"http://", "https://", "ftp://", "dht://", "magnet:?", "magnet://?"};
        MAGNETURL_STARTS_AT = 3;
        XMLescapes = new Object[]{new String[]{"&", "&amp;"}, new String[]{">", "&gt;"}, new String[]{"<", "&lt;"}, new String[]{"\"", "&quot;"}, new String[]{"'", "&apos;"}};
        last_headers = COConfigurationManager.getStringParameter("metasearch.web.last.headers", null);
    }
}

