/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.test;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.SHA1;
import org.gudy.azureus2.core3.util.test.SHA1Old;

public class SHA1SpeedTest {
    private static final int BUFF_MAX_SIZE = 0x400000;
    private static final int[] LOOPS = new int[]{1000000, 30000, 15000, 4000, 3000, 2000, 1200, 800};
    private static final int[] TESTS = new int[]{1, 16, 64, 256, 512, 1024, 2048, 4096};
    private static final int TEST_SPEED_FACTOR = 1;

    public static void main(String[] stringArray) {
        Object object;
        int n;
        Random random = new Random();
        SHA1Old sHA1Old = new SHA1Old();
        SHA1 sHA1 = new SHA1();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0x400000);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(0x400000);
        for (int i = 0; i < 0x400000; ++i) {
            n = random.nextInt() & 0xFF;
            byteBuffer.put((byte)n);
        }
        byteBuffer.rewind();
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        byteBuffer.rewind();
        try {
            System.out.println("Setting high thread priority to decrease test jitter");
            Thread.currentThread().setPriority(10);
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < TESTS.length; ++i) {
            int n2;
            n = TESTS[i] * 1024;
            byteBuffer.position(0);
            byteBuffer.limit(n);
            byteBuffer2.position(0);
            byteBuffer2.limit(n);
            int n3 = LOOPS[i] / 1;
            object = " [" + n / 1024 + "KB, " + n3 + "x] = ";
            double d = (double)n / 1048576.0 * (double)n3;
            System.out.println("direct:");
            System.out.print("Old SHA1");
            long l = System.currentTimeMillis();
            for (n2 = 0; n2 < n3; ++n2) {
                sHA1Old.reset();
                sHA1Old.digest(byteBuffer);
            }
            l = System.currentTimeMillis() - l;
            double d2 = d / ((double)l / 1024.0);
            System.out.println((String)object + l + " ms @ " + d2 + " MiB/s");
            System.out.print("New SHA1 ");
            l = System.currentTimeMillis();
            for (n2 = 0; n2 < n3; ++n2) {
                sHA1.reset();
                sHA1.digest(byteBuffer);
            }
            l = System.currentTimeMillis() - l;
            d2 = d / ((double)l / 1024.0);
            System.out.println((String)object + l + " ms @ " + d2 + " MiB/s");
            System.out.println("heap:");
            System.out.print("Old SHA1");
            l = System.currentTimeMillis();
            for (n2 = 0; n2 < n3; ++n2) {
                sHA1Old.reset();
                sHA1Old.digest(byteBuffer2);
            }
            l = System.currentTimeMillis() - l;
            d2 = d / ((double)l / 1024.0);
            System.out.println((String)object + l + " ms @ " + d2 + " MiB/s");
            System.out.print("New SHA1 ");
            l = System.currentTimeMillis();
            for (n2 = 0; n2 < n3; ++n2) {
                sHA1.reset();
                sHA1.digest(byteBuffer2);
            }
            l = System.currentTimeMillis() - l;
            d2 = d / ((double)l / 1024.0);
            System.out.println((String)object + l + " ms @ " + d2 + " MiB/s");
            System.out.println();
        }
        System.out.println("performing randomized buffer windowing checks, this may take a while");
        for (int i = 0; i < LOOPS[1] / 1; ++i) {
            int n4 = random.nextInt(0x400000);
            int n5 = random.nextInt(0x400000 - n4 - 1);
            byteBuffer2.limit(n5 + n4);
            byteBuffer2.position(n5);
            byteBuffer.limit(n5 + n4);
            byteBuffer.position(n5);
            sHA1Old.reset();
            sHA1.reset();
            byte[] byArray = sHA1Old.digest(byteBuffer2);
            object = sHA1.digest(byteBuffer2);
            sHA1Old.reset();
            sHA1.reset();
            byte[] byArray2 = sHA1Old.digest(byteBuffer);
            byte[] byArray3 = sHA1.digest(byteBuffer);
            if (!(Arrays.equals(byArray, (byte[])object) && Arrays.equals(byArray2, byArray3) && Arrays.equals(byArray2, byArray))) {
                System.out.println("hash mismatch at offset: " + n5 + " size: " + n4);
                System.out.println("\t\t" + ByteFormatter.nicePrint(byArray));
                System.out.println("\t\t" + ByteFormatter.nicePrint((byte[])object));
                System.out.println("\t\t" + ByteFormatter.nicePrint(byArray2));
                System.out.println("\t\t" + ByteFormatter.nicePrint(byArray3));
            }
            if (byteBuffer2.limit() != n5 + n4 || byteBuffer.limit() != n5 + n4 || byteBuffer2.position() != n5 || byteBuffer.position() != n5) {
                System.out.println("buffer does not match its original state");
            }
            ByteBuffer byteBuffer3 = byteBuffer.slice();
            ByteBuffer byteBuffer4 = byteBuffer2.slice();
            sHA1Old.reset();
            sHA1.reset();
            byArray = sHA1Old.digest(byteBuffer4);
            object = sHA1.digest(byteBuffer4);
            sHA1Old.reset();
            sHA1.reset();
            byArray2 = sHA1Old.digest(byteBuffer3);
            byArray3 = sHA1.digest(byteBuffer3);
            if (!(Arrays.equals(byArray, (byte[])object) && Arrays.equals(byArray2, byArray3) && Arrays.equals(byArray2, byArray))) {
                System.out.println("(view) hash mismatch at offset: " + n5 + " size: " + n4);
                System.out.println("\t\t" + ByteFormatter.nicePrint(byArray));
                System.out.println("\t\t" + ByteFormatter.nicePrint((byte[])object));
                System.out.println("\t\t" + ByteFormatter.nicePrint(byArray2));
                System.out.println("\t\t" + ByteFormatter.nicePrint(byArray3));
            }
            if (byteBuffer4.limit() == byteBuffer4.capacity() && byteBuffer3.limit() == byteBuffer3.capacity() && byteBuffer4.position() == 0 && byteBuffer3.position() == 0) continue;
            System.out.println("view buffer does not match its original state");
        }
        System.out.println("DONE");
    }
}

