/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform;

import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.dummy.PlatformManagerImpl;

public class PlatformManagerFactory {
    protected static PlatformManager platform_manager;
    protected static AEMonitor class_mon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PlatformManager getPlatformManager() {
        try {
            boolean bl = System.getProperty("azureus.platform.manager.disable", "false").equals("true");
            class_mon.enter();
            if (platform_manager == null && !bl) {
                try {
                    if (PlatformManagerFactory.getPlatformType() != 1 && PlatformManagerFactory.getPlatformType() != 3 && PlatformManagerFactory.getPlatformType() != 4) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            if (platform_manager == null) {
                platform_manager = PlatformManagerImpl.getSingleton();
            }
            PlatformManager platformManager = platform_manager;
            Object var3_4 = null;
            class_mon.exit();
            return platformManager;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static int getPlatformType() {
        if (Constants.isWindows) {
            return 1;
        }
        if (Constants.isOSX) {
            return 3;
        }
        if (Constants.isUnix) {
            return 4;
        }
        return 2;
    }

    static {
        class_mon = new AEMonitor("PlatformManagerFactory");
    }
}

