/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.plugins.config.PluginConfigSource;
import org.gudy.azureus2.pluginsimpl.local.config.ConfigParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.config.PluginConfigSourceImpl;

public class PluginConfigImpl
implements PluginConfig {
    protected static Map external_to_internal_key_map = new HashMap();
    private PluginConfigSourceImpl external_source = null;
    private static Map fake_values_when_disabled;
    private static int fake_values_ref_count;
    private PluginInterface plugin_interface;
    private String key;
    private boolean allow_key_modification;

    public void checkValidCoreParam(String string) {
        if (!external_to_internal_key_map.containsKey(string)) {
            throw new IllegalArgumentException("invalid core parameter: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnablePluginCoreConfigChange(boolean bl) {
        Class<PluginConfigImpl> clazz = PluginConfigImpl.class;
        synchronized (PluginConfigImpl.class) {
            if (bl) {
                if (--fake_values_ref_count == 0) {
                    fake_values_when_disabled = null;
                }
            } else if (++fake_values_ref_count == 1) {
                fake_values_when_disabled = new HashMap();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFakeValueWhenDisabled(String string, String string2) {
        if (string2.startsWith(string)) {
            return null;
        }
        Class<PluginConfigImpl> clazz = PluginConfigImpl.class;
        synchronized (PluginConfigImpl.class) {
            if (fake_values_when_disabled != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return fake_values_when_disabled.get(string2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setFakeValueWhenDisabled(String string, String string2, Object object) {
        if (string2.startsWith(string)) {
            return false;
        }
        Class<PluginConfigImpl> clazz = PluginConfigImpl.class;
        synchronized (PluginConfigImpl.class) {
            if (fake_values_when_disabled != null) {
                fake_values_when_disabled.put(string2, object);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public PluginConfigImpl(PluginInterface pluginInterface, String string) {
        this.plugin_interface = pluginInterface;
        this.key = string + ".";
        this.allow_key_modification = true;
    }

    public boolean isNewInstall() {
        return COConfigurationManager.isNewInstall();
    }

    public String getPluginConfigKeyPrefix() {
        return this.key;
    }

    public void setPluginConfigKeyPrefix(String string) {
        if (!this.allow_key_modification) {
            throw new RuntimeException("cannot modify key prefix - already in use");
        }
        if (string.length() <= 0 && !this.plugin_interface.getPluginState().isBuiltIn()) {
            throw new RuntimeException("Can't set Plugin Config Key Prefix to '" + string + "'");
        }
        this.key = string;
    }

    private boolean getBooleanParameter(String string, boolean bl, boolean bl2, boolean bl3) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return (Boolean)object;
        }
        if (bl2) {
            string = this.mapKeyName(string, false);
        }
        this.notifyParamExists(string);
        if (bl3) {
            COConfigurationManager.setBooleanDefault(string, bl);
        } else if (!this.hasParameter(string)) {
            return bl;
        }
        return COConfigurationManager.getBooleanParameter(string);
    }

    private int[] getColorParameter(String string, int[] nArray, boolean bl, boolean bl2) {
        int[] nArray2;
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return (int[])object;
        }
        if (bl) {
            string = this.mapKeyName(string, false);
        }
        if ((nArray2 = this.getColorParameter0(string, nArray, bl2)) == null) {
            return null;
        }
        if (nArray2.length == 3) {
            int[] nArray3 = new int[4];
            System.arraycopy(nArray2, 0, nArray3, 0, 3);
            nArray3[3] = this.getIntParameter(string, 0, false, false);
            nArray2 = nArray3;
        }
        return nArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] getColorParameter0(String string, int[] nArray, boolean bl) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return (int[])object;
        }
        this.notifyRGBParamExists(string);
        if (bl) {
            if (nArray == null) throw new RuntimeException("color parameter default is null");
            COConfigurationManager.setIntDefault(string + ".red", nArray[0]);
            COConfigurationManager.setIntDefault(string + ".green", nArray[1]);
            COConfigurationManager.setIntDefault(string + ".blue", nArray[2]);
            return new int[]{COConfigurationManager.getIntParameter(string + ".red"), COConfigurationManager.getIntParameter(string + ".green"), COConfigurationManager.getIntParameter(string + ".blue"), COConfigurationManager.getIntParameter(string + ".override")};
        } else {
            if (this.hasParameter(string + ".red")) return new int[]{COConfigurationManager.getIntParameter(string + ".red"), COConfigurationManager.getIntParameter(string + ".green"), COConfigurationManager.getIntParameter(string + ".blue"), COConfigurationManager.getIntParameter(string + ".override")};
            return nArray;
        }
    }

    private byte[] getByteParameter(String string, byte[] byArray, boolean bl, boolean bl2) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return (byte[])object;
        }
        if (bl) {
            string = this.mapKeyName(string, false);
        }
        this.notifyParamExists(string);
        if (bl2) {
            COConfigurationManager.setByteDefault(string, byArray);
        } else if (!this.hasParameter(string)) {
            return byArray;
        }
        return COConfigurationManager.getByteParameter(string);
    }

    private float getFloatParameter(String string, float f, boolean bl, boolean bl2) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return ((Float)object).floatValue();
        }
        if (bl) {
            string = this.mapKeyName(string, false);
        }
        this.notifyParamExists(string);
        if (bl2) {
            COConfigurationManager.setFloatDefault(string, f);
        } else if (!this.hasParameter(string)) {
            return f;
        }
        return COConfigurationManager.getFloatParameter(string);
    }

    private int getIntParameter(String string, int n, boolean bl, boolean bl2) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return ((Long)object).intValue();
        }
        if (bl) {
            string = this.mapKeyName(string, false);
        }
        this.notifyParamExists(string);
        if (bl2) {
            COConfigurationManager.setIntDefault(string, n);
        } else if (!this.hasParameter(string)) {
            return n;
        }
        return COConfigurationManager.getIntParameter(string);
    }

    private long getLongParameter(String string, long l, boolean bl, boolean bl2) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return (Long)object;
        }
        if (bl) {
            string = this.mapKeyName(string, false);
        }
        this.notifyParamExists(string);
        if (bl2) {
            COConfigurationManager.setLongDefault(string, l);
        } else if (!this.hasParameter(string)) {
            return l;
        }
        return COConfigurationManager.getLongParameter(string);
    }

    private String getStringParameter(String string, String string2, boolean bl, boolean bl2) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return (String)object;
        }
        if (bl) {
            string = this.mapKeyName(string, false);
        }
        this.notifyParamExists(string);
        if (bl2) {
            COConfigurationManager.setStringDefault(string, string2);
        } else if (!this.hasParameter(string)) {
            return string2;
        }
        return COConfigurationManager.getStringParameter(string);
    }

    private boolean getDefaultedBooleanParameter(String string, boolean bl) {
        Object object = PluginConfigImpl.getFakeValueWhenDisabled(this.key, string);
        if (object != null) {
            return (Boolean)object;
        }
        return this.getBooleanParameter(string, false, bl, false);
    }

    private byte[] getDefaultedByteParameter(String string, boolean bl) {
        return this.getByteParameter(string, ConfigurationDefaults.def_bytes, bl, false);
    }

    private int[] getDefaultedColorParameter(String string, boolean bl) {
        int[] nArray = new int[]{0, 0, 0, 1};
        return this.getColorParameter(string, nArray, bl, false);
    }

    private float getDefaultedFloatParameter(String string, boolean bl) {
        return this.getFloatParameter(string, 0.0f, bl, false);
    }

    private int getDefaultedIntParameter(String string, boolean bl) {
        return this.getIntParameter(string, 0, bl, false);
    }

    private long getDefaultedLongParameter(String string, boolean bl) {
        return this.getLongParameter(string, 0L, bl, false);
    }

    private String getDefaultedStringParameter(String string, boolean bl) {
        return this.getStringParameter(string, "", bl, false);
    }

    public boolean getBooleanParameter(String string) {
        return this.getDefaultedBooleanParameter(string, true);
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        return this.getBooleanParameter(string, bl, true, false);
    }

    public byte[] getByteParameter(String string) {
        return this.getDefaultedByteParameter(string, true);
    }

    public byte[] getByteParameter(String string, byte[] byArray) {
        return this.getByteParameter(string, byArray, true, false);
    }

    public float getFloatParameter(String string) {
        return this.getDefaultedFloatParameter(string, true);
    }

    public float getFloatParameter(String string, float f) {
        return this.getFloatParameter(string, f, true, false);
    }

    public int getIntParameter(String string) {
        return this.getDefaultedIntParameter(string, true);
    }

    public int getIntParameter(String string, int n) {
        return this.getIntParameter(string, n, true, false);
    }

    public long getLongParameter(String string) {
        return this.getDefaultedLongParameter(string, true);
    }

    public long getLongParameter(String string, long l) {
        return this.getLongParameter(string, l, true, false);
    }

    public String getStringParameter(String string) {
        return this.getDefaultedStringParameter(string, true);
    }

    public String getStringParameter(String string, String string2) {
        return this.getStringParameter(string, string2, true, false);
    }

    public boolean getCoreBooleanParameter(String string) {
        this.checkValidCoreParam(string);
        return this.getDefaultedBooleanParameter(string, true);
    }

    public boolean getCoreBooleanParameter(String string, boolean bl) {
        this.checkValidCoreParam(string);
        return this.getBooleanParameter(string, bl, true, false);
    }

    public byte[] getCoreByteParameter(String string) {
        this.checkValidCoreParam(string);
        return this.getDefaultedByteParameter(string, true);
    }

    public byte[] getCoreByteParameter(String string, byte[] byArray) {
        this.checkValidCoreParam(string);
        return this.getByteParameter(string, byArray, true, false);
    }

    public int[] getCoreColorParameter(String string) {
        this.checkValidCoreParam(string);
        return this.getDefaultedColorParameter(string, true);
    }

    public int[] getCoreColorParameter(String string, int[] nArray) {
        this.checkValidCoreParam(string);
        return this.getColorParameter(string, nArray, true, false);
    }

    public float getCoreFloatParameter(String string) {
        this.checkValidCoreParam(string);
        return this.getDefaultedFloatParameter(string, true);
    }

    public float getCoreFloatParameter(String string, float f) {
        this.checkValidCoreParam(string);
        return this.getFloatParameter(string, f, true, false);
    }

    public int getCoreIntParameter(String string) {
        this.checkValidCoreParam(string);
        return this.getDefaultedIntParameter(string, true);
    }

    public int getCoreIntParameter(String string, int n) {
        this.checkValidCoreParam(string);
        return this.getIntParameter(string, n, true, false);
    }

    public long getCoreLongParameter(String string) {
        this.checkValidCoreParam(string);
        return this.getDefaultedLongParameter(string, true);
    }

    public long getCoreLongParameter(String string, long l) {
        this.checkValidCoreParam(string);
        return this.getLongParameter(string, l, true, false);
    }

    public String getCoreStringParameter(String string) {
        this.checkValidCoreParam(string);
        return this.getDefaultedStringParameter(string, true);
    }

    public String getCoreStringParameter(String string, String string2) {
        this.checkValidCoreParam(string);
        return this.getStringParameter(string, string2, true, false);
    }

    public void setBooleanParameter(String string, boolean bl) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Boolean(bl))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), bl);
    }

    public void setByteParameter(String string, byte[] byArray) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, byArray)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), byArray);
    }

    public void setColorParameter(String string, int[] nArray) {
        this.setColorParameter(string, nArray, true);
    }

    public void setColorParameter(String string, int[] nArray, boolean bl) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, nArray)) {
            return;
        }
        COConfigurationManager.setRGBParameter(this.mapKeyName(string, true), nArray, bl);
    }

    public void setFloatParameter(String string, float f) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Float(f))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), f);
    }

    public void setIntParameter(String string, int n) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Long(n))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), n);
    }

    public void setLongParameter(String string, long l) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Long(l))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), l);
    }

    public void setStringParameter(String string, String string2) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, string2)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), string2);
    }

    public void setCoreBooleanParameter(String string, boolean bl) {
        this.checkValidCoreParam(string);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Boolean(bl))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), bl);
    }

    public void setCoreByteParameter(String string, byte[] byArray) {
        this.checkValidCoreParam(string);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, byArray)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), byArray);
    }

    public void setCoreColorParameter(String string, int[] nArray) {
        this.setCoreColorParameter(string, nArray, true);
    }

    public void setCoreColorParameter(String string, int[] nArray, boolean bl) {
        this.checkValidCoreParam(string);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, nArray)) {
            return;
        }
        COConfigurationManager.setRGBParameter(this.mapKeyName(string, true), nArray, bl);
    }

    public void setCoreFloatParameter(String string, float f) {
        this.checkValidCoreParam(string);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Float(f))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), f);
    }

    public void setCoreIntParameter(String string, int n) {
        this.checkValidCoreParam(string);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Long(n))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), n);
    }

    public void setCoreLongParameter(String string, long l) {
        this.checkValidCoreParam(string);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Long(l))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), l);
    }

    public void setCoreStringParameter(String string, String string2) {
        this.checkValidCoreParam(string);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, string2)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(string, true), string2);
    }

    public boolean getPluginBooleanParameter(String string) {
        return this.getDefaultedBooleanParameter(this.key + string, false);
    }

    public boolean getPluginBooleanParameter(String string, boolean bl) {
        return this.getBooleanParameter(this.key + string, bl, false, true);
    }

    public byte[] getPluginByteParameter(String string) {
        return this.getDefaultedByteParameter(this.key + string, false);
    }

    public byte[] getPluginByteParameter(String string, byte[] byArray) {
        return this.getByteParameter(this.key + string, byArray, false, true);
    }

    public int[] getPluginColorParameter(String string) {
        return this.getDefaultedColorParameter(this.key + string, false);
    }

    public int[] getPluginColorParameter(String string, int[] nArray) {
        return this.getColorParameter(this.key + string, nArray, false, true);
    }

    public float getPluginFloatParameter(String string) {
        return this.getDefaultedFloatParameter(this.key + string, false);
    }

    public float getPluginFloatParameter(String string, float f) {
        return this.getFloatParameter(this.key + string, f, false, true);
    }

    public int getPluginIntParameter(String string) {
        return this.getDefaultedIntParameter(this.key + string, false);
    }

    public int getPluginIntParameter(String string, int n) {
        return this.getIntParameter(this.key + string, n, false, true);
    }

    public long getPluginLongParameter(String string) {
        return this.getDefaultedLongParameter(this.key + string, false);
    }

    public long getPluginLongParameter(String string, long l) {
        return this.getLongParameter(this.key + string, l, false, true);
    }

    public String getPluginStringParameter(String string) {
        return this.getDefaultedStringParameter(this.key + string, false);
    }

    public String getPluginStringParameter(String string, String string2) {
        return this.getStringParameter(this.key + string, string2, false, true);
    }

    public void setPluginParameter(String string, boolean bl) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, bl);
    }

    public void setPluginParameter(String string, byte[] byArray) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, byArray);
    }

    public void setPluginParameter(String string, float f) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, f);
    }

    public void setPluginParameter(String string, int n) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, n);
    }

    public void setPluginParameter(String string, long l) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, l);
    }

    public void setPluginParameter(String string, String string2) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, string2);
    }

    public void setPluginColorParameter(String string, int[] nArray) {
        this.setPluginColorParameter(string, nArray, true);
    }

    public void setPluginColorParameter(String string, int[] nArray, boolean bl) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setRGBParameter(this.key + string, nArray, bl);
    }

    public boolean getUnsafeBooleanParameter(String string) {
        return this.getDefaultedBooleanParameter(string, false);
    }

    public boolean getUnsafeBooleanParameter(String string, boolean bl) {
        return this.getBooleanParameter(string, bl, false, false);
    }

    public byte[] getUnsafeByteParameter(String string) {
        return this.getDefaultedByteParameter(string, false);
    }

    public byte[] getUnsafeByteParameter(String string, byte[] byArray) {
        return this.getByteParameter(string, byArray, false, false);
    }

    public int[] getUnsafeColorParameter(String string) {
        return this.getDefaultedColorParameter(string, false);
    }

    public int[] getUnsafeColorParameter(String string, int[] nArray) {
        return this.getColorParameter(string, nArray, false, false);
    }

    public float getUnsafeFloatParameter(String string) {
        return this.getDefaultedFloatParameter(string, false);
    }

    public float getUnsafeFloatParameter(String string, float f) {
        return this.getFloatParameter(string, f, false, false);
    }

    public int getUnsafeIntParameter(String string) {
        return this.getDefaultedIntParameter(string, false);
    }

    public int getUnsafeIntParameter(String string, int n) {
        return this.getIntParameter(string, n, false, false);
    }

    public long getUnsafeLongParameter(String string) {
        return this.getDefaultedLongParameter(string, false);
    }

    public long getUnsafeLongParameter(String string, long l) {
        return this.getLongParameter(string, l, false, false);
    }

    public String getUnsafeStringParameter(String string) {
        return this.getDefaultedStringParameter(string, false);
    }

    public String getUnsafeStringParameter(String string, String string2) {
        return this.getStringParameter(string, string2, false, false);
    }

    public void setUnsafeBooleanParameter(String string, boolean bl) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Boolean(bl))) {
            return;
        }
        this.notifyParamExists(string);
        COConfigurationManager.setParameter(string, bl);
    }

    public void setUnsafeByteParameter(String string, byte[] byArray) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, byArray)) {
            return;
        }
        this.notifyParamExists(string);
        COConfigurationManager.setParameter(string, byArray);
    }

    public void setUnsafeColorParameter(String string, int[] nArray) {
        this.setUnsafeColorParameter(string, nArray, true);
    }

    public void setUnsafeColorParameter(String string, int[] nArray, boolean bl) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, nArray)) {
            return;
        }
        this.notifyRGBParamExists(string);
        COConfigurationManager.setRGBParameter(string, nArray, bl);
    }

    public void setUnsafeFloatParameter(String string, float f) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Float(f))) {
            return;
        }
        this.notifyParamExists(string);
        COConfigurationManager.setParameter(string, f);
    }

    public void setUnsafeIntParameter(String string, int n) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Long(n))) {
            return;
        }
        this.notifyParamExists(string);
        COConfigurationManager.setParameter(string, n);
    }

    public void setUnsafeLongParameter(String string, long l) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, new Long(l))) {
            return;
        }
        this.notifyParamExists(string);
        COConfigurationManager.setParameter(string, l);
    }

    public void setUnsafeStringParameter(String string, String string2) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, string, string2)) {
            return;
        }
        this.notifyParamExists(string);
        COConfigurationManager.setParameter(string, string2);
    }

    public String[] getPluginStringListParameter(String string) {
        this.notifyParamExists(this.key + string);
        return COConfigurationManager.getStringListParameter(this.key + string).toArray();
    }

    public void setPluginStringListParameter(String string, String[] stringArray) {
        this.notifyParamExists(this.key + string);
        StringListImpl stringListImpl = new StringListImpl(Arrays.asList(stringArray));
        COConfigurationManager.setParameter(this.key + string, stringListImpl);
    }

    public List getPluginListParameter(String string, List list) {
        this.notifyParamExists(this.key + string);
        return COConfigurationManager.getListParameter(this.key + string, list);
    }

    public void setPluginListParameter(String string, List list) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, list);
    }

    public Map getPluginMapParameter(String string, Map map) {
        this.notifyParamExists(this.key + string);
        return COConfigurationManager.getMapParameter(this.key + string, map);
    }

    public void setPluginMapParameter(String string, Map map) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, map);
    }

    public void setPluginParameter(String string, int n, boolean bl) {
        this.notifyParamExists(this.key + string);
        COConfigurationManager.setParameter(this.key + string, n);
        if (bl) {
            MagnetURIHandler.getSingleton().addInfo(this.key + string, n);
        }
    }

    public ConfigParameter getParameter(String string) {
        return new ConfigParameterImpl(this.mapKeyName(string, false));
    }

    public ConfigParameter getPluginParameter(String string) {
        return new ConfigParameterImpl(this.key + string);
    }

    public boolean removePluginParameter(String string) {
        this.notifyParamExists(this.key + string);
        return COConfigurationManager.removeParameter(this.key + string);
    }

    public boolean removePluginColorParameter(String string) {
        this.notifyParamExists(this.key + string);
        return COConfigurationManager.removeRGBParameter(this.key + string);
    }

    public Map getUnsafeParameterList() {
        Set set = COConfigurationManager.getAllowedParameters();
        Iterator iterator = set.iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                Object object = COConfigurationManager.getParameter(string);
                if (!(object instanceof String) && !(object instanceof Long)) {
                    if (object instanceof byte[]) {
                        object = new String((byte[])object, "UTF-8");
                    } else if (object instanceof Integer) {
                        object = new Long(((Integer)object).intValue());
                    } else if (object instanceof List) {
                        object = null;
                    } else if (object instanceof Map) {
                        object = null;
                    } else if (object instanceof Boolean) {
                        object = new Long((Boolean)object != false ? 1L : 0L);
                    } else if (object instanceof Float || object instanceof Double) {
                        object = object.toString();
                    }
                }
                if (object == null) continue;
                hashMap.put(string, object);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return hashMap;
    }

    public void save() {
        COConfigurationManager.save();
    }

    public File getPluginUserFile(String string) {
        String string2 = this.plugin_interface.getUtilities().getAzureusUserDir();
        File file = new File(string2, "plugins");
        String string3 = this.plugin_interface.getPluginDirectoryName();
        if (string3.length() != 0) {
            int n = string3.lastIndexOf(File.separatorChar);
            if (n != -1) {
                string3 = string3.substring(n + 1);
            }
            file = new File(file, string3);
        } else {
            String string4 = this.plugin_interface.getPluginID();
            if (string4.length() > 0 && !string4.equals("<internal>")) {
                file = new File(file, string4);
            } else {
                throw new RuntimeException("Plugin was not loaded from a directory");
            }
        }
        FileUtil.mkdirs(file);
        return new File(file, string);
    }

    public void addListener(final PluginConfigListener pluginConfigListener) {
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                pluginConfigListener.configSaved();
            }
        });
    }

    private String mapKeyName(String string, boolean bl) {
        String string2 = (String)external_to_internal_key_map.get(string);
        if (string2 == null) {
            if (bl) {
                throw new RuntimeException("No permission to set the value of core parameter: " + string);
            }
            return string;
        }
        return string2;
    }

    public boolean hasParameter(String string) {
        return COConfigurationManager.hasParameter(string, false);
    }

    public boolean hasPluginParameter(String string) {
        this.notifyParamExists(this.key + string);
        return COConfigurationManager.hasParameter(this.key + string, true);
    }

    public void notifyRGBParamExists(String string) {
        this.notifyParamExists(string + ".red");
        this.notifyParamExists(string + ".blue");
        this.notifyParamExists(string + ".green");
        this.notifyParamExists(string + ".override");
    }

    public void notifyParamExists(String string) {
        if (this.allow_key_modification && string.startsWith(this.key)) {
            this.allow_key_modification = false;
        }
        if (this.external_source != null && string.startsWith(this.key)) {
            this.external_source.registerParameter(string);
        }
    }

    public PluginConfigSource enableExternalConfigSource() {
        PluginConfigSourceImpl pluginConfigSourceImpl = new PluginConfigSourceImpl(this, this.plugin_interface.getPluginID());
        this.setPluginConfigSource(pluginConfigSourceImpl);
        return pluginConfigSourceImpl;
    }

    public PluginConfigSource getPluginConfigSource() {
        return this.external_source;
    }

    public void setPluginConfigSource(PluginConfigSource pluginConfigSource) {
        if (this.external_source != null) {
            throw new RuntimeException("external config source already associated!");
        }
        PluginConfigSourceImpl pluginConfigSourceImpl = (PluginConfigSourceImpl)pluginConfigSource;
        String string = pluginConfigSourceImpl.getUsedKeyPrefix();
        if (string != null && !this.getPluginConfigKeyPrefix().startsWith(string)) {
            throw new RuntimeException("cannot use this config source object - incompatible prefix keys: " + string + " / " + this.getPluginConfigKeyPrefix());
        }
        this.external_source = (PluginConfigSourceImpl)pluginConfigSource;
    }

    static {
        external_to_internal_key_map.put("Max Upload Speed KBs", "Max Upload Speed KBs");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding KBs", "Max Upload Speed Seeding KBs");
        external_to_internal_key_map.put("Max Download Speed KBs", "Max Download Speed KBs");
        external_to_internal_key_map.put("Max Connections Global", "Max.Peer.Connections.Total");
        external_to_internal_key_map.put("Max Connections Per Torrent", "Max.Peer.Connections.Per.Torrent");
        external_to_internal_key_map.put("Max Downloads", "max downloads");
        external_to_internal_key_map.put("Max Active Torrents", "max active torrents");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding", "StartStopManager_iMaxActiveTorrentsWhenSeeding");
        external_to_internal_key_map.put("Max Uploads", "Max Uploads");
        external_to_internal_key_map.put("Max Uploads Seeding", "Max Uploads Seeding");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding Enabled", "enable.seedingonly.upload.rate");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding Enabled", "StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
        external_to_internal_key_map.put("Auto Upload Speed Enabled", "Auto Upload Speed Enabled");
        external_to_internal_key_map.put("SOCKS Proxy No Inward Connection", "Proxy.Data.SOCKS.inform");
        external_to_internal_key_map.put("Newly Seeding Torrents Get First Priority", "Newly Seeding Torrents Get First Priority");
        external_to_internal_key_map.put("CORE_PARAM_STRING_LOCAL_BIND_IP", "Bind IP");
        external_to_internal_key_map.put("CORE_PARAM_BOOLEAN_FRIENDLY_HASH_CHECKING", "diskmanager.friendly.hashchecking");
        external_to_internal_key_map.put("GUI_PARAM_INT_SWT_REFRESH_IN_MS", "GUI Refresh");
        external_to_internal_key_map.put("CORE_PARAM_BOOLEAN_NEW_TORRENTS_START_AS_STOPPED", "Default Start Torrents Stopped");
        external_to_internal_key_map.put("Incoming TCP Port", "TCP.Listen.Port");
        external_to_internal_key_map.put("Incoming UDP Port", "UDP.Listen.Port");
        external_to_internal_key_map.put("Default save path", "Default save path");
        String[] stringArray = new String[]{"Open MyTorrents", "IconBar.enabled", "Wizard Completed", "welcome.version.lastshown"};
        for (int i = 0; i < stringArray.length; ++i) {
            external_to_internal_key_map.put(stringArray[i], stringArray[i]);
        }
    }
}

