/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;

public class PluginCoreUtils {
    public static Torrent wrap(TOTorrent tOTorrent) {
        return new TorrentImpl(tOTorrent);
    }

    public static TOTorrent unwrap(Torrent torrent) {
        return ((TorrentImpl)torrent).getTorrent();
    }

    public static DiskManager wrap(org.gudy.azureus2.core3.disk.DiskManager diskManager) {
        return new DiskManagerImpl(diskManager);
    }

    public static org.gudy.azureus2.core3.disk.DiskManager unwrap(DiskManager diskManager) {
        return ((DiskManagerImpl)diskManager).getDiskmanager();
    }

    public static Download wrap(DownloadManager downloadManager) {
        try {
            return DownloadManagerImpl.getDownloadStatic(downloadManager);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object convert(Object object, boolean bl) {
        try {
            if (bl) {
                if (object instanceof DownloadManager) {
                    return object;
                }
                if (object instanceof DownloadImpl) {
                    return ((DownloadImpl)object).getDownload();
                }
                if (object instanceof org.gudy.azureus2.core3.disk.DiskManager) {
                    return object;
                }
                if (object instanceof DiskManagerImpl) {
                    return ((DiskManagerImpl)object).getDiskmanager();
                }
                if (object instanceof PEPeerManager) {
                    return object;
                }
                if (object instanceof PeerManagerImpl) {
                    return ((PeerManagerImpl)object).getDelegate();
                }
                if (object instanceof PEPeer) {
                    return object;
                }
                if (object instanceof PeerImpl) {
                    return ((PeerImpl)object).getPEPeer();
                }
                if (object instanceof DiskManagerFileInfo) {
                    return object;
                }
                if (object instanceof DiskManagerFileInfoImpl) {
                    ((DiskManagerFileInfoImpl)object).getCore();
                }
                if (object instanceof TRHostTorrent) {
                    return object;
                }
                if (object instanceof TrackerTorrentImpl) {
                    ((TrackerTorrentImpl)object).getHostTorrent();
                }
            } else {
                Object object2;
                if (object instanceof DownloadManager) {
                    return PluginCoreUtils.wrap((DownloadManager)object);
                }
                if (object instanceof DownloadImpl) {
                    return object;
                }
                if (object instanceof org.gudy.azureus2.core3.disk.DiskManager) {
                    return PluginCoreUtils.wrap((org.gudy.azureus2.core3.disk.DiskManager)object);
                }
                if (object instanceof DiskManagerImpl) {
                    return object;
                }
                if (object instanceof PEPeerManager) {
                    return PluginCoreUtils.wrap((PEPeerManager)object);
                }
                if (object instanceof PeerManagerImpl) {
                    return object;
                }
                if (object instanceof PEPeer) {
                    return PeerManagerImpl.getPeerForPEPeer((PEPeer)object);
                }
                if (object instanceof Peer) {
                    return object;
                }
                if (object instanceof DiskManagerFileInfo && (object2 = (DiskManagerFileInfo)object) != null) {
                    try {
                        return new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(object2.getDownloadManager()), (DiskManagerFileInfo)object2);
                    }
                    catch (DownloadException downloadException) {
                        // empty catch block
                    }
                }
                if (object instanceof DiskManagerFileInfoImpl) {
                    return object;
                }
                if (object instanceof TRHostTorrent) {
                    object2 = (TRHostTorrent)object;
                    return new TrackerTorrentImpl((TRHostTorrent)object2);
                }
                if (object instanceof TrackerTorrentImpl) {
                    return object;
                }
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        return object;
    }

    public static DownloadManager unwrap(Download download) {
        if (download instanceof DownloadImpl) {
            return ((DownloadImpl)download).getDownload();
        }
        Debug.out("Can't unwrap " + download);
        return null;
    }

    public static PeerManager wrap(PEPeerManager pEPeerManager) {
        return PeerManagerImpl.getPeerManager(pEPeerManager);
    }

    public static PEPeerManager unwrap(PeerManager peerManager) {
        return ((PeerManagerImpl)peerManager).getDelegate();
    }

    public static TRTrackerServerTorrent unwrap(TrackerTorrent trackerTorrent) {
        return ((TrackerTorrentImpl)trackerTorrent).getHostTorrent().getTrackerTorrent();
    }
}

