/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTManager;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.platform.PlatformManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginStateImpl;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.deprecate.PluginDeprecation;
import org.gudy.azureus2.pluginsimpl.local.dht.mainline.MainlineDHTManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ipc.IPCInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPFilterImpl;
import org.gudy.azureus2.pluginsimpl.local.logging.LoggerImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PluginConfigUIFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.ShortCutsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class PluginInterfaceImpl
implements PluginInterface,
AzureusCoreComponent {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private Plugin plugin;
    private PluginInitializer initialiser;
    private Object initialiser_key;
    protected ClassLoader class_loader;
    private CopyOnWriteList<PluginListener> listeners = new CopyOnWriteList();
    private Set<PluginListener> init_complete_fired_set = new HashSet<PluginListener>();
    private CopyOnWriteList<PluginEventListener> event_listeners = new CopyOnWriteList();
    private String key;
    private String pluginConfigKey;
    private Properties props;
    private String pluginDir;
    private PluginConfigImpl config;
    private String plugin_version;
    private Logger logger;
    private IPCInterfaceImpl ipc_interface;
    protected List children = new ArrayList();
    private List configSections = new ArrayList();
    private PluginStateImpl state;
    private String given_plugin_id;
    private String plugin_id_to_use;

    public PluginInterfaceImpl(Plugin plugin, PluginInitializer pluginInitializer, Object object, ClassLoader classLoader, String string, Properties properties, String string2, String string3, String string4) {
        this.plugin = plugin;
        this.initialiser = pluginInitializer;
        this.initialiser_key = object;
        this.class_loader = classLoader;
        this.key = string;
        this.pluginConfigKey = "Plugin." + string;
        this.props = new propertyWrapper(properties);
        this.pluginDir = string2;
        this.config = new PluginConfigImpl(this, this.pluginConfigKey);
        this.given_plugin_id = string3;
        this.plugin_version = string4;
        this.ipc_interface = new IPCInterfaceImpl(this.initialiser, this.plugin);
        this.state = new PluginStateImpl(this, this.initialiser);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isOperational() {
        PluginDeprecation.call("isOperational", this.given_plugin_id);
        return this.getPluginState().isOperational();
    }

    public Object getInitializerKey() {
        return this.initialiser_key;
    }

    public PluginManager getPluginManager() {
        return this.initialiser.getPluginManager();
    }

    public String getApplicationName() {
        return Constants.APP_NAME;
    }

    public String getAzureusName() {
        return "Azureus";
    }

    public String getAzureusVersion() {
        return "4.3.0.4";
    }

    public void addView(PluginView pluginView) {
    }

    public void addConfigSection(ConfigSection configSection) {
        ConfigSectionRepository.getInstance().addConfigSection(configSection);
        this.configSections.add(configSection);
    }

    public void removeConfigSection(ConfigSection configSection) {
        ConfigSectionRepository.getInstance().removeConfigSection(configSection);
        this.configSections.remove(configSection);
    }

    public ConfigSection[] getConfigSections() {
        return this.configSections.toArray(new ConfigSection[0]);
    }

    public void openTorrentFile(String string) {
        PluginDeprecation.call("openTorrentFile", this.getPluginID());
        try {
            this.getDownloadManager().addDownload(new File(string));
        }
        catch (DownloadException downloadException) {
            throw new RuntimeException(downloadException);
        }
    }

    public void openTorrentURL(String string) {
        PluginDeprecation.call("openTorrentURL", this.getPluginID());
        try {
            this.getDownloadManager().addDownload(new URL(string));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void setPluginName(String string) {
        this.props.put("plugin.name", string);
    }

    public String getPluginName() {
        String string = null;
        if (this.props != null) {
            string = (String)this.props.get("plugin.name");
        }
        if (string == null) {
            try {
                string = new File(this.pluginDir).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (string == null || string.length() == 0) {
            string = this.plugin.getClass().getName();
        }
        return string;
    }

    public void setPluginVersion(String string) {
        this.props.put("plugin.version", string);
    }

    public String getPluginVersion() {
        String string = (String)this.props.get("plugin.version");
        if (string == null) {
            string = this.plugin_version;
        }
        return string;
    }

    public String getPluginID() {
        String string = (String)this.props.get("plugin.id");
        if (string != null && string.equals("azupdater")) {
            this.plugin_id_to_use = string;
        }
        if (this.plugin_id_to_use != null) {
            return this.plugin_id_to_use;
        }
        if (string == null) {
            string = this.given_plugin_id;
        }
        if (string == null) {
            string = "<none>";
        }
        this.plugin_id_to_use = string;
        return this.plugin_id_to_use;
    }

    public boolean isMandatory() {
        PluginDeprecation.call("isMandatory", this.given_plugin_id);
        return this.getPluginState().isMandatory();
    }

    public boolean isBuiltIn() {
        PluginDeprecation.call("isBuiltIn", this.given_plugin_id);
        return this.getPluginState().isBuiltIn();
    }

    public Properties getPluginProperties() {
        return this.props;
    }

    public String getPluginDirectoryName() {
        return this.pluginDir;
    }

    public void setPluginDirectoryName(String string) {
        this.initialiser_key = new File(string);
        this.pluginDir = string;
    }

    public void addConfigUIParameters(Parameter[] parameterArray, String string) {
        ParameterRepository.getInstance().addPlugin(parameterArray, string);
    }

    public PluginConfig getPluginconfig() {
        return this.config;
    }

    public PluginConfigUIFactory getPluginConfigUIFactory() {
        return new PluginConfigUIFactoryImpl(this.config, this.pluginConfigKey);
    }

    public String getPluginConfigKey() {
        return this.pluginConfigKey;
    }

    public Tracker getTracker() {
        return TrackerImpl.getSingleton();
    }

    public ShareManager getShareManager() throws ShareException {
        return ShareManagerImpl.getSingleton();
    }

    public DownloadManager getDownloadManager() {
        return DownloadManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public MainlineDHTManager getMainlineDHTManager() {
        return new MainlineDHTManagerImpl(this.initialiser.getAzureusCore());
    }

    public TorrentManager getTorrentManager() {
        return TorrentManagerImpl.getSingleton().specialise(this);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new LoggerImpl(this);
        }
        return this.logger;
    }

    public IPFilter getIPFilter() {
        return new IPFilterImpl();
    }

    public Utilities getUtilities() {
        return new UtilitiesImpl(this.initialiser.getAzureusCore(), this);
    }

    public ShortCuts getShortCuts() {
        return new ShortCutsImpl(this);
    }

    public UIManager getUIManager() {
        return new UIManagerImpl(this);
    }

    public UpdateManager getUpdateManager() {
        return null;
    }

    protected void unloadSupport() {
        this.ipc_interface.unload();
        UIManagerImpl.unload(this);
    }

    public boolean isUnloadable() {
        PluginDeprecation.call("unloadable", this.given_plugin_id);
        return this.getPluginState().isUnloadable();
    }

    public void reload() throws PluginException {
        PluginDeprecation.call("reload", this.given_plugin_id);
        this.getPluginState().reload();
    }

    public void unload() throws PluginException {
        PluginDeprecation.call("unload", this.given_plugin_id);
        this.getPluginState().unload();
    }

    public void uninstall() throws PluginException {
        PluginDeprecation.call("uninstall", this.given_plugin_id);
        this.getPluginState().uninstall();
    }

    public boolean isInitialisationThread() {
        return this.initialiser.isInitialisationThread();
    }

    public ClientIDManager getClientIDManager() {
        return ClientIDManagerImpl.getSingleton();
    }

    public ConnectionManager getConnectionManager() {
        return ConnectionManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public MessageManager getMessageManager() {
        return MessageManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public DistributedDatabase getDistributedDatabase() {
        return DDBaseImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public PlatformManager getPlatformManager() {
        return PlatformManagerFactory.getPlatformManager();
    }

    protected void initialisationComplete() {
        Iterator<PluginListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                this.fireInitComplete(iterator.next());
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).initialisationComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInitComplete(PluginListener pluginListener) {
        Set<PluginListener> set = this.init_complete_fired_set;
        synchronized (set) {
            if (this.init_complete_fired_set.contains(pluginListener)) {
                return;
            }
            this.init_complete_fired_set.add(pluginListener);
        }
        try {
            pluginListener.initializationComplete();
        }
        catch (Exception exception) {
            Debug.out(exception);
        }
    }

    protected void closedownInitiated() {
        Iterator<PluginListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().closedownInitiated();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownInitiated();
        }
    }

    protected void closedownComplete() {
        Iterator<PluginListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().closedownComplete();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownComplete();
        }
    }

    public void firePluginEvent(PluginEvent pluginEvent) {
        Iterator<PluginEventListener> iterator = this.event_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().handleEvent(pluginEvent);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).firePluginEvent(pluginEvent);
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.class_loader;
    }

    public PluginInterface getLocalPluginInterface(Class clazz, String string) throws PluginException {
        try {
            Plugin plugin = (Plugin)clazz.newInstance();
            Properties properties = new Properties(this.props);
            properties.remove("plugin.id");
            PluginInterfaceImpl pluginInterfaceImpl = new PluginInterfaceImpl(plugin, this.initialiser, this.initialiser_key, this.class_loader, this.key + "." + string, properties, this.pluginDir, this.getPluginID() + "." + string, this.plugin_version);
            this.initialiser.fireCreated(pluginInterfaceImpl);
            plugin.initialize(pluginInterfaceImpl);
            this.children.add(pluginInterfaceImpl);
            return pluginInterfaceImpl;
        }
        catch (Throwable throwable) {
            if (throwable instanceof PluginException) {
                throw (PluginException)throwable;
            }
            throw new PluginException("Local initialisation fails", throwable);
        }
    }

    public IPCInterface getIPC() {
        return this.ipc_interface;
    }

    public boolean isShared() {
        PluginDeprecation.call("isShared", this.given_plugin_id);
        return this.getPluginState().isShared();
    }

    void setAsFailed() {
        this.getPluginState().setDisabled(true);
        this.state.failed = true;
    }

    public void addListener(PluginListener pluginListener) {
        this.listeners.add(pluginListener);
        if (this.initialiser.isInitialisationComplete()) {
            this.fireInitComplete(pluginListener);
        }
    }

    public void removeListener(final PluginListener pluginListener) {
        this.listeners.remove(pluginListener);
        new DelayedEvent("PIL:clear", 10000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                Set set = PluginInterfaceImpl.this.init_complete_fired_set;
                synchronized (set) {
                    PluginInterfaceImpl.this.init_complete_fired_set.remove(pluginListener);
                }
            }
        });
    }

    public void addEventListener(PluginEventListener pluginEventListener) {
        this.event_listeners.add(pluginEventListener);
    }

    public void removeEventListener(PluginEventListener pluginEventListener) {
        this.event_listeners.remove(pluginEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println(this.getPluginName());
        try {
            indentWriter.indent();
            indentWriter.println("id:" + this.getPluginID() + ",version:" + this.getPluginVersion());
            String string = FileUtil.getUserFile("plugins").toString();
            String string2 = FileUtil.getApplicationFile("plugins").toString();
            String string3 = this.getPluginDirectoryName();
            String string4 = string3.startsWith(string2) ? "shared" : (string3.startsWith(string) ? "per-user" : "built-in");
            indentWriter.println("type:" + string4 + ",enabled:" + !this.getPluginState().isDisabled() + ",operational:" + this.getPluginState().isOperational());
            Object var7_6 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    public boolean isDisabled() {
        PluginDeprecation.call("isDisabled", this.given_plugin_id);
        return this.getPluginState().isDisabled();
    }

    public void setDisabled(boolean bl) {
        PluginDeprecation.call("setDisabled", this.given_plugin_id);
        this.getPluginState().setDisabled(bl);
    }

    public PluginState getPluginState() {
        return this.state;
    }

    PluginStateImpl getPluginStateImpl() {
        return this.state;
    }

    protected class propertyWrapper
    extends Properties {
        protected boolean initialising = true;

        protected propertyWrapper(Properties properties) {
            for (Object object : properties.keySet()) {
                this.put(object, properties.get(object));
            }
            this.initialising = false;
        }

        public Object setProperty(String string, String string2) {
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && (string.equalsIgnoreCase("plugin.id") || string.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + string + "' - action ignored"));
                }
                return null;
            }
            return super.setProperty(string, string2);
        }

        public Object put(Object object, Object object2) {
            String string;
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && !this.initialising && object instanceof String && ((string = (String)object).equalsIgnoreCase("plugin.id") || string.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + string + "' - action ignored"));
                }
                return null;
            }
            return super.put(object, object2);
        }

        public Object get(Object object) {
            return super.get(object);
        }
    }
}

