/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;

public class PluginManagerImpl
extends PluginManager {
    protected static boolean running = false;
    private static final boolean GET_PI_METHODS_OPERATIONAL_FLAG_DEFAULT = true;
    protected static PluginManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected static AzureusCore azureus_core;
    protected PluginInitializer pi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PluginManagerImpl getSingleton(PluginInitializer pluginInitializer) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginManagerImpl(pluginInitializer);
            }
            PluginManagerImpl pluginManagerImpl = singleton;
            Object var3_2 = null;
            class_mon.exit();
            return pluginManagerImpl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginManager startAzureus(int n, Properties properties) {
        String string;
        try {
            class_mon.enter();
            if (running) {
                throw new RuntimeException(Constants.APP_NAME + " is already running");
            }
            running = true;
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
        if (n == 0) {
            try {
                azureus_core = AzureusCoreFactory.create();
                azureus_core.start();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                throw new RuntimeException(Constants.APP_NAME + " failed to start", throwable);
            }
        } else if (n != 1 || properties == null || (string = (String)properties.get("MULTI_INSTANCE")) == null || string.equalsIgnoreCase("true")) {
            // empty if block
        }
        if (azureus_core == null) {
            throw new RuntimeException(Constants.APP_NAME + " core failed to initialise");
        }
        return azureus_core.getPluginManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAzureus() throws PluginException {
        try {
            class_mon.enter();
            if (!running) {
                throw new RuntimeException(Constants.APP_NAME + " is not running");
            }
            try {
                azureus_core.requestStop();
            }
            catch (Throwable throwable) {
                throw new PluginException("PluginManager: " + Constants.APP_NAME + " close action failed", throwable);
            }
            running = false;
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static void restartAzureus() throws PluginException {
        if (!running) {
            throw new RuntimeException(Constants.APP_NAME + " is not running");
        }
        try {
            azureus_core.requestRestart();
        }
        catch (Throwable throwable) {
            throw new PluginException("PluginManager: " + Constants.APP_NAME + " restart action failed", throwable);
        }
        running = false;
    }

    public static void setStartDetails(AzureusCore azureusCore) {
        azureus_core = azureusCore;
        running = true;
    }

    public static void registerPlugin(Class clazz) {
        PluginInitializer.queueRegistration(clazz);
    }

    public static void registerPlugin(Plugin plugin, String string) {
        PluginInitializer.queueRegistration(plugin, string);
    }

    public PluginInterface getPluginInterfaceByID(String string) {
        return this.getPluginInterfaceByID(string, true);
    }

    public PluginInterface getPluginInterfaceByID(String string, boolean bl) {
        PluginInterface[] pluginInterfaceArray = this.getPluginInterfaces();
        for (int i = 0; i < pluginInterfaceArray.length; ++i) {
            if (!pluginInterfaceArray[i].getPluginID().equalsIgnoreCase(string)) continue;
            if (bl && !pluginInterfaceArray[i].getPluginState().isOperational()) {
                return null;
            }
            return pluginInterfaceArray[i];
        }
        return null;
    }

    public PluginInterface getPluginInterfaceByClass(Class clazz) {
        return this.getPluginInterfaceByClass(clazz, true);
    }

    public PluginInterface getPluginInterfaceByClass(Class clazz, boolean bl) {
        PluginInterface[] pluginInterfaceArray = this.getPluginInterfaces();
        for (int i = 0; i < pluginInterfaceArray.length; ++i) {
            if (!pluginInterfaceArray[i].getPlugin().getClass().equals(clazz)) continue;
            if (bl && !pluginInterfaceArray[i].getPluginState().isOperational()) {
                return null;
            }
            return pluginInterfaceArray[i];
        }
        return null;
    }

    public PluginInterface getPluginInterfaceByClass(String string) {
        return this.getPluginInterfaceByClass(string, true);
    }

    public PluginInterface getPluginInterfaceByClass(String string, boolean bl) {
        PluginInterface[] pluginInterfaceArray = this.getPluginInterfaces();
        for (int i = 0; i < pluginInterfaceArray.length; ++i) {
            if (!pluginInterfaceArray[i].getPlugin().getClass().getName().equals(string)) continue;
            if (bl && !pluginInterfaceArray[i].getPluginState().isOperational()) {
                return null;
            }
            return pluginInterfaceArray[i];
        }
        return null;
    }

    public PluginInterface[] getPluginInterfaces() {
        List list = PluginInitializer.getPluginInterfaces();
        PluginInterface[] pluginInterfaceArray = new PluginInterface[list.size()];
        list.toArray(pluginInterfaceArray);
        return pluginInterfaceArray;
    }

    public PluginInterface getDefaultPluginInterface() {
        return PluginInitializer.getDefaultInterface();
    }

    protected PluginManagerImpl(PluginInitializer pluginInitializer) {
        this.pi = pluginInitializer;
        this.getPluginInstaller();
    }

    public PluginInterface[] getPlugins() {
        return this.pi.getPlugins();
    }

    public void firePluginEvent(int n) {
        PluginInitializer.fireEvent(n);
    }

    public PluginInstaller getPluginInstaller() {
        return null;
    }

    public void refreshPluginList(boolean bl) {
        List list = this.pi.loadPlugins(this.pi.getAzureusCore(), true, true, false, bl);
        for (PluginInterfaceImpl pluginInterfaceImpl : list) {
            if (pluginInterfaceImpl.getPluginState().isOperational()) continue;
            try {
                this.pi.reloadPlugin(pluginInterfaceImpl, false, bl);
            }
            catch (PluginException pluginException) {
                Debug.printStackTrace(pluginException);
            }
        }
    }

    public boolean isSilentRestartEnabled() {
        PluginInterface[] pluginInterfaceArray = this.pi.getPlugins();
        for (int i = 0; i < pluginInterfaceArray.length; ++i) {
            if (!pluginInterfaceArray[i].getPluginProperties().getProperty("plugin.silentrestart.disabled", "").equalsIgnoreCase("true")) continue;
            return false;
        }
        return true;
    }

    static {
        class_mon = new AEMonitor("PluginManager");
    }
}

