/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;

public class PluginStateImpl
implements PluginState {
    private PluginInterfaceImpl pi;
    private PluginInitializer initialiser;
    private boolean disabled;
    boolean operational;
    boolean failed;

    public PluginStateImpl(PluginInterfaceImpl pluginInterfaceImpl, PluginInitializer pluginInitializer) {
        this.pi = pluginInterfaceImpl;
        this.initialiser = pluginInitializer;
    }

    public void setLoadedAtStartup(boolean bl) {
        String string = "PluginInfo." + this.pi.getPluginID() + ".enabled";
        COConfigurationManager.setParameter(string, bl);
    }

    public boolean isLoadedAtStartup() {
        String string = "PluginInfo." + this.pi.getPluginID() + ".enabled";
        if (!COConfigurationManager.hasParameter(string, false)) {
            return true;
        }
        return COConfigurationManager.getBooleanParameter(string);
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isBuiltIn() {
        String string = this.pi.getPluginDirectoryName();
        if (string == null) {
            return PluginInitializer.isLoadingBuiltin();
        }
        return false;
    }

    public boolean isMandatory() {
        return true;
    }

    void setOperational(boolean bl, boolean bl2) {
        this.operational = bl;
        if (!bl2) {
            this.initialiser.fireOperational(this.pi, this.operational);
        }
    }

    public boolean isOperational() {
        return this.operational;
    }

    public boolean isShared() {
        String string = FileUtil.getApplicationFile("plugins").toString();
        String string2 = this.pi.getPluginDirectoryName();
        return string2.startsWith(string);
    }

    public void reload() throws PluginException {
        if (this.isUnloadable() || this.isOperational()) {
            this.unload(true);
        }
        this.initialiser.reloadPlugin(this.pi);
    }

    public void uninstall() throws PluginException {
    }

    public boolean isUnloaded() {
        return this.pi.class_loader == null;
    }

    public void unload() throws PluginException {
        this.unload(false);
    }

    protected void unload(boolean bl) throws PluginException {
        if (!this.isUnloadable()) {
            throw new PluginException("Plugin isn't unloadable");
        }
        String string = this.pi.getPluginDirectoryName();
        if (string == null || string.length() == 0) {
            ((UnloadablePlugin)this.pi.getPlugin()).unload();
            this.initialiser.unloadPlugin(this.pi);
        } else {
            ArrayList arrayList = new ArrayList(PluginInitializer.getPluginInterfaces());
            for (int i = 0; i < arrayList.size(); ++i) {
                PluginInterfaceImpl pluginInterfaceImpl = (PluginInterfaceImpl)arrayList.get(i);
                String string2 = pluginInterfaceImpl.getPluginDirectoryName();
                if (string2 == null || string2.length() == 0 || !string.equals(string2)) continue;
                ((UnloadablePlugin)pluginInterfaceImpl.getPlugin()).unload();
                this.initialiser.unloadPlugin(pluginInterfaceImpl);
            }
        }
        for (int i = 0; i < this.pi.children.size(); ++i) {
            ((PluginStateImpl)((PluginInterface)this.pi.children.get(i)).getPluginState()).unload(bl);
        }
        this.setOperational(false, bl);
        this.pi.class_loader = null;
    }

    public boolean isUnloadable() {
        int n;
        String string = this.pi.getPluginDirectoryName();
        boolean bl = this.pi.getPluginProperties().getProperty("plugin.unload.disabled", "").equalsIgnoreCase("true");
        if (bl) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return this.pi.getPlugin() instanceof UnloadablePlugin;
        }
        List list = PluginInitializer.getPluginInterfaces();
        for (n = 0; n < list.size(); ++n) {
            PluginInterface pluginInterface = (PluginInterface)list.get(n);
            String string2 = pluginInterface.getPluginDirectoryName();
            if (string2 == null || string2.length() == 0 || !string.equals(string2) || pluginInterface.getPlugin() instanceof UnloadablePlugin) continue;
            return false;
        }
        for (n = 0; n < this.pi.children.size(); ++n) {
            if (((PluginInterface)this.pi.children.get(n)).getPluginState().isUnloadable()) continue;
            return false;
        }
        return true;
    }
}

