/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.clientid;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ClientIDManagerImpl
implements ClientIDManager {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected static ClientIDManagerImpl singleton = new ClientIDManagerImpl();
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private ClientIDGenerator generator_user_accessor;
    private boolean use_filter;
    private boolean filter_override;
    private ThreadPool thread_pool;
    private int filter_port;

    public static ClientIDManagerImpl getSingleton() {
        return singleton;
    }

    public void setGenerator(ClientIDGenerator clientIDGenerator, boolean bl) {
        Object object;
        String string;
        String string2;
        this.checkGenerator(clientIDGenerator);
        this.generator_user_accessor = clientIDGenerator;
        this.use_filter = bl;
        if (!this.use_filter) {
            string2 = System.getProperty("http.proxyHost");
            string = System.getProperty("socksProxyHost");
            InetAddress inetAddress = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
            if (!(string2 != null && string2.trim().length() != 0 || string != null && string.trim().length() != 0 || inetAddress == null || inetAddress.isAnyLocalAddress())) {
                int n = 0;
                try {
                    object = NetworkInterface.getNetworkInterfaces();
                    while (object.hasMoreElements()) {
                        NetworkInterface networkInterface2 = object.nextElement();
                        Enumeration<InetAddress> enumeration = networkInterface2.getInetAddresses();
                        while (enumeration.hasMoreElements()) {
                            InetAddress inetAddress2 = enumeration.nextElement();
                            if (inetAddress2.isLoopbackAddress()) continue;
                            ++n;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Logger.log(new LogEvent(LOGID, "", throwable));
                }
                if (n > 1) {
                    this.filter_override = true;
                    this.use_filter = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "ClientIDManager: overriding filter option to support local bind IP"));
                    }
                }
            }
        }
        if (this.use_filter) {
            try {
                this.thread_pool = new ThreadPool("ClientIDManager", 32);
                string2 = System.getProperty("sun.net.client.defaultConnectTimeout");
                string = System.getProperty("sun.net.client.defaultReadTimeout");
                int n = Integer.parseInt(string2) + Integer.parseInt(string);
                this.thread_pool.setExecutionLimit(n);
                final ServerSocket serverSocket = new ServerSocket(0, 1024, InetAddress.getByName("127.0.0.1"));
                this.filter_port = serverSocket.getLocalPort();
                serverSocket.setReuseAddress(true);
                object = new AEThread("ClientIDManager::filterloop"){

                    public void runSupport() {
                        long l = 0L;
                        long l2 = 0L;
                        while (true) {
                            try {
                                while (true) {
                                    Socket socket = serverSocket.accept();
                                    ++l;
                                    ClientIDManagerImpl.this.thread_pool.run(new httpFilter(socket));
                                }
                            }
                            catch (Throwable throwable) {
                                ++l2;
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + ClientIDManagerImpl.this.filter_port, throwable));
                                if (l2 <= 100L || l != 0L) continue;
                                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + ClientIDManagerImpl.this.filter_port, "TCP"});
                                ClientIDManagerImpl.this.use_filter = false;
                                return;
                            }
                            break;
                        }
                    }
                };
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener established on port " + this.filter_port));
                }
            }
            catch (Throwable throwable) {
                Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.filter_port});
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + this.filter_port, throwable));
                }
                this.use_filter = false;
            }
        }
    }

    public ClientIDGenerator getGenerator() {
        this.checkGenerator(this.generator_user_accessor);
        return this.generator_user_accessor;
    }

    protected void checkGenerator(ClientIDGenerator clientIDGenerator) {
        ClassLoader classLoader = clientIDGenerator.getClass().getClassLoader();
        if (classLoader != null && classLoader != ClientIDManager.class.getClassLoader()) {
            Debug.out("Generator isn't trusted - " + clientIDGenerator);
            throw new RuntimeException("Generator isn't trusted");
        }
    }

    public byte[] generatePeerID(TOTorrent tOTorrent, boolean bl) throws ClientIDException {
        return this.getGenerator().generatePeerID(new TorrentImpl(tOTorrent), bl);
    }

    public void generateHTTPProperties(Properties properties) throws ClientIDException {
        if (this.use_filter) {
            URL uRL = (URL)properties.get("URL");
            if (!uRL.getProtocol().toLowerCase().equals("http")) {
                Logger.log(new LogAlert(false, 3, "ClientIDManager only supports filtering of http, not https"));
                return;
            }
            try {
                String string = uRL.toString();
                String string2 = uRL.getHost();
                int n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
                int n2 = string.indexOf(string2);
                String string3 = string.substring(0, n2) + "127.0.0.1:" + this.filter_port;
                String string4 = string.substring(n2 + string2.length());
                if (string4.charAt(0) == ':') {
                    string4 = string4.substring(("" + n).length() + 1);
                }
                int n3 = string4.indexOf(63);
                string3 = string3 + string4.substring(0, n3 + 1) + "cid=" + string2 + ":" + n + "&" + string4.substring(n3 + 1);
                properties.put("URL", new URL(string3));
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        } else {
            this.getGenerator().generateHTTPProperties(properties);
        }
    }

    protected class httpFilter
    extends ThreadPoolTask {
        private Socket socket;

        protected httpFilter(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void runSupport() {
            block35: {
                Serializable serializable2222;
                int n;
                String string;
                block33: {
                    int n2;
                    String[] stringArray;
                    Object object;
                    String string2;
                    int n3;
                    string = null;
                    n = 0;
                    this.setTaskState("reading header");
                    InputStream inputStream = this.socket.getInputStream();
                    byte[] byArray = new byte[1024];
                    String string3 = "";
                    while ((n3 = inputStream.read(byArray)) != -1 && !(string3 = string3 + new String(byArray, 0, n3, "ISO-8859-1")).endsWith("\r\n\r\n") && string3.indexOf("\r\n\r\n") == -1) {
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n4 = 0;
                    while (true) {
                        int n5;
                        string2 = (n5 = string3.indexOf(ClientIDManagerImpl.NL, n4)) == -1 ? string3.substring(n4) : string3.substring(n4, n5);
                        if ((string2 = string2.trim()).length() > 0) {
                            arrayList.add(string2);
                        }
                        if (n5 == -1) break;
                        n4 = n5 + 2;
                    }
                    String[] stringArray2 = new String[arrayList.size()];
                    arrayList.toArray(stringArray2);
                    string2 = stringArray2[0];
                    int n6 = string2.indexOf("?cid=");
                    int n7 = string2.indexOf("&", n6);
                    String string4 = string2.substring(n6 + 5, n7);
                    int n8 = string4.indexOf(":");
                    String string5 = string4.substring(0, n8);
                    int n9 = Integer.parseInt(string4.substring(n8 + 1));
                    for (int i = 1; i < stringArray2.length; ++i) {
                        object = stringArray2[i];
                        if (((String)object).toLowerCase().indexOf("host:") == -1) continue;
                        stringArray2[i] = "Host: " + string5 + ":" + n9;
                        break;
                    }
                    stringArray2[0] = string2 = string2.substring(0, n6 + 1) + string2.substring(n7 + 1);
                    if (ClientIDManagerImpl.this.filter_override) {
                        stringArray = stringArray2;
                        object = new Properties();
                        ClientIDManagerImpl.this.getGenerator().generateHTTPProperties((Properties)object);
                        String string6 = ((Properties)object).getProperty("User-Agent");
                        if (string6 != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!stringArray[i].toLowerCase().startsWith("user-agent")) continue;
                                stringArray[i] = "User-Agent: " + string6;
                            }
                        }
                    } else {
                        stringArray = ClientIDManagerImpl.this.getGenerator().filterHTTP(stringArray2);
                    }
                    object = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        object = (String)object + stringArray[i] + ClientIDManagerImpl.NL;
                    }
                    object = (String)object + ClientIDManagerImpl.NL;
                    Socket socket = new Socket();
                    InetAddress inetAddress = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                    if (inetAddress != null) {
                        socket.bind(new InetSocketAddress(inetAddress, 0));
                    }
                    socket.connect(new InetSocketAddress(string5, n9));
                    socket.getOutputStream().write(((String)object).getBytes("ISO-8859-1"));
                    socket.getOutputStream().flush();
                    InputStream inputStream2 = socket.getInputStream();
                    while ((n2 = inputStream2.read(byArray)) != -1) {
                        this.socket.getOutputStream().write(byArray, 0, n2);
                        n += n2;
                    }
                    Object var23_31 = null;
                    if (string == null || n != 0) break block33;
                    serializable2222 = new HashMap();
                    serializable2222.put("failure reason", string);
                    try {
                        byte[] byArray2 = BEncoder.encode((Map)((Object)serializable2222));
                        this.socket.getOutputStream().write(byArray2);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                try {
                    this.socket.getOutputStream().flush();
                    this.socket.close();
                }
                catch (Throwable serializable2222) {}
                break block35;
                {
                    catch (ClientIDException clientIDException) {
                        Serializable serializable32222;
                        string = clientIDException.getMessage();
                        Object var23_32 = null;
                        if (string != null && n == 0) {
                            serializable32222 = new HashMap();
                            serializable32222.put("failure reason", string);
                            try {
                                byte[] byArray = BEncoder.encode((Map)((Object)serializable32222));
                                this.socket.getOutputStream().write(byArray);
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable serializable32222) {}
                        break block35;
                    }
                    catch (UnknownHostException unknownHostException) {
                        Serializable serializable42222;
                        string = "Unknown host '" + unknownHostException.getMessage() + "'";
                        Object var23_33 = null;
                        if (string != null && n == 0) {
                            serializable42222 = new HashMap();
                            serializable42222.put("failure reason", string);
                            try {
                                byte[] byArray = BEncoder.encode((Map)((Object)serializable42222));
                                this.socket.getOutputStream().write(byArray);
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable serializable42222) {}
                        break block35;
                    }
                    catch (Throwable throwable) {
                        Serializable serializable52222;
                        Object var23_34 = null;
                        if (string != null && n == 0) {
                            serializable52222 = new HashMap();
                            serializable52222.put("failure reason", string);
                            try {
                                byte[] byArray = BEncoder.encode((Map)((Object)serializable52222));
                                this.socket.getOutputStream().write(byArray);
                            }
                            catch (Throwable throwable2) {
                                Debug.printStackTrace(throwable2);
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable serializable52222) {}
                    }
                }
                catch (Throwable throwable) {
                    Serializable serializable62222;
                    Object var23_35 = null;
                    if (string != null && n == 0) {
                        serializable62222 = new HashMap();
                        serializable62222.put("failure reason", string);
                        try {
                            byte[] byArray = BEncoder.encode((Map)((Object)serializable62222));
                            this.socket.getOutputStream().write(byArray);
                        }
                        catch (Throwable throwable3) {
                            Debug.printStackTrace(throwable3);
                        }
                    }
                    try {
                        this.socket.getOutputStream().flush();
                        this.socket.close();
                    }
                    catch (Throwable serializable62222) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        public void interruptTask() {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

