/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ddb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;

public class DDBaseHelpers {
    protected static byte[] encode(Object object) throws DistributedDatabaseException {
        byte[] byArray;
        if (object == null) {
            throw new DistributedDatabaseException("null not supported");
        }
        if (object instanceof byte[]) {
            byArray = (byte[])object;
        } else {
            if (object instanceof String) {
                try {
                    byArray = ((String)object).getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new DistributedDatabaseException("charset error", unsupportedEncodingException);
                }
            }
            if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean) {
                throw new DistributedDatabaseException("not supported yet!");
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                throw new DistributedDatabaseException("encoding fails", throwable);
            }
        }
        return byArray;
    }

    protected static Object decode(Class clazz, byte[] byArray) throws DistributedDatabaseException {
        if (clazz == byte[].class) {
            return byArray;
        }
        if (clazz == String.class) {
            try {
                return new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new DistributedDatabaseException("charset error", unsupportedEncodingException);
            }
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Object object = objectInputStream.readObject();
            if (clazz.isInstance(object)) {
                return object;
            }
            throw new DistributedDatabaseException("decoding fails, incompatible type");
        }
        catch (DistributedDatabaseException distributedDatabaseException) {
            throw distributedDatabaseException;
        }
        catch (Throwable throwable) {
            throw new DistributedDatabaseException("decoding fails", throwable);
        }
    }

    protected static HashWrapper getKey(Class clazz) throws DistributedDatabaseException {
        String string = clazz.getName();
        if (string == null) {
            throw new DistributedDatabaseException("name doesn't exist for '" + clazz.getName() + "'");
        }
        return new HashWrapper(new SHA1Simple().calculateHash(string.getBytes()));
    }
}

