/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.deprecate;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.deprecate.PluginDeprecationException;

public class PluginDeprecation {
    private static final String CONFIG_KEY = "PluginDeprecationWarnings";
    private static final String FORUM_STABLE_LINK = "http://forum.vuze.com/forum.jspa?forumID=3";
    private static final String FORUM_BETA_LINK = "http://forum.vuze.com/forum.jspa?forumID=4";
    private static final int IGNORE = 0;
    private static final int NOTIFY_ONCE = 1;
    private static final int NOTIFY_EVERY = 2;
    private static final int NOTIFY_AND_DIE = 3;
    private static final int DIE = 4;
    private static BasicPluginViewModel model = null;
    private static LoggerChannel channel = null;
    private static Map behaviour_mapping = new HashMap();
    private static Set persistent_warnings = Collections.synchronizedSet(new HashSet());
    private static Set instance_warnings = Collections.synchronizedSet(new HashSet());

    private static void register(String string, int n, int n2) {
        behaviour_mapping.put(string, new Integer(Constants.isCVSVersion() ? n2 : n));
    }

    public static void call(String string, Object object) {
        PluginDeprecation.call(string, object.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void call(String string, String string2) {
        Integer n = (Integer)behaviour_mapping.get(string);
        if (n == null) {
            throw new IllegalArgumentException("unknown deprecated call identifier: " + string);
        }
        int n2 = n;
        if (n2 == 0) {
            return;
        }
        boolean bl = n2 == 1;
        boolean bl2 = n2 != 4;
        boolean bl3 = n2 == 3 || n2 == 4;
        String string3 = string2 + ":" + string;
        if (!(!bl2 || instance_warnings.contains(string2) || bl && persistent_warnings.contains(string3))) {
            Object object;
            instance_warnings.add(string2);
            if (!bl && persistent_warnings.remove(string3)) {
                COConfigurationManager.setParameter(CONFIG_KEY, new StringListImpl(persistent_warnings));
            }
            Class<PluginDeprecation> clazz = PluginDeprecation.class;
            // MONITORENTER : org.gudy.azureus2.pluginsimpl.local.deprecate.PluginDeprecation.class
            if (model == null) {
                object = PluginInitializer.getDefaultInterface();
                model = object.getUIManager().createBasicPluginViewModel(MessageText.getString("PluginDeprecation.view"));
                model.getStatus().setVisible(false);
                model.getProgress().setVisible(false);
                model.getActivity().setVisible(false);
                model.getLogArea().appendText(MessageText.getString("PluginDeprecation.log.start", new String[]{Constants.isCVSVersion() ? FORUM_BETA_LINK : FORUM_STABLE_LINK}));
                UIManagerListener uIManagerListener = new UIManagerListener(){

                    public void UIAttached(UIInstance uIInstance) {
                    }

                    public void UIDetached(UIInstance uIInstance) {
                    }
                };
                object.getUIManager().addUIListener(uIManagerListener);
            }
            object = MessageText.getString("PluginDeprecation.log.details", new String[]{string, string2, Debug.getStackTrace(false, false)});
            model.getLogArea().appendText((String)object);
            if (channel == null) {
                channel = PluginInitializer.getDefaultInterface().getLogger().getChannel("PluginDeprecation");
            }
            channel.logAlert(2, MessageText.getString("PluginDeprecation.alert"));
            Debug.out(new PluginDeprecationException("Deprecated plugin call - " + string3).fillInStackTrace());
            // MONITOREXIT : clazz
            if (bl) {
                persistent_warnings.add(string3);
                COConfigurationManager.setParameter(CONFIG_KEY, new StringListImpl(persistent_warnings));
            }
        }
        if (!bl3) return;
        throw new PluginDeprecationException(string3);
    }

    static {
        PluginDeprecation.register("property listener", 0, 2);
        PluginDeprecation.register("createPluginView", 0, 2);
        PluginDeprecation.register("getSWTManager", 0, 0);
        PluginDeprecation.register("openTorrentFile", 0, 2);
        PluginDeprecation.register("openTorrentURL", 0, 2);
        PluginDeprecation.register("setDisabled", 0, 1);
        PluginDeprecation.register("isDisabled", 0, 1);
        PluginDeprecation.register("isBuiltIn", 0, 1);
        PluginDeprecation.register("isMandatory", 0, 1);
        PluginDeprecation.register("isOperational", 0, 1);
        PluginDeprecation.register("isShared", 0, 1);
        PluginDeprecation.register("unload", 0, 1);
        PluginDeprecation.register("reload", 0, 1);
        PluginDeprecation.register("uninstall", 0, 1);
        PluginDeprecation.register("isUnloadable", 0, 1);
        persistent_warnings.addAll(Arrays.asList(COConfigurationManager.getStringListParameter(CONFIG_KEY).toArray()));
    }
}

