/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerChannelImpl
implements DiskManagerChannel,
DiskManagerFileInfoListener,
DownloadManagerPeerListener,
PieceRTAProvider {
    private static int BUFFER_MILLIS;
    private static int MIN_PIECES_TO_BUFFER;
    private static final boolean TRACE = false;
    private static final int COMPACT_DELAY = 32;
    private static final int MAX_READ_CHUNK_DEFAULT = 65536;
    private static final Comparator comparator;
    private static final String channel_key = "DiskManagerChannel";
    private static int channel_id_next;
    private static CopyOnWriteList listeners;
    private DownloadImpl download;
    private DiskManagerFileInfoImpl plugin_file;
    private org.gudy.azureus2.core3.disk.DiskManagerFileInfo core_file;
    private Set data_written = new TreeSet(comparator);
    private int compact_delay = 32;
    private List waiters = new ArrayList();
    private long file_offset_in_torrent;
    private long piece_size;
    private Average byte_rate = Average.getInstance(1000, 20);
    private long start_position;
    private long start_time;
    private long current_position;
    private request current_request;
    private long buffer_millis;
    private PEPeerManager peer_manager;
    private long[] rtas;
    private int channel_id;

    public static void addListener(channelCreateListener channelCreateListener2) {
        listeners.add(channelCreateListener2);
    }

    public static void removeListener(channelCreateListener channelCreateListener2) {
        listeners.remove(channelCreateListener2);
    }

    protected static void reportCreated(DiskManagerChannel diskManagerChannel) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((channelCreateListener)iterator.next()).channelCreated(diskManagerChannel);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskManagerChannelImpl(DownloadImpl downloadImpl, DiskManagerFileInfoImpl diskManagerFileInfoImpl) {
        this.download = downloadImpl;
        this.plugin_file = diskManagerFileInfoImpl;
        this.core_file = this.plugin_file.getCore();
        Object object = DiskManagerChannelImpl.class;
        synchronized (DiskManagerChannelImpl.class) {
            this.channel_id = channel_id_next++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = this.core_file.getTorrentFile();
            TOTorrent tOTorrent = object.getTorrent();
            TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            this.rtas = new long[tOTorrent.getNumberOfPieces()];
            this.core_file.getDownloadManager().addPeerListener(this);
            for (int i = 0; i < this.core_file.getIndex(); ++i) {
                this.file_offset_in_torrent += tOTorrentFileArray[i].getLength();
            }
            this.piece_size = object.getTorrent().getPieceLength();
            this.core_file.addListener(this);
            DiskManagerChannelImpl.reportCreated(this);
            return;
        }
    }

    public DiskManagerFileInfo getFile() {
        return this.plugin_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerRequest createRequest() {
        if (this.core_file.getDownloaded() != this.core_file.getLength()) {
            boolean bl;
            if (this.core_file.isSkipped()) {
                this.core_file.setSkipped(false);
            }
            if (!(bl = this.download.isForceStart())) {
                DownloadImpl downloadImpl = this.download;
                synchronized (downloadImpl) {
                    HashMap<String, String> hashMap = (HashMap<String, String>)this.download.getDownload().getData(channel_key);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                        this.download.getDownload().setData(channel_key, hashMap);
                    }
                    hashMap.put("" + this.channel_id, "");
                }
                this.download.setForceStart(true);
            }
        }
        this.current_request = new request();
        return this.current_request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataWritten(long l, long l2) {
        dataEntry dataEntry2 = new dataEntry(l, l2);
        Set set = this.data_written;
        synchronized (set) {
            this.data_written.add(dataEntry2);
            --this.compact_delay;
            if (this.compact_delay == 0) {
                this.compact_delay = 32;
                Iterator iterator = this.data_written.iterator();
                dataEntry dataEntry3 = null;
                while (iterator.hasNext()) {
                    dataEntry dataEntry4 = (dataEntry)iterator.next();
                    if (dataEntry3 == null) {
                        dataEntry3 = dataEntry4;
                        continue;
                    }
                    long l3 = dataEntry3.getOffset();
                    long l4 = dataEntry3.getLength();
                    long l5 = dataEntry4.getOffset();
                    long l6 = dataEntry4.getLength();
                    if (l5 <= l3 + l4) {
                        iterator.remove();
                        dataEntry3.setLength(Math.max(l3 + l4, l5 + l6) - l3);
                        continue;
                    }
                    dataEntry3 = dataEntry4;
                }
            }
            for (int i = 0; i < this.waiters.size(); ++i) {
                ((AESemaphore)this.waiters.get(i)).release();
            }
        }
    }

    public void dataChecked(long l, long l2) {
    }

    public void peerManagerWillBeAdded(PEPeerManager pEPeerManager) {
    }

    public void peerManagerAdded(PEPeerManager pEPeerManager) {
        this.peer_manager = pEPeerManager;
        pEPeerManager.getPiecePicker().addRTAProvider(this);
    }

    public void peerManagerRemoved(PEPeerManager pEPeerManager) {
        this.peer_manager = null;
        pEPeerManager.getPiecePicker().removeRTAProvider(this);
    }

    public void peerAdded(PEPeer pEPeer) {
    }

    public void peerRemoved(PEPeer pEPeer) {
    }

    public long[] updateRTAs(PiecePicker piecePicker) {
        long l = this.current_position + this.file_offset_in_torrent;
        int n = (int)(l / this.piece_size);
        long l2 = this.byte_rate.getAverage();
        long l3 = (long)BUFFER_MILLIS * l2 / 1000L;
        int n2 = (int)(l3 / this.piece_size);
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = BUFFER_MILLIS / n2;
        if (n2 < MIN_PIECES_TO_BUFFER) {
            n2 = MIN_PIECES_TO_BUFFER;
        }
        Arrays.fill(this.rtas, 0L);
        long l4 = SystemTime.getCurrentTime();
        l4 += this.buffer_millis;
        for (int i = n; i < n + n2 && i < this.rtas.length; ++i) {
            this.rtas[i] = l4 + (long)((i - n) * n3);
        }
        return this.rtas;
    }

    public long getStartTime() {
        return this.start_time;
    }

    public long getStartPosition() {
        return this.start_position;
    }

    public long getCurrentPosition() {
        return this.current_position;
    }

    public long getBlockingPosition() {
        request request2 = this.current_request;
        if (request2 == null) {
            return this.current_position;
        }
        return this.current_position + request2.getAvailableBytes();
    }

    public void setBufferMillis(long l) {
        this.buffer_millis = l;
    }

    public String getUserAgent() {
        request request2 = this.current_request;
        if (request2 == null) {
            return null;
        }
        return request2.getUserAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.core_file.removeListener(this);
        this.core_file.getDownloadManager().removePeerListener(this);
        if (this.peer_manager != null) {
            this.peer_manager.getPiecePicker().removeRTAProvider(this);
        }
        boolean bl = false;
        DownloadImpl downloadImpl = this.download;
        synchronized (downloadImpl) {
            Map map = (Map)this.download.getDownload().getData(channel_key);
            if (map != null) {
                map.remove("" + this.channel_id);
                if (map.size() == 0) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.download.setForceStart(false);
        }
    }

    static /* synthetic */ long access$502(DiskManagerChannelImpl diskManagerChannelImpl, long l) {
        diskManagerChannelImpl.current_position = l;
        return diskManagerChannelImpl.current_position;
    }

    static /* synthetic */ org.gudy.azureus2.core3.disk.DiskManagerFileInfo access$800(DiskManagerChannelImpl diskManagerChannelImpl) {
        return diskManagerChannelImpl.core_file;
    }

    static /* synthetic */ Average access$900(DiskManagerChannelImpl diskManagerChannelImpl) {
        return diskManagerChannelImpl.byte_rate;
    }

    static /* synthetic */ List access$1000(DiskManagerChannelImpl diskManagerChannelImpl) {
        return diskManagerChannelImpl.waiters;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis", "filechannel.rt.buffer.pieces"}, new ParameterListener(){

            public void parameterChanged(String string) {
                BUFFER_MILLIS = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                MIN_PIECES_TO_BUFFER = COConfigurationManager.getIntParameter("filechannel.rt.buffer.pieces");
            }
        });
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                dataEntry dataEntry2 = (dataEntry)object;
                dataEntry dataEntry3 = (dataEntry)object2;
                long l = dataEntry2.getOffset();
                long l2 = dataEntry2.getLength();
                long l3 = dataEntry3.getOffset();
                long l4 = dataEntry3.getLength();
                long l5 = l == l3 ? l2 - l4 : l - l3;
                if (l5 == 0L) {
                    return 0;
                }
                if (l5 < 0L) {
                    return -1;
                }
                return 1;
            }
        };
        listeners = new CopyOnWriteList();
    }

    protected static class dataEntry {
        private long offset;
        private long length;

        protected dataEntry(long l, long l2) {
            this.offset = l;
            this.length = l2;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected long getLength() {
            return this.length;
        }

        protected void setLength(long l) {
            this.length = l;
        }

        protected String getString() {
            return "offset=" + this.offset + ",length=" + this.length;
        }
    }

    protected class request
    implements DiskManagerRequest {
        private int request_type;
        private long request_offset;
        private long request_length;
        private List listeners = new ArrayList();
        private String user_agent;
        private int max_read_chunk = 65536;
        private volatile boolean cancelled;
        AESemaphore wait_sem = new AESemaphore("DiskManagerChannelImpl:wait");

        protected request() {
            DiskManagerChannelImpl.this.start_time = SystemTime.getCurrentTime();
        }

        public void setType(int n) {
            this.request_type = n;
        }

        public void setOffset(long l) {
            this.request_offset = l;
            DiskManagerChannelImpl.this.start_position = this.request_offset;
        }

        public void setLength(long l) {
            if (l < 0L) {
                throw new RuntimeException("Illegal argument");
            }
            this.request_length = l;
        }

        public void setMaximumReadChunkSize(int n) {
            this.max_read_chunk = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getRemaining() {
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                return this.request_length - (DiskManagerChannelImpl.this.current_position - this.request_offset);
            }
        }

        public void setUserAgent(String string) {
            this.user_agent = string;
        }

        protected String getUserAgent() {
            return this.user_agent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getAvailableBytes() {
            if (DiskManagerChannelImpl.this.plugin_file.getDownloaded() == DiskManagerChannelImpl.this.plugin_file.getLength()) {
                return this.getRemaining();
            }
            int n = DiskManagerChannelImpl.this.download.getState();
            if (n != 4 && n != 5) {
                return -1L;
            }
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                Iterator iterator = DiskManagerChannelImpl.this.data_written.iterator();
                dataEntry dataEntry2 = null;
                while (iterator.hasNext()) {
                    dataEntry dataEntry3 = (dataEntry)iterator.next();
                    long l = dataEntry3.getOffset();
                    long l2 = dataEntry3.getLength();
                    if (dataEntry2 == null) {
                        if (l > DiskManagerChannelImpl.this.current_position) break;
                        if (l > DiskManagerChannelImpl.this.current_position || DiskManagerChannelImpl.this.current_position >= l + l2) continue;
                        dataEntry2 = dataEntry3;
                        continue;
                    }
                    if (dataEntry2.getOffset() + dataEntry2.getLength() != dataEntry3.getOffset()) break;
                    dataEntry2 = dataEntry3;
                }
                if (dataEntry2 == null) {
                    return 0L;
                }
                return dataEntry2.getOffset() + dataEntry2.getLength() - DiskManagerChannelImpl.this.current_position;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = this.request_length;
            var3_2 = this.request_offset;
            try {
                while (var1_1 > 0L) {
                    if (this.cancelled != false) return;
                    var5_5 = 0;
                    var6_7 = DiskManagerChannelImpl.access$400(DiskManagerChannelImpl.this);
                    synchronized (var6_7) {
                        DiskManagerChannelImpl.access$502(DiskManagerChannelImpl.this, var3_2);
                        var7_8 = DiskManagerChannelImpl.access$400(DiskManagerChannelImpl.this).iterator();
                        while (var7_8.hasNext() && (var9_10 = (var8_9 = (dataEntry)var7_8.next()).getOffset()) <= var3_2) {
                            var11_11 = var8_9.getLength();
                            var13_12 = var9_10 + var11_11 - var3_2;
                            if (var13_12 <= 0L) continue;
                            var5_5 = (int)var13_12;
                            break;
                        }
                        ** if (var5_5 <= 0) goto lbl32
                    }
lbl-1000:
                    // 1 sources

                    {
                        if ((long)var5_5 > var1_1) {
                            var5_5 = (int)var1_1;
                        }
                        if (var5_5 > this.max_read_chunk) {
                            var5_5 = this.max_read_chunk;
                        }
                        var6_7 = DiskManagerChannelImpl.access$800(DiskManagerChannelImpl.this).read(var3_2, var5_5);
                        this.inform(new event(new PooledByteBufferImpl((DirectByteBuffer)var6_7), var3_2, var5_5));
                        var1_1 -= (long)var5_5;
                        var7_8 = DiskManagerChannelImpl.access$400(DiskManagerChannelImpl.this);
                        synchronized (var7_8) {
                            DiskManagerChannelImpl.access$900(DiskManagerChannelImpl.this).addValue(var5_5);
                            DiskManagerChannelImpl.access$502(DiskManagerChannelImpl.this, var3_2 += (long)var5_5);
                            continue;
                        }
                    }
lbl32:
                    // 1 sources

                    this.inform(new event(var3_2));
                    var6_7 = DiskManagerChannelImpl.access$400(DiskManagerChannelImpl.this);
                    synchronized (var6_7) {
                        DiskManagerChannelImpl.access$1000(DiskManagerChannelImpl.this).add(this.wait_sem);
                    }
                    try {
                        this.wait_sem.reserve();
                        var19_3 = null;
                    }
                    catch (Throwable var18_13) {
                        var19_3 = null;
                        var20_4 = DiskManagerChannelImpl.access$400(DiskManagerChannelImpl.this);
                        synchronized (var20_4) {
                            DiskManagerChannelImpl.access$1000(DiskManagerChannelImpl.this).remove(this.wait_sem);
                            throw var18_13;
                        }
                    }
                    var20_4 = DiskManagerChannelImpl.access$400(DiskManagerChannelImpl.this);
                    synchronized (var20_4) {
                        DiskManagerChannelImpl.access$1000(DiskManagerChannelImpl.this).remove(this.wait_sem);
                    }
                }
                return;
            }
            catch (Throwable var5_6) {
                this.inform(var5_6);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.inform(new Throwable("Request cancelled"));
            this.wait_sem.release();
        }

        protected void inform(Throwable throwable) {
            this.inform(new event(throwable));
        }

        protected void inform(event event2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((DiskManagerListener)this.listeners.get(i)).eventOccurred(event2);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }

        public void addListener(DiskManagerListener diskManagerListener) {
            this.listeners.add(diskManagerListener);
        }

        public void removeListener(DiskManagerListener diskManagerListener) {
            this.listeners.remove(diskManagerListener);
        }

        protected class event
        implements DiskManagerEvent {
            private int event_type;
            private Throwable error;
            private PooledByteBuffer buffer;
            private long event_offset;
            private int event_length;

            protected event(Throwable throwable) {
                this.event_type = 2;
                this.error = throwable;
            }

            protected event(long l) {
                this.event_type = 3;
                this.event_offset = l;
            }

            protected event(PooledByteBuffer pooledByteBuffer, long l, int n) {
                this.event_type = 1;
                this.buffer = pooledByteBuffer;
                this.event_offset = l;
                this.event_length = n;
            }

            public int getType() {
                return this.event_type;
            }

            public DiskManagerRequest getRequest() {
                return request.this;
            }

            public long getOffset() {
                return this.event_offset;
            }

            public int getLength() {
                return this.event_length;
            }

            public PooledByteBuffer getBuffer() {
                return this.buffer;
            }

            public Throwable getFailure() {
                return this.error;
            }
        }
    }

    public static interface channelCreateListener {
        public void channelCreated(DiskManagerChannel var1);
    }
}

