/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.peers.PeerManager;

public class DownloadAnnounceResultImpl
implements DownloadAnnounceResult {
    protected Download download;
    protected TRTrackerAnnouncerResponse response;

    public DownloadAnnounceResultImpl(Download download, TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
        this.download = download;
        this.response = tRTrackerAnnouncerResponse;
    }

    public void setContent(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
        this.response = tRTrackerAnnouncerResponse;
    }

    public Download getDownload() {
        return this.download;
    }

    public int getResponseType() {
        if (this.response == null) {
            return 2;
        }
        int n = this.response.getStatus();
        if (n == 2) {
            return 1;
        }
        return 2;
    }

    public int getReportedPeerCount() {
        return this.response == null || this.response.getPeers() == null ? 0 : this.response.getPeers().length;
    }

    public int getSeedCount() {
        PeerManager peerManager = this.download.getPeerManager();
        if (peerManager != null) {
            return peerManager.getStats().getConnectedSeeds();
        }
        return 0;
    }

    public int getNonSeedCount() {
        PeerManager peerManager = this.download.getPeerManager();
        if (peerManager != null) {
            return peerManager.getStats().getConnectedLeechers();
        }
        return 0;
    }

    public String getError() {
        return this.response == null ? "No Response" : this.response.getAdditionalInfo();
    }

    public URL getURL() {
        return this.response == null ? null : this.response.getURL();
    }

    public DownloadAnnounceResultPeer[] getPeers() {
        if (this.response == null) {
            return new DownloadAnnounceResultPeer[0];
        }
        return this.response.getPeers();
    }

    public long getTimeToWait() {
        if (this.response == null) {
            return -1L;
        }
        return this.response.getTimeToWait();
    }

    public Map getExtensions() {
        if (this.response == null) {
            return null;
        }
        return this.response.getExtensions();
    }
}

