/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadEventNotifier;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.download.savelocation.DefaultSaveLocationManager;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadEventNotifierImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;

public class DownloadManagerImpl
implements DownloadManager,
DownloadManagerInitialisationAdapter {
    protected static DownloadManagerImpl singleton;
    protected static AEMonitor class_mon;
    private GlobalManager global_manager;
    private DownloadManagerStats stats;
    private DownloadEventNotifierImpl global_dl_notifier;
    private List listeners = new ArrayList();
    private CopyOnWriteList dwba_listeners = new CopyOnWriteList();
    private AEMonitor listeners_mon = new AEMonitor("DownloadManager:L");
    private List downloads = new ArrayList();
    private Map pending_dls = new HashMap();
    private Map download_map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadManagerImpl getSingleton(AzureusCore azureusCore) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new DownloadManagerImpl(azureusCore);
            }
            DownloadManagerImpl downloadManagerImpl = singleton;
            Object var3_2 = null;
            class_mon.exit();
            return downloadManagerImpl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected DownloadManagerImpl(AzureusCore azureusCore) {
        this.global_manager = azureusCore.getGlobalManager();
        this.stats = new DownloadManagerStatsImpl(this.global_manager);
        this.global_dl_notifier = new DownloadEventNotifierImpl(this);
        this.global_manager.addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(org.gudy.azureus2.core3.download.DownloadManager downloadManager) {
                DownloadManagerImpl.this.addDownloadManager(downloadManager);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadManagerRemoved(org.gudy.azureus2.core3.download.DownloadManager downloadManager) {
                List list = null;
                DownloadImpl downloadImpl = null;
                try {
                    DownloadManagerImpl.this.listeners_mon.enter();
                    downloadImpl = (DownloadImpl)DownloadManagerImpl.this.download_map.get(downloadManager);
                    if (downloadImpl == null) {
                        System.out.println("DownloadManager:unknown manager removed");
                    } else {
                        DownloadManagerImpl.this.downloads.remove(downloadImpl);
                        DownloadManagerImpl.this.download_map.remove(downloadManager);
                        DownloadManagerImpl.this.pending_dls.remove(downloadManager);
                        downloadImpl.destroy();
                        list = DownloadManagerImpl.this.listeners;
                    }
                    Object var5_4 = null;
                    DownloadManagerImpl.this.listeners_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    DownloadManagerImpl.this.listeners_mon.exit();
                    throw throwable;
                }
                if (downloadImpl != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        ((DownloadManagerListener)list.get(i)).downloadRemoved(downloadImpl);
                    }
                }
            }

            public void destroyInitiated() {
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean bl, boolean bl2) {
            }
        });
        this.global_manager.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            public void downloadWillBeRemoved(org.gudy.azureus2.core3.download.DownloadManager downloadManager, boolean bl, boolean bl2) throws GlobalManagerDownloadRemovalVetoException {
                DownloadImpl downloadImpl = (DownloadImpl)DownloadManagerImpl.this.download_map.get(downloadManager);
                if (downloadImpl != null) {
                    try {
                        downloadImpl.isRemovable();
                    }
                    catch (DownloadRemovalVetoException downloadRemovalVetoException) {
                        throw new GlobalManagerDownloadRemovalVetoException(downloadRemovalVetoException.getMessage(), downloadRemovalVetoException.isSilent());
                    }
                }
            }
        });
    }

    public void addDownload(File file) {
        UIManagerImpl.fireEvent(null, 2, file);
    }

    public void addDownload(URL uRL) {
        this.addDownload(uRL, null, true, null);
    }

    public void addDownload(URL uRL, boolean bl) throws DownloadException {
        this.addDownload(uRL, null, bl, null);
    }

    public void addDownload(URL uRL, URL uRL2) {
        this.addDownload(uRL, uRL2, true, null);
    }

    public void addDownload(URL uRL, Map map) {
        this.addDownload(uRL, null, true, map);
    }

    public void addDownload(URL uRL, URL uRL2, boolean bl, Map map) {
        UIManagerImpl.fireEvent(null, 3, new Object[]{uRL, uRL2, new Boolean(bl), map});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloadManager(org.gudy.azureus2.core3.download.DownloadManager downloadManager) {
        List list = null;
        DownloadImpl downloadImpl = null;
        try {
            this.listeners_mon.enter();
            if (this.download_map.get(downloadManager) == null) {
                downloadImpl = (DownloadImpl)this.pending_dls.remove(downloadManager);
                if (downloadImpl == null) {
                    downloadImpl = new DownloadImpl(downloadManager);
                }
                this.downloads.add(downloadImpl);
                this.download_map.put(downloadManager, downloadImpl);
                list = this.listeners;
            }
            Object var5_4 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        if (downloadImpl != null) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    ((DownloadManagerListener)list.get(i)).downloadAdded(downloadImpl);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public Download addDownload(Torrent torrent) throws DownloadException {
        return this.addDownload(torrent, null, null);
    }

    public Download addDownload(Torrent torrent, File file, File file2) throws DownloadException {
        return this.addDownload(torrent, file, file2, this.getInitialState());
    }

    public Download addDownload(Torrent torrent, File file, File file2, int n) throws DownloadException {
        Object object;
        if (file == null) {
            object = null;
            if (COConfigurationManager.getBooleanParameter("Save Torrent Files")) {
                try {
                    object = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object == null || ((String)object).length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default torrent save directory must be configured");
            }
            file = new File((String)object + File.separator + torrent.getName() + ".torrent");
            try {
                torrent.writeToFile(file);
            }
            catch (TorrentException torrentException) {
                throw new DownloadException("DownloadManager::addDownload: failed to write torrent to '" + file.toString() + "'", torrentException);
            }
        }
        if (!file.exists()) {
            throw new DownloadException("DownloadManager::addDownload: torrent file does not exist - " + file.toString());
        }
        if (!file.isFile()) {
            throw new DownloadException("DownloadManager::addDownload: torrent filepath given is not a file - " + file.toString());
        }
        if (file2 == null) {
            object = COConfigurationManager.getStringParameter("Default save path");
            if (object == null || ((String)object).length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default data save directory must be configured");
            }
            file2 = new File((String)object);
            FileUtil.mkdirs(file2);
        }
        object = null;
        try {
            object = torrent.getHash();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = torrent.isComplete();
        org.gudy.azureus2.core3.download.DownloadManager downloadManager = this.global_manager.addDownloadManager(file.toString(), (byte[])object, file2.toString(), n, true, bl, null);
        if (downloadManager == null) {
            throw new DownloadException("DownloadManager::addDownload - failed, download may already in the process of being added");
        }
        this.addDownloadManager(downloadManager);
        return this.getDownload(downloadManager);
    }

    public Download addDownloadStopped(Torrent torrent, File file, File file2) throws DownloadException {
        return this.addDownload(torrent, file, file2, 70);
    }

    public Download addNonPersistentDownload(Torrent torrent, File file, File file2) throws DownloadException {
        byte[] byArray = null;
        try {
            byArray = torrent.getHash();
        }
        catch (Exception exception) {
            // empty catch block
        }
        org.gudy.azureus2.core3.download.DownloadManager downloadManager = this.global_manager.addDownloadManager(file.toString(), byArray, file2.toString(), this.getInitialState(), false);
        if (downloadManager == null) {
            throw new DownloadException("DownloadManager::addDownload - failed");
        }
        this.addDownloadManager(downloadManager);
        return this.getDownload(downloadManager);
    }

    protected int getInitialState() {
        boolean bl = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
        return bl ? 70 : 0;
    }

    protected DownloadImpl getDownload(org.gudy.azureus2.core3.download.DownloadManager downloadManager) throws DownloadException {
        DownloadImpl downloadImpl = (DownloadImpl)this.download_map.get(downloadManager);
        if (downloadImpl == null) {
            throw new DownloadException("DownloadManager::getDownload: download not found");
        }
        return downloadImpl;
    }

    public static DownloadImpl[] getDownloadStatic(org.gudy.azureus2.core3.download.DownloadManager[] downloadManagerArray) {
        ArrayList<DownloadImpl> arrayList = new ArrayList<DownloadImpl>(downloadManagerArray.length);
        for (int i = 0; i < downloadManagerArray.length; ++i) {
            try {
                arrayList.add(DownloadManagerImpl.getDownloadStatic(downloadManagerArray[i]));
                continue;
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new DownloadImpl[arrayList.size()]);
    }

    public static DownloadImpl getDownloadStatic(org.gudy.azureus2.core3.download.DownloadManager downloadManager) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(downloadManager);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public static Download getDownloadStatic(DiskManager diskManager) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(diskManager);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public Download getDownload(DiskManager diskManager) throws DownloadException {
        List list = this.global_manager.getDownloadManagers();
        for (int i = 0; i < list.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager downloadManager = (org.gudy.azureus2.core3.download.DownloadManager)list.get(i);
            if (downloadManager.getDiskManager() != diskManager) continue;
            return this.getDownload(downloadManager.getTorrent());
        }
        return null;
    }

    protected Download getDownload(TOTorrent tOTorrent) throws DownloadException {
        if (tOTorrent != null) {
            for (int i = 0; i < this.downloads.size(); ++i) {
                Download download = (Download)this.downloads.get(i);
                TorrentImpl torrentImpl = (TorrentImpl)download.getTorrent();
                if (torrentImpl == null || !torrentImpl.getTorrent().hasSameHashAs(tOTorrent)) continue;
                return download;
            }
        }
        throw new DownloadException("DownloadManager::getDownload: download not found");
    }

    public static Download getDownloadStatic(TOTorrent tOTorrent) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(tOTorrent);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public Download getDownload(Torrent torrent) {
        TorrentImpl torrentImpl = (TorrentImpl)torrent;
        try {
            return this.getDownload(torrentImpl.getTorrent());
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public Download getDownload(byte[] byArray) {
        List list = this.global_manager.getDownloadManagers();
        for (int i = 0; i < list.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager downloadManager = (org.gudy.azureus2.core3.download.DownloadManager)list.get(i);
            TOTorrent tOTorrent = downloadManager.getTorrent();
            if (tOTorrent == null) continue;
            try {
                if (!Arrays.equals(tOTorrent.getHash(), byArray)) continue;
                return this.getDownload(tOTorrent);
            }
            catch (DownloadException downloadException) {
                continue;
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Download[] getDownloads() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        List list = this.global_manager.getDownloadManagers();
        try {
            Object object;
            int n;
            this.listeners_mon.enter();
            for (n = 0; n < list.size(); ++n) {
                object = this.download_map.get(list.get(n));
                if (object == null) continue;
                linkedHashSet.add(object);
            }
            if (linkedHashSet.size() < this.downloads.size()) {
                for (n = 0; n < this.downloads.size(); ++n) {
                    object = (Download)this.downloads.get(n);
                    if (linkedHashSet.contains(object)) continue;
                    linkedHashSet.add(object);
                }
            }
            Object var6_6 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        Download[] downloadArray = new Download[linkedHashSet.size()];
        linkedHashSet.toArray(downloadArray);
        return downloadArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Download[] getDownloads(boolean bl) {
        if (bl) {
            return this.getDownloads();
        }
        try {
            this.listeners_mon.enter();
            Download[] downloadArray = new Download[this.downloads.size()];
            this.downloads.toArray(downloadArray);
            Download[] downloadArray2 = downloadArray;
            Object var5_4 = null;
            this.listeners_mon.exit();
            return downloadArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public void pauseDownloads() {
        this.global_manager.pauseDownloads();
    }

    public boolean canPauseDownloads() {
        return this.global_manager.canPauseDownloads();
    }

    public void resumeDownloads() {
        this.global_manager.resumeDownloads();
    }

    public boolean canResumeDownloads() {
        return this.global_manager.canResumeDownloads();
    }

    public void startAllDownloads() {
        this.global_manager.startAllDownloads();
    }

    public void stopAllDownloads() {
        this.global_manager.stopAllDownloads();
    }

    public DownloadManagerStats getStats() {
        return this.stats;
    }

    public boolean isSeedingOnly() {
        return this.global_manager.isSeedingOnly();
    }

    public void addListener(DownloadManagerListener downloadManagerListener) {
        this.addListener(downloadManagerListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadManagerListener downloadManagerListener, boolean bl) {
        ArrayList arrayList = null;
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadManagerListener> arrayList2 = new ArrayList<DownloadManagerListener>(this.listeners);
            arrayList2.add(downloadManagerListener);
            this.listeners = arrayList2;
            if (bl) {
                arrayList = new ArrayList(this.downloads);
                Collections.shuffle(arrayList);
            }
            Object var6_6 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    downloadManagerListener.downloadAdded((Download)arrayList.get(i));
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public void removeListener(DownloadManagerListener downloadManagerListener) {
        this.removeListener(downloadManagerListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadManagerListener downloadManagerListener, boolean bl) {
        ArrayList arrayList = null;
        try {
            this.listeners_mon.enter();
            ArrayList arrayList2 = new ArrayList(this.listeners);
            arrayList2.remove(downloadManagerListener);
            this.listeners = arrayList2;
            if (bl) {
                arrayList = new ArrayList(this.downloads);
            }
            Object var6_6 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    downloadManagerListener.downloadRemoved((Download)arrayList.get(i));
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialised(org.gudy.azureus2.core3.download.DownloadManager downloadManager) {
        DownloadImpl downloadImpl;
        try {
            this.listeners_mon.enter();
            downloadImpl = new DownloadImpl(downloadManager);
            this.pending_dls.put(downloadManager, downloadImpl);
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        Iterator iterator = this.dwba_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((DownloadWillBeAddedListener)iterator.next()).initialised(downloadImpl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadWillBeAddedListener(DownloadWillBeAddedListener downloadWillBeAddedListener) {
        try {
            this.listeners_mon.enter();
            this.dwba_listeners.add(downloadWillBeAddedListener);
            if (this.dwba_listeners.size() == 1) {
                this.global_manager.addDownloadManagerInitialisationAdapter(this);
            }
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadWillBeAddedListener(DownloadWillBeAddedListener downloadWillBeAddedListener) {
        try {
            this.listeners_mon.enter();
            this.dwba_listeners.remove(downloadWillBeAddedListener);
            if (this.dwba_listeners.size() == 0) {
                this.global_manager.removeDownloadManagerInitialisationAdapter(this);
            }
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalDownload(Download download) {
        List list = null;
        try {
            this.listeners_mon.enter();
            if (this.downloads.contains(download)) {
                Object var4_3 = null;
                this.listeners_mon.exit();
                return;
            }
            this.downloads.add(download);
            list = this.listeners;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        Object var4_4 = null;
        this.listeners_mon.exit();
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((DownloadManagerListener)list.get(i)).downloadAdded(download);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalDownload(Download download) {
        List list = null;
        try {
            this.listeners_mon.enter();
            if (!this.downloads.contains(download)) {
                Object var4_3 = null;
                this.listeners_mon.exit();
                return;
            }
            this.downloads.remove(download);
            list = this.listeners;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        Object var4_4 = null;
        this.listeners_mon.exit();
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((DownloadManagerListener)list.get(i)).downloadRemoved(download);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public DownloadEventNotifier getGlobalDownloadEventNotifier() {
        return this.global_dl_notifier;
    }

    public void setSaveLocationManager(SaveLocationManager saveLocationManager) {
        if (saveLocationManager == null) {
            saveLocationManager = this.getDefaultSaveLocationManager();
        }
        DownloadManagerMoveHandler.CURRENT_HANDLER = saveLocationManager;
    }

    public SaveLocationManager getSaveLocationManager() {
        return DownloadManagerMoveHandler.CURRENT_HANDLER;
    }

    public DefaultSaveLocationManager getDefaultSaveLocationManager() {
        return DownloadManagerDefaultPaths.DEFAULT_HANDLER;
    }

    static {
        class_mon = new AEMonitor("DownloadManager:class");
    }
}

