/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.logging;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class LoggerChannelImpl
implements LoggerChannel {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private Logger logger;
    private String name;
    private boolean timestamp;
    private boolean no_output;
    private List listeners = new ArrayList();
    private AEDiagnosticsLogger diagnostic_logger;

    protected LoggerChannelImpl(Logger logger, String string, boolean bl, boolean bl2) {
        this.logger = logger;
        this.name = string;
        this.timestamp = bl;
        this.no_output = bl2;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return org.gudy.azureus2.core3.logging.Logger.isEnabled();
    }

    public void setDiagnostic() {
        this.setDiagnostic(0L, true);
    }

    public void setDiagnostic(long l, boolean bl) {
        if (this.diagnostic_logger == null) {
            this.diagnostic_logger = AEDiagnostics.getLogger(FileUtil.convertOSSpecificChars(this.name, false));
            if (l > 0L) {
                this.diagnostic_logger.setMaxFileSize((int)l);
            }
            this.diagnostic_logger.enableTimeStamp(bl);
            this.addListener(new LoggerChannelListener(){

                public void messageLogged(int n, String string) {
                    LoggerChannelImpl.this.diagnostic_logger.log(string);
                }

                public void messageLogged(String string, Throwable throwable) {
                    LoggerChannelImpl.this.diagnostic_logger.log(string);
                    LoggerChannelImpl.this.diagnostic_logger.log(throwable);
                }
            });
        }
    }

    private int LogTypePluginToCore(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private void notifyListeners(int n, String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                LoggerChannelListener loggerChannelListener = (LoggerChannelListener)this.listeners.get(i);
                loggerChannelListener.messageLogged(n, string);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    private void notifyListeners(String string, Throwable throwable) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                LoggerChannelListener loggerChannelListener = (LoggerChannelListener)this.listeners.get(i);
                loggerChannelListener.messageLogged(string, throwable);
                continue;
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
        }
    }

    public void log(int n, String string) {
        this.notifyListeners(n, this.addTimeStamp(string));
        if (this.isEnabled() && !this.no_output) {
            string = "[" + this.name + "] " + string;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, this.LogTypePluginToCore(n), string));
        }
    }

    public void log(String string) {
        this.log(1, string);
    }

    public void log(Object[] objectArray, int n, String string) {
        String string2 = string;
        if (objectArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object == null) continue;
                if (i > 0) {
                    stringBuffer.append("; ");
                }
                if (object instanceof LogRelation) {
                    stringBuffer.append(((LogRelation)object).getRelationText());
                    continue;
                }
                stringBuffer.append("RelatedTo[").append(object.toString()).append("]");
            }
            string2 = string2 + "\t" + stringBuffer.toString() + "] " + string;
        }
        this.notifyListeners(n, this.addTimeStamp(string2));
        if (this.isEnabled() && !this.no_output) {
            string = "[" + this.name + "] " + string;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(objectArray, LOGID, this.LogTypePluginToCore(n), string));
        }
    }

    public void log(Object object, int n, String string) {
        this.log(new Object[]{object}, n, string);
    }

    public void log(Throwable throwable) {
        this.log("", throwable);
    }

    public void log(String string, Throwable throwable) {
        this.notifyListeners(string.equals("") ? "" : this.addTimeStamp(string), throwable);
        if (!this.no_output) {
            LogEvent logEvent = new LogEvent(LOGID, "[" + this.name + "] " + string, throwable);
            org.gudy.azureus2.core3.logging.Logger.log(logEvent);
        }
    }

    public void log(Object[] objectArray, String string, Throwable throwable) {
        this.notifyListeners(string.equals("") ? "" : this.addTimeStamp(string), throwable);
        if (this.isEnabled() && !this.no_output) {
            string = "[" + this.name + "] " + string;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(objectArray, LOGID, string, throwable));
        }
    }

    public void log(Object object, String string, Throwable throwable) {
        this.log(new Object[]{object}, string, throwable);
    }

    public void log(Object[] objectArray, String string) {
        this.log(objectArray, 1, string);
    }

    public void log(Object object, String string) {
        this.log(object, 1, string);
    }

    protected void logAlert(int n, String string, boolean bl) {
        int n2;
        for (n2 = 0; n2 < this.listeners.size(); ++n2) {
            try {
                ((LoggerChannelListener)this.listeners.get(n2)).messageLogged(n, this.addTimeStamp(string));
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (!this.no_output) {
            switch (n) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 1;
                    break;
                }
                default: {
                    n2 = 3;
                }
            }
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(bl, n2, string));
        }
    }

    public void logAlert(int n, String string) {
        this.logAlert(n, string, false);
    }

    public void logAlertRepeatable(int n, String string) {
        this.logAlert(n, string, true);
    }

    public void logAlert(String string, Throwable throwable) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(this.addTimeStamp(string), throwable);
                continue;
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
        }
        if (!this.no_output) {
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(false, string, throwable));
        }
    }

    public void logAlertRepeatable(String string, Throwable throwable) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(this.addTimeStamp(string), throwable);
                continue;
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
        }
        if (!this.no_output) {
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(true, string, throwable));
        }
    }

    public void addListener(LoggerChannelListener loggerChannelListener) {
        this.listeners.add(loggerChannelListener);
    }

    public void removeListener(LoggerChannelListener loggerChannelListener) {
        this.listeners.remove(loggerChannelListener);
    }

    protected String addTimeStamp(String string) {
        if (this.timestamp) {
            return this.getTimeStamp() + string;
        }
        return string;
    }

    protected String getTimeStamp() {
        Calendar calendar = GregorianCalendar.getInstance();
        String string = "[" + calendar.get(11) + ":" + LoggerChannelImpl.format(calendar.get(12)) + ":" + LoggerChannelImpl.format(calendar.get(13)) + "] ";
        return string;
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }
}

