/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import java.util.HashMap;
import org.gudy.azureus2.plugins.network.IncomingMessageQueue;
import org.gudy.azureus2.plugins.network.IncomingMessageQueueListener;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;

public class IncomingMessageQueueImpl
implements IncomingMessageQueue {
    private final com.aelitis.azureus.core.networkmanager.IncomingMessageQueue core_queue;
    private final HashMap registrations = new HashMap();

    protected IncomingMessageQueueImpl(com.aelitis.azureus.core.networkmanager.IncomingMessageQueue incomingMessageQueue) {
        this.core_queue = incomingMessageQueue;
    }

    public void registerListener(final IncomingMessageQueueListener incomingMessageQueueListener) {
        IncomingMessageQueue.MessageQueueListener messageQueueListener = new IncomingMessageQueue.MessageQueueListener(){

            public boolean messageReceived(Message message) {
                if (message instanceof MessageAdapter) {
                    return incomingMessageQueueListener.messageReceived(((MessageAdapter)message).getPluginMessage());
                }
                return incomingMessageQueueListener.messageReceived(new MessageAdapter(message));
            }

            public void protocolBytesReceived(int n) {
                incomingMessageQueueListener.bytesReceived(n);
            }

            public void dataBytesReceived(int n) {
                incomingMessageQueueListener.bytesReceived(n);
            }
        };
        this.registrations.put(incomingMessageQueueListener, messageQueueListener);
        this.core_queue.registerQueueListener(messageQueueListener);
    }

    public void deregisterListener(IncomingMessageQueueListener incomingMessageQueueListener) {
        IncomingMessageQueue.MessageQueueListener messageQueueListener = (IncomingMessageQueue.MessageQueueListener)this.registrations.remove(incomingMessageQueueListener);
        if (messageQueueListener != null) {
            this.core_queue.cancelQueueListener(messageQueueListener);
        }
    }

    public void notifyOfExternalReceive(org.gudy.azureus2.plugins.messaging.Message message) {
        if (message instanceof MessageAdapter) {
            this.core_queue.notifyOfExternallyReceivedMessage(((MessageAdapter)message).getCoreMessage());
            return;
        }
        this.core_queue.notifyOfExternallyReceivedMessage(new MessageAdapter(message));
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.core_queue.getPercentDoneOfCurrentMessage();
    }
}

