/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignNetworkConnection;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerForeignDelegate
implements PEPeerTransport {
    protected volatile int _lastPiece = -1;
    private PeerManagerImpl manager;
    private Peer foreign;
    private NetworkConnectionBase network_connection;
    private long create_time = SystemTime.getCurrentTime();
    private long last_data_received_time = -1L;
    private long last_data_message_received_time = -1L;
    private int reserved_piece = -1;
    private int consecutive_no_requests;
    private BitFlags bit_flags;
    private boolean priority_connection;
    private Map data;
    private HashMap peer_listeners;
    protected AEMonitor this_mon = new AEMonitor("PeerForeignDelegate");

    protected PeerForeignDelegate(PeerManagerImpl peerManagerImpl, Peer peer) {
        this.manager = peerManagerImpl;
        this.foreign = peer;
        PEPeerManager pEPeerManager = this.manager.getDelegate();
        this.network_connection = new PeerForeignNetworkConnection(this.foreign);
        this.network_connection.addRateLimiter(pEPeerManager.getUploadLimitedRateGroup(), true);
        this.network_connection.addRateLimiter(pEPeerManager.getDownloadLimitedRateGroup(), false);
    }

    public void start() {
        NetworkManager.getSingleton().startTransferProcessing(this.network_connection);
        NetworkManager.getSingleton().upgradeTransferProcessing(this.network_connection, this.manager.getPartitionID());
    }

    protected void stop() {
        NetworkManager.getSingleton().stopTransferProcessing(this.network_connection);
    }

    public void sendChoke() {
    }

    public void sendHave(int n) {
    }

    public void sendUnChoke() {
    }

    public InetAddress getAlternativeIPv6() {
        return null;
    }

    public boolean transferAvailable() {
        return this.foreign.isTransferAvailable();
    }

    public boolean isDownloadPossible() {
        return this.foreign.isDownloadPossible();
    }

    public void sendCancel(DiskManagerReadRequest diskManagerReadRequest) {
        this.foreign.cancelRequest(diskManagerReadRequest);
    }

    public DiskManagerReadRequest request(int n, int n2, int n3) {
        DiskManagerReadRequest diskManagerReadRequest = this.manager.getDelegate().getDiskManager().createReadRequest(n, n2, n3);
        if (this.foreign.addRequest(diskManagerReadRequest)) {
            return diskManagerReadRequest;
        }
        return null;
    }

    public int getRequestIndex(DiskManagerReadRequest diskManagerReadRequest) {
        return this.foreign.getRequests().indexOf(diskManagerReadRequest);
    }

    protected void dataReceived() {
        this.last_data_received_time = SystemTime.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(String string) {
        try {
            this.foreign.close(string, false, false);
            Object var3_2 = null;
            this.stop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stop();
            throw throwable;
        }
    }

    public List getExpiredRequests() {
        return this.foreign.getExpiredRequests();
    }

    public int getMaxNbRequests() {
        return this.foreign.getMaximumNumberOfRequests();
    }

    public int getNbRequests() {
        return this.foreign.getNumberOfRequests();
    }

    public int[] getPriorityOffsets() {
        return this.foreign.getPriorityOffsets();
    }

    public boolean requestAllocationStarts(int[] nArray) {
        return this.foreign.requestAllocationStarts(nArray);
    }

    public void requestAllocationComplete() {
        this.foreign.requestAllocationComplete();
    }

    public PEPeerControl getControl() {
        return (PEPeerControl)this.manager.getDelegate();
    }

    public void updatePeerExchange() {
    }

    public PeerItem getPeerItemIdentity() {
        return PeerItemFactory.createPeerItem(this.foreign.getIp(), this.foreign.getTCPListenPort(), (byte)3, (byte)0, this.foreign.getUDPListenPort(), (byte)1, 0);
    }

    public int getConnectionState() {
        int n = this.getPeerState();
        if (n == 10) {
            return 1;
        }
        if (n == 20) {
            return 2;
        }
        if (n == 30) {
            return 4;
        }
        return 4;
    }

    public void doKeepAliveCheck() {
    }

    public boolean doTimeoutChecks() {
        return false;
    }

    public void doPerformanceTuningCheck() {
    }

    public long getTimeSinceConnectionEstablished() {
        long l = SystemTime.getCurrentTime();
        if (l > this.create_time) {
            return l - this.create_time;
        }
        return 0L;
    }

    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == -1L) {
            return -1L;
        }
        long l = SystemTime.getCurrentTime();
        if (this.last_data_message_received_time < l) {
            this.last_data_message_received_time = l;
        }
        return l - this.last_data_message_received_time;
    }

    public long getTimeSinceGoodDataReceived() {
        if (this.last_data_received_time == -1L) {
            return -1L;
        }
        long l = SystemTime.getCurrentTime();
        long l2 = l - this.last_data_received_time;
        if (l2 < 0L) {
            this.last_data_received_time = l;
            l2 = 0L;
        }
        return l2;
    }

    public long getTimeSinceLastDataMessageSent() {
        return 0L;
    }

    public int getConsecutiveNoRequestCount() {
        return this.consecutive_no_requests;
    }

    public void setConsecutiveNoRequestCount(int n) {
        this.consecutive_no_requests = n;
    }

    public PEPeerManager getManager() {
        return this.manager.getDelegate();
    }

    public String getPeerSource() {
        return "Plugin";
    }

    public int getPeerState() {
        int n = this.foreign.getState();
        return n;
    }

    public byte[] getId() {
        return this.foreign.getId();
    }

    public String getIp() {
        return this.foreign.getIp();
    }

    public String getIPHostName() {
        return this.foreign.getIp();
    }

    public int getPort() {
        return this.foreign.getPort();
    }

    public int getTCPListenPort() {
        return this.foreign.getTCPListenPort();
    }

    public int getUDPListenPort() {
        return this.foreign.getUDPListenPort();
    }

    public int getUDPNonDataListenPort() {
        return this.foreign.getUDPNonDataListenPort();
    }

    public BitFlags getAvailable() {
        boolean[] blArray = this.foreign.getAvailable();
        if (this.bit_flags == null || this.bit_flags.flags != blArray) {
            this.bit_flags = new BitFlags(blArray);
        }
        return this.bit_flags;
    }

    public boolean hasReceivedBitField() {
        return true;
    }

    public boolean isPieceAvailable(int n) {
        return this.foreign.isPieceAvailable(n);
    }

    public void setSnubbed(boolean bl) {
        this.foreign.setSnubbed(bl);
    }

    public boolean isChokingMe() {
        return this.foreign.isChoked();
    }

    public boolean isChokedByMe() {
        return this.foreign.isChoking();
    }

    public boolean isInteresting() {
        return this.foreign.isInteresting();
    }

    public boolean isInterested() {
        return this.foreign.isInterested();
    }

    public boolean isSeed() {
        return this.foreign.isSeed();
    }

    public boolean isRelativeSeed() {
        return false;
    }

    public boolean isSnubbed() {
        return this.foreign.isSnubbed();
    }

    public long getSnubbedTime() {
        return this.foreign.getSnubbedTime();
    }

    public boolean isLANLocal() {
        return AddressUtils.isLANLocalAddress(this.foreign.getIp()) == 1;
    }

    public boolean sendRequestHint(int n, int n2, int n3, int n4) {
        return false;
    }

    public int[] getRequestHint() {
        return null;
    }

    public void clearRequestHint() {
    }

    public void sendBadPiece(int n) {
    }

    public boolean isTCP() {
        return true;
    }

    public PEPeerStats getStats() {
        return ((PeerStatsImpl)this.foreign.getStats()).getDelegate();
    }

    public boolean isIncoming() {
        return this.foreign.isIncoming();
    }

    public int getPercentDoneInThousandNotation() {
        return this.foreign.getPercentDoneInThousandNotation();
    }

    public long getBytesRemaining() {
        int n = 1000 - this.getPercentDoneInThousandNotation();
        if (n == 0) {
            return 0L;
        }
        try {
            Torrent torrent = this.manager.getDownload().getTorrent();
            if (torrent == null) {
                return Long.MAX_VALUE;
            }
            return torrent.getSize() * (long)n / 1000L;
        }
        catch (Throwable throwable) {
            return Long.MAX_VALUE;
        }
    }

    public String getClient() {
        return this.foreign.getClient();
    }

    public byte[] getHandshakeReservedBytes() {
        return this.foreign.getHandshakeReservedBytes();
    }

    public boolean isOptimisticUnchoke() {
        return this.foreign.isOptimisticUnchoke();
    }

    public void setOptimisticUnchoke(boolean bl) {
        this.foreign.setOptimisticUnchoke(bl);
    }

    public int getUniqueAnnounce() {
        return -1;
    }

    public int getUploadHint() {
        return 0;
    }

    public void setUniqueAnnounce(int n) {
    }

    public void setUploadHint(int n) {
    }

    public boolean isStalledPendingLoad() {
        return false;
    }

    public void addListener(final PEPeerListener pEPeerListener) {
        final PeerForeignDelegate peerForeignDelegate = this;
        PeerListener2 peerListener2 = new PeerListener2(){

            public void eventOccurred(PeerEvent peerEvent) {
                Object object = peerEvent.getData();
                switch (peerEvent.getType()) {
                    case 1: {
                        pEPeerListener.stateChanged(peerForeignDelegate, (Integer)object);
                        break;
                    }
                    case 2: {
                        Integer[] integerArray = (Integer[])object;
                        pEPeerListener.sentBadChunk(peerForeignDelegate, integerArray[0], integerArray[1]);
                        break;
                    }
                    case 3: {
                        pEPeerListener.addAvailability(peerForeignDelegate, new BitFlags((boolean[])object));
                        break;
                    }
                    case 4: {
                        pEPeerListener.removeAvailability(peerForeignDelegate, new BitFlags((boolean[])object));
                    }
                }
            }
        };
        this.foreign.addListener(peerListener2);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(pEPeerListener, peerListener2);
    }

    public void removeListener(PEPeerListener pEPeerListener) {
        Object v;
        if (this.peer_listeners != null && (v = this.peer_listeners.remove(pEPeerListener)) != null) {
            if (v instanceof PeerListener) {
                this.foreign.removeListener((PeerListener)v);
            } else {
                this.foreign.removeListener((PeerListener2)v);
            }
        }
    }

    public Connection getPluginConnection() {
        return this.foreign.getConnection();
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.foreign.getPercentDoneOfCurrentIncomingRequest();
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.foreign.getPercentDoneOfCurrentOutgoingRequest();
    }

    public boolean supportsMessaging() {
        return this.foreign.supportsMessaging();
    }

    public int getMessagingMode() {
        return 4;
    }

    public String getEncryption() {
        return "";
    }

    public com.aelitis.azureus.core.peermanager.messaging.Message[] getSupportedMessages() {
        Message[] messageArray = this.foreign.getSupportedMessages();
        com.aelitis.azureus.core.peermanager.messaging.Message[] messageArray2 = new com.aelitis.azureus.core.peermanager.messaging.Message[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            messageArray2[i] = new MessageAdapter(messageArray[i]);
        }
        return messageArray2;
    }

    public Object getData(String string) {
        return this.getUserData(string);
    }

    public void setData(String string, Object object) {
        this.setUserData(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object object) {
        block3: {
            try {
                this.this_mon.enter();
                if (this.data != null) break block3;
                Object var2_2 = null;
                Object var4_4 = null;
                this.this_mon.exit();
                return var2_2;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        Object v = this.data.get(object);
        Object var4_5 = null;
        this.this_mon.exit();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object object, Object object2) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (object2 == null) {
                if (this.data.containsKey(object)) {
                    this.data.remove(object);
                    if (this.data.size() == 0) {
                        this.data = null;
                    }
                }
            } else {
                this.data.put(object, object2);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PeerForeignDelegate) {
            return this.foreign.equals(((PeerForeignDelegate)object).foreign);
        }
        return false;
    }

    public int hashCode() {
        return this.foreign.hashCode();
    }

    public int getReservedPieceNumber() {
        return this.reserved_piece;
    }

    public void setReservedPieceNumber(int n) {
        this.reserved_piece = n;
    }

    public int[] getIncomingRequestedPieceNumbers() {
        return new int[0];
    }

    public int getIncomingRequestCount() {
        return 0;
    }

    public int getOutgoingRequestCount() {
        return this.foreign.getRequests().size();
    }

    public int[] getOutgoingRequestedPieceNumbers() {
        List list = this.foreign.getRequests();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = ((PeerReadRequest)list.get(i)).getPieceNumber();
        }
        return nArray;
    }

    public int getOutboundDataQueueSize() {
        return this.getOutgoingRequestCount() * 16384;
    }

    public int getLastPiece() {
        return this._lastPiece;
    }

    public void setLastPiece(int n) {
        this._lastPiece = n;
    }

    public void checkInterested() {
    }

    public boolean isAvailabilityAdded() {
        return false;
    }

    public void clearAvailabilityAdded() {
    }

    public PEPeerTransport reconnect(boolean bl, boolean bl2) {
        return null;
    }

    public boolean isSafeForReconnect() {
        return false;
    }

    public void setUploadRateLimitBytesPerSecond(int n) {
        this.network_connection.setUploadLimit(n);
    }

    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.network_connection.setDownloadLimit(n);
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.network_connection.getUploadLimit();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.network_connection.getDownloadLimit();
    }

    public void addRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.network_connection.addRateLimiter(limitedRateGroup, bl);
    }

    public void removeRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.network_connection.removeRateLimiter(limitedRateGroup, bl);
    }

    public void setHaveAggregationEnabled(boolean bl) {
    }

    public void setPriorityConnection(boolean bl) {
        this.priority_connection = bl;
    }

    public boolean isPriorityConnection() {
        return this.priority_connection;
    }

    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("delegate: ip=" + this.getIp() + ",tcp=" + this.getTCPListenPort() + ",udp=" + this.getUDPListenPort() + ",state=" + this.foreign.getState() + ",foreign=" + this.foreign);
    }

    public String getClientNameFromExtensionHandshake() {
        return null;
    }

    public String getClientNameFromPeerID() {
        return null;
    }
}

