/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionHelper;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportBase;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.peers.Peer;

public class PeerForeignNetworkConnection
extends NetworkConnectionHelper {
    private Peer peer;
    private OutgoingMessageQueue outgoing_message_queue = new omq();
    private IncomingMessageQueue incoming_message_queue = new imq();
    private TransportBase transport_base = new tp();

    protected PeerForeignNetworkConnection(Peer peer) {
        this.peer = peer;
    }

    public ConnectionEndpoint getEndpoint() {
        return new ConnectionEndpoint(new InetSocketAddress(this.peer.getIp(), this.peer.getPort()));
    }

    public void notifyOfException(Throwable throwable) {
        Debug.printStackTrace(throwable);
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.incoming_message_queue;
    }

    public TransportBase getTransportBase() {
        return this.transport_base;
    }

    public int getMssSize() {
        return NetworkManager.getMinMssSize();
    }

    public boolean isLANLocal() {
        return false;
    }

    public String getString() {
        String string = this.peer.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        string = string + " " + this.peer.getIp() + ":" + this.peer.getPort();
        return "peer=" + string + ",in=" + this.incoming_message_queue.getPercentDoneOfCurrentMessage() + ",out=" + this.outgoing_message_queue.getTotalSize();
    }

    protected class omq
    implements OutgoingMessageQueue {
        protected omq() {
        }

        public void setTransport(Transport transport) {
        }

        public int getMssSize() {
            return PeerForeignNetworkConnection.this.getMssSize();
        }

        public void setEncoder(MessageStreamEncoder messageStreamEncoder) {
        }

        public MessageStreamEncoder getEncoder() {
            throw new RuntimeException("Not imp");
        }

        public int getPercentDoneOfCurrentMessage() {
            return 0;
        }

        public void destroy() {
        }

        public void flush() {
        }

        public boolean isDestroyed() {
            return false;
        }

        public int getTotalSize() {
            return 0;
        }

        public boolean hasUrgentMessage() {
            return false;
        }

        public void addMessage(Message message, boolean bl) {
            throw new RuntimeException("Not imp");
        }

        public void removeMessagesOfType(Message[] messageArray, boolean bl) {
            throw new RuntimeException("Not imp");
        }

        public boolean removeMessage(Message message, boolean bl) {
            throw new RuntimeException("Not imp");
        }

        public int deliverToTransport(int n, boolean bl) throws IOException {
            throw new RuntimeException("Not imp");
        }

        public void doListenerNotifications() {
        }

        public void setTrace(boolean bl) {
        }

        public String getQueueTrace() {
            return "";
        }

        public void registerQueueListener(OutgoingMessageQueue.MessageQueueListener messageQueueListener) {
        }

        public void cancelQueueListener(OutgoingMessageQueue.MessageQueueListener messageQueueListener) {
        }

        public void notifyOfExternallySentMessage(Message message) {
        }
    }

    protected class imq
    implements IncomingMessageQueue {
        protected imq() {
        }

        public void setDecoder(MessageStreamDecoder messageStreamDecoder) {
        }

        public MessageStreamDecoder getDecoder() {
            throw new RuntimeException("Not imp");
        }

        public int getPercentDoneOfCurrentMessage() {
            return 0;
        }

        public int receiveFromTransport(int n) throws IOException {
            return PeerForeignNetworkConnection.this.peer.readBytes(n);
        }

        public void notifyOfExternallyReceivedMessage(Message message) {
        }

        public void resumeQueueProcessing() {
        }

        public void registerQueueListener(IncomingMessageQueue.MessageQueueListener messageQueueListener) {
        }

        public void cancelQueueListener(IncomingMessageQueue.MessageQueueListener messageQueueListener) {
        }

        public void destroy() {
        }
    }

    protected class tp
    implements TransportBase {
        private long last_ready_for_read = SystemTime.getSteppedMonotonousTime();

        protected tp() {
        }

        public boolean isReadyForWrite(EventWaiter eventWaiter) {
            return false;
        }

        public long isReadyForRead(EventWaiter eventWaiter) {
            long l = SystemTime.getSteppedMonotonousTime();
            if (PeerForeignNetworkConnection.this.peer.isTransferAvailable()) {
                this.last_ready_for_read = l;
                return 0L;
            }
            long l2 = l - this.last_ready_for_read + 1L;
            return l2;
        }

        public boolean isTCP() {
            return false;
        }

        public String getDescription() {
            return "Peer transport delegate";
        }
    }
}

