/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerImpl
extends LogRelation
implements Peer {
    protected PeerManagerImpl manager;
    protected PEPeer delegate;
    protected AEMonitor this_mon = new AEMonitor("Peer");
    private HashMap peer_listeners;

    protected PeerImpl(PEPeer pEPeer) {
        this.delegate = pEPeer;
        this.manager = PeerManagerImpl.getPeerManager(this.delegate.getManager());
    }

    public PeerManager getManager() {
        return this.manager;
    }

    protected PEPeer getDelegate() {
        return this.delegate;
    }

    public Connection getConnection() {
        return this.delegate.getPluginConnection();
    }

    public boolean supportsMessaging() {
        return this.delegate.supportsMessaging();
    }

    public Message[] getSupportedMessages() {
        com.aelitis.azureus.core.peermanager.messaging.Message[] messageArray = this.delegate.getSupportedMessages();
        Message[] messageArray2 = new Message[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            messageArray2[i] = new MessageAdapter(messageArray[i]);
        }
        return messageArray2;
    }

    public int getState() {
        int n = this.delegate.getPeerState();
        switch (n) {
            case 10: {
                return 10;
            }
            case 50: {
                return 50;
            }
            case 20: {
                return 20;
            }
            case 30: {
                return 30;
            }
        }
        return -1;
    }

    public byte[] getId() {
        byte[] byArray = this.delegate.getId();
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public String getIp() {
        return this.delegate.getIp();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public int getTCPListenPort() {
        return this.delegate.getTCPListenPort();
    }

    public int getUDPListenPort() {
        return this.delegate.getUDPListenPort();
    }

    public int getUDPNonDataListenPort() {
        return this.delegate.getUDPNonDataListenPort();
    }

    public final boolean[] getAvailable() {
        return this.delegate.getAvailable().flags;
    }

    public boolean isPieceAvailable(int n) {
        return this.delegate.isPieceAvailable(n);
    }

    public boolean isTransferAvailable() {
        return this.delegate.transferAvailable();
    }

    public boolean isDownloadPossible() {
        return this.delegate.isDownloadPossible();
    }

    public boolean isChoked() {
        return this.delegate.isChokingMe();
    }

    public boolean isChoking() {
        return this.delegate.isChokedByMe();
    }

    public boolean isInterested() {
        return this.delegate.isInteresting();
    }

    public boolean isInteresting() {
        return this.delegate.isInterested();
    }

    public boolean isSeed() {
        return this.delegate.isSeed();
    }

    public boolean isSnubbed() {
        return this.delegate.isSnubbed();
    }

    public long getSnubbedTime() {
        return this.delegate.getSnubbedTime();
    }

    public void setSnubbed(boolean bl) {
        this.delegate.setSnubbed(bl);
    }

    public PeerStats getStats() {
        return new PeerStatsImpl(this.manager, this, this.delegate.getStats());
    }

    public boolean isIncoming() {
        return this.delegate.isIncoming();
    }

    public int getPercentDone() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    public int getPercentDoneInThousandNotation() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    public String getClient() {
        return this.delegate.getClient();
    }

    public boolean isOptimisticUnchoke() {
        return this.delegate.isOptimisticUnchoke();
    }

    public void setOptimisticUnchoke(boolean bl) {
        this.delegate.setOptimisticUnchoke(bl);
    }

    public void initialize() {
        throw new RuntimeException("not supported");
    }

    public List getExpiredRequests() {
        throw new RuntimeException("not supported");
    }

    public List getRequests() {
        throw new RuntimeException("not supported");
    }

    public int getNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    public int getMaximumNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    public int[] getPriorityOffsets() {
        throw new RuntimeException("not supported");
    }

    public boolean requestAllocationStarts(int[] nArray) {
        throw new RuntimeException("not supported");
    }

    public void requestAllocationComplete() {
        throw new RuntimeException("not supported");
    }

    public void cancelRequest(PeerReadRequest peerReadRequest) {
        throw new RuntimeException("not supported");
    }

    public boolean addRequest(PeerReadRequest peerReadRequest) {
        throw new RuntimeException("not supported");
    }

    public void close(String string, boolean bl, boolean bl2) {
        this.manager.removePeer(this, string);
    }

    public int readBytes(int n) {
        throw new RuntimeException("not supported");
    }

    public int writeBytes(int n) {
        throw new RuntimeException("not supported");
    }

    protected void closed() {
        if (this.delegate instanceof PeerForeignDelegate) {
            ((PeerForeignDelegate)this.delegate).stop();
        }
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.delegate.getPercentDoneOfCurrentIncomingRequest();
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.delegate.getPercentDoneOfCurrentOutgoingRequest();
    }

    public void addListener(final PeerListener peerListener) {
        PEPeerListener pEPeerListener = new PEPeerListener(){

            public void stateChanged(PEPeer pEPeer, int n) {
                try {
                    peerListener.stateChanged(n);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }

            public void sentBadChunk(PEPeer pEPeer, int n, int n2) {
                try {
                    peerListener.sentBadChunk(n, n2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }

            public void addAvailability(PEPeer pEPeer, BitFlags bitFlags) {
            }

            public void removeAvailability(PEPeer pEPeer, BitFlags bitFlags) {
            }
        };
        this.delegate.addListener(pEPeerListener);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(peerListener, pEPeerListener);
    }

    public void removeListener(PeerListener peerListener) {
        PEPeerListener pEPeerListener;
        if (this.peer_listeners != null && (pEPeerListener = (PEPeerListener)this.peer_listeners.remove(peerListener)) != null) {
            this.delegate.removeListener(pEPeerListener);
        }
    }

    public void addListener(final PeerListener2 peerListener2) {
        PEPeerListener pEPeerListener = new PEPeerListener(){

            public void stateChanged(PEPeer pEPeer, int n) {
                this.fireEvent(1, new Integer(n));
            }

            public void sentBadChunk(PEPeer pEPeer, int n, int n2) {
                this.fireEvent(2, new Integer[]{new Integer(n), new Integer(n2)});
            }

            public void addAvailability(PEPeer pEPeer, BitFlags bitFlags) {
                this.fireEvent(3, bitFlags.flags);
            }

            public void removeAvailability(PEPeer pEPeer, BitFlags bitFlags) {
                this.fireEvent(4, bitFlags.flags);
            }

            protected void fireEvent(final int n, final Object object) {
                try {
                    peerListener2.eventOccurred(new PeerEvent(){

                        public int getType() {
                            return n;
                        }

                        public Object getData() {
                            return object;
                        }
                    });
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        };
        this.delegate.addListener(pEPeerListener);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(peerListener2, pEPeerListener);
    }

    public void removeListener(PeerListener2 peerListener2) {
        PEPeerListener pEPeerListener;
        if (this.peer_listeners != null && (pEPeerListener = (PEPeerListener)this.peer_listeners.remove(peerListener2)) != null) {
            this.delegate.removeListener(pEPeerListener);
        }
    }

    public boolean isPriorityConnection() {
        return this.delegate.isPriorityConnection();
    }

    public void setPriorityConnection(boolean bl) {
        this.delegate.setPriorityConnection(bl);
    }

    public void setUserData(Object object, Object object2) {
        this.delegate.setUserData(object, object2);
    }

    public Object getUserData(Object object) {
        return this.delegate.getUserData(object);
    }

    public boolean equals(Object object) {
        if (object instanceof PeerImpl) {
            return this.delegate == ((PeerImpl)object).delegate;
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PEPeer getPEPeer() {
        return this.delegate;
    }

    public String getRelationText() {
        return this.propogatedRelationText(this.delegate);
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.delegate};
    }

    public byte[] getHandshakeReservedBytes() {
        return this.delegate.getHandshakeReservedBytes();
    }
}

