/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;

public class PeerStatsImpl
implements PeerStats {
    private PeerManagerImpl peer_manager;
    private PEPeerManager manager;
    private PEPeerStats delegate;
    private Peer owner;

    public PeerStatsImpl(PeerManagerImpl peerManagerImpl, Peer peer, PEPeerStats pEPeerStats) {
        this.peer_manager = peerManagerImpl;
        this.manager = this.peer_manager.getDelegate();
        this.delegate = pEPeerStats;
        this.owner = peer;
    }

    public PEPeerStats getDelegate() {
        return this.delegate;
    }

    public int getDownloadAverage() {
        return (int)this.delegate.getDataReceiveRate();
    }

    public int getReception() {
        return (int)this.delegate.getSmoothDataReceiveRate();
    }

    public int getUploadAverage() {
        return (int)this.delegate.getDataSendRate();
    }

    public int getTotalAverage() {
        return (int)this.delegate.getEstimatedDownloadRateOfPeer();
    }

    public long getTotalDiscarded() {
        return this.delegate.getTotalBytesDiscarded();
    }

    public long getTotalSent() {
        return this.delegate.getTotalDataBytesSent();
    }

    public long getTotalReceived() {
        return this.delegate.getTotalDataBytesReceived();
    }

    public int getStatisticSentAverage() {
        return (int)this.delegate.getEstimatedUploadRateOfPeer();
    }

    public void received(int n) {
        this.delegate.dataBytesReceived(n);
        this.manager.dataBytesReceived(this.delegate.getPeer(), n);
    }

    public void discarded(int n) {
        this.delegate.bytesDiscarded(n);
        this.manager.discarded(this.delegate.getPeer(), n);
    }

    public long getTimeSinceConnectionEstablished() {
        return this.peer_manager.getTimeSinceConnectionEstablished(this.owner);
    }

    public int getDownloadRateLimit() {
        return this.delegate.getDownloadRateLimitBytesPerSecond();
    }

    public void setDownloadRateLimit(int n) {
        this.delegate.setDownloadRateLimitBytesPerSecond(n);
    }
}

