/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareItemImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirContentsImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceFileImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;

public abstract class ShareResourceFileOrDirImpl
extends ShareResourceImpl {
    protected File file;
    protected ShareItemImpl item;

    protected static ShareResourceImpl getResourceSupport(ShareManagerImpl shareManagerImpl, File file) throws ShareException {
        try {
            return shareManagerImpl.getResource(file.getCanonicalFile());
        }
        catch (IOException iOException) {
            throw new ShareException("getCanonicalFile fails", iOException);
        }
    }

    protected ShareResourceFileOrDirImpl(ShareManagerImpl shareManagerImpl, ShareResourceDirContentsImpl shareResourceDirContentsImpl, int n, File file) throws ShareException {
        super(shareManagerImpl, n);
        this.file = file;
        if (this.getType() == 1) {
            if (!this.file.exists()) {
                throw new ShareException("File '".concat(this.file.getName()).concat("' not found"));
            }
            if (!this.file.isFile()) {
                throw new ShareException("Not a file");
            }
        } else {
            if (!this.file.exists()) {
                throw new ShareException("Dir '".concat(this.file.getName()).concat("' not found"));
            }
            if (this.file.isFile()) {
                throw new ShareException("Not a directory");
            }
        }
        try {
            this.file = this.file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new ShareException("ShareResourceFile: failed to get canonical name", iOException);
        }
        if (shareResourceDirContentsImpl != null) {
            this.setParent(shareResourceDirContentsImpl);
            this.inheritAttributes(shareResourceDirContentsImpl);
        }
        this.createTorrent();
    }

    protected ShareResourceFileOrDirImpl(ShareManagerImpl shareManagerImpl, int n, File file, Map map) throws ShareException {
        super(shareManagerImpl, n, map);
        this.file = file;
        this.item = ShareItemImpl.deserialiseItem(this, map);
    }

    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        for (int i = 0; i < this.deletion_listeners.size(); ++i) {
            ((ShareResourceWillBeDeletedListener)this.deletion_listeners.get(i)).resourceWillBeDeleted(this);
        }
        return true;
    }

    protected abstract byte[] getFingerPrint() throws ShareException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTorrent() throws ShareException {
        try {
            Object object;
            Object object2;
            TOTorrent tOTorrent;
            this.manager.reportCurrentTask((this.item == null ? "Creating" : "Re-creating").concat(" torrent for '").concat(this.file.toString()).concat("'"));
            URL[] uRLArray = this.manager.getAnnounceURLs();
            TOTorrentCreator tOTorrentCreator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(this.file, uRLArray[0], this.manager.getAddHashes());
            tOTorrentCreator.addListener(this.manager);
            try {
                this.manager.setTorrentCreator(tOTorrentCreator);
                tOTorrent = tOTorrentCreator.create();
                Object var5_6 = null;
                this.manager.setTorrentCreator(null);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.manager.setTorrentCreator(null);
                throw throwable;
            }
            LocaleTorrentUtil.setDefaultTorrentEncoding(tOTorrent);
            for (int i = 1; i < uRLArray.length; ++i) {
                TorrentUtils.announceGroupsInsertLast(tOTorrent, new URL[]{uRLArray[i]});
            }
            String string = COConfigurationManager.getStringParameter("Sharing Torrent Comment").trim();
            boolean bl = COConfigurationManager.getBooleanParameter("Sharing Torrent Private");
            boolean bl2 = COConfigurationManager.getBooleanParameter("Sharing Permit DHT");
            TorrentAttribute torrentAttribute = TorrentManagerImpl.getSingleton().getAttribute("ShareProperties");
            String string2 = this.getAttribute(torrentAttribute);
            if (string2 != null) {
                object2 = new StringTokenizer(string2, ";");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    int n = ((String)object).indexOf(61);
                    if (n == -1) {
                        Debug.out("ShareProperty invalid: " + string2);
                        continue;
                    }
                    String string3 = ((String)object).substring(0, n).trim().toLowerCase();
                    String string4 = ((String)object).substring(n + 1).trim().toLowerCase();
                    boolean bl3 = string4.equals("true");
                    if (string3.equals("private")) {
                        bl = bl3;
                        continue;
                    }
                    if (string3.equals("dht_backup")) {
                        bl2 = bl3;
                        continue;
                    }
                    if (string3.equals("comment")) {
                        string = string4;
                        continue;
                    }
                    Debug.out("ShareProperty invalid: " + string2);
                    break;
                }
            }
            if (string.length() > 0) {
                tOTorrent.setComment(string);
            }
            TorrentUtils.setDHTBackupEnabled(tOTorrent, bl2);
            TorrentUtils.setPrivate(tOTorrent, bl);
            if (TorrentUtils.isDecentralised(tOTorrent)) {
                TorrentUtils.setDecentralised(tOTorrent);
            }
            object2 = DownloadManagerStateFactory.getDownloadState(tOTorrent);
            TorrentUtils.setResumeDataCompletelyValid((DownloadManagerState)object2);
            object2.save();
            if (this.item == null) {
                object = this.getFingerPrint();
                this.item = new ShareItemImpl((ShareResourceImpl)this, (byte[])object, new TorrentImpl(tOTorrent));
            } else {
                this.item.setTorrent(new TorrentImpl(tOTorrent));
                this.item.writeTorrent();
            }
        }
        catch (TOTorrentException tOTorrentException) {
            if (tOTorrentException.getReason() == 9) {
                throw new ShareException("ShareResource: Operation cancelled", tOTorrentException);
            }
            throw new ShareException("ShareResource: Torrent create failed", tOTorrentException);
        }
        catch (Throwable throwable) {
            throw new ShareException("ShareResource: Torrent create failed", throwable);
        }
    }

    protected void checkConsistency() throws ShareException {
        try {
            if (Arrays.equals(this.getFingerPrint(), this.item.getFingerPrint())) {
                if (!this.manager.torrentExists(this.item)) {
                    this.createTorrent();
                }
            } else {
                this.manager.addFileOrDir(null, this.file, this.getType());
            }
        }
        catch (Throwable throwable) {
            this.manager.delete(this, true);
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl shareManagerImpl, Map map, int n) throws ShareException {
        try {
            File file = new File(new String((byte[])map.get("file"), "UTF8"));
            if (n == 1) {
                return new ShareResourceFileImpl(shareManagerImpl, file, map);
            }
            return new ShareResourceDirImpl(shareManagerImpl, file, map);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ShareException("internal error", unsupportedEncodingException);
        }
    }

    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        try {
            map.put("file", this.file.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
        }
        this.item.serialiseItem(map);
    }

    protected void deleteInternal() {
        this.item.delete();
    }

    public String getName() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }

    public ShareItem getItem() {
        return this.item;
    }
}

