/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.util.ArrayList;
import java.util.Arrays;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeEvent;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.torrent.BaseTorrentAttributeImpl;

public class TorrentAttributeCategoryImpl
extends BaseTorrentAttributeImpl {
    protected TorrentAttributeCategoryImpl() {
        CategoryManager.addCategoryManagerListener(new CategoryManagerListener(){

            public void categoryAdded(final Category category) {
                TorrentAttributeEvent torrentAttributeEvent = new TorrentAttributeEvent(){

                    public int getType() {
                        return 1;
                    }

                    public TorrentAttribute getAttribute() {
                        return TorrentAttributeCategoryImpl.this;
                    }

                    public Object getData() {
                        return category.getName();
                    }
                };
                TorrentAttributeCategoryImpl.this.notifyListeners(torrentAttributeEvent);
            }

            public void categoryRemoved(final Category category) {
                TorrentAttributeEvent torrentAttributeEvent = new TorrentAttributeEvent(){

                    public int getType() {
                        return 2;
                    }

                    public TorrentAttribute getAttribute() {
                        return TorrentAttributeCategoryImpl.this;
                    }

                    public Object getData() {
                        return category.getName();
                    }
                };
                TorrentAttributeCategoryImpl.this.notifyListeners(torrentAttributeEvent);
            }
        });
    }

    public String getName() {
        return "Category";
    }

    public String[] getDefinedValues() {
        Category[] categoryArray = CategoryManager.getCategories();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < categoryArray.length; ++i) {
            Category category = categoryArray[i];
            if (category.getType() != 0) continue;
            arrayList.add(category.getName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        Arrays.sort(stringArray, StaticUtilities.getFormatters().getAlphanumericComparator(true));
        return stringArray;
    }

    public void addDefinedValue(String string) {
        CategoryManager.createCategory(string);
    }

    public void removeDefinedValue(String string) {
        Category category = CategoryManager.getCategory(string);
        if (category != null) {
            CategoryManager.removeCategory(category);
        }
    }
}

