/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerPeer;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerPeerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentRequestImpl;

public class TrackerTorrentImpl
implements TrackerTorrent,
TRHostTorrentListener,
TRHostTorrentWillBeRemovedListener {
    protected TRHostTorrent host_torrent;
    protected List listeners_cow = new ArrayList();
    protected List removal_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerTorrent");

    public TrackerTorrentImpl(TRHostTorrent tRHostTorrent) {
        this.host_torrent = tRHostTorrent;
    }

    public TRHostTorrent getHostTorrent() {
        return this.host_torrent;
    }

    public void start() throws TrackerException {
        try {
            this.host_torrent.start();
        }
        catch (Throwable throwable) {
            throw new TrackerException("Start failed", throwable);
        }
    }

    public void stop() throws TrackerException {
        try {
            this.host_torrent.stop();
        }
        catch (Throwable throwable) {
            throw new TrackerException("Stop failed", throwable);
        }
    }

    public void remove() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.remove();
        }
        catch (TRHostTorrentRemovalVetoException tRHostTorrentRemovalVetoException) {
            throw new TrackerTorrentRemovalVetoException(tRHostTorrentRemovalVetoException.getMessage());
        }
    }

    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.canBeRemoved();
        }
        catch (TRHostTorrentRemovalVetoException tRHostTorrentRemovalVetoException) {
            throw new TrackerTorrentRemovalVetoException(tRHostTorrentRemovalVetoException.getMessage());
        }
        return true;
    }

    public Torrent getTorrent() {
        return new TorrentImpl(this.host_torrent.getTorrent());
    }

    public TrackerPeer[] getPeers() {
        TRHostPeer[] tRHostPeerArray = this.host_torrent.getPeers();
        TrackerPeer[] trackerPeerArray = new TrackerPeer[tRHostPeerArray.length];
        for (int i = 0; i < tRHostPeerArray.length; ++i) {
            trackerPeerArray[i] = new TrackerPeerImpl(tRHostPeerArray[i]);
        }
        return trackerPeerArray;
    }

    public int getStatus() {
        int n = this.host_torrent.getStatus();
        switch (n) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new RuntimeException("TrackerTorrent: status invalid");
    }

    public long getTotalUploaded() {
        return this.host_torrent.getTotalUploaded();
    }

    public long getTotalDownloaded() {
        return this.host_torrent.getTotalDownloaded();
    }

    public long getAverageUploaded() {
        return this.host_torrent.getAverageUploaded();
    }

    public long getAverageDownloaded() {
        return this.host_torrent.getAverageDownloaded();
    }

    public long getTotalLeft() {
        return this.host_torrent.getTotalLeft();
    }

    public long getCompletedCount() {
        return this.host_torrent.getCompletedCount();
    }

    public long getTotalBytesIn() {
        return this.host_torrent.getTotalBytesIn();
    }

    public long getAverageBytesIn() {
        return this.host_torrent.getAverageBytesIn();
    }

    public long getTotalBytesOut() {
        return this.host_torrent.getTotalBytesOut();
    }

    public long getAverageBytesOut() {
        return this.host_torrent.getAverageBytesOut();
    }

    public long getAverageScrapeCount() {
        return this.host_torrent.getAverageScrapeCount();
    }

    public long getScrapeCount() {
        return this.host_torrent.getScrapeCount();
    }

    public long getAverageAnnounceCount() {
        return this.host_torrent.getAverageAnnounceCount();
    }

    public long getAnnounceCount() {
        return this.host_torrent.getAnnounceCount();
    }

    public int getSeedCount() {
        return this.host_torrent.getSeedCount();
    }

    public int getLeecherCount() {
        return this.host_torrent.getLeecherCount();
    }

    public int getBadNATCount() {
        return this.host_torrent.getBadNATCount();
    }

    public void disableReplyCaching() {
        this.host_torrent.disableReplyCaching();
    }

    public boolean isPassive() {
        return this.host_torrent.isPassive();
    }

    public long getDateAdded() {
        return this.host_torrent.getDateAdded();
    }

    public void preProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TrackerTorrentListener)list.get(i)).preProcess(new TrackerTorrentRequestImpl(tRHostTorrentRequest));
                continue;
            }
            catch (TrackerException trackerException) {
                throw new TRHostException(trackerException.getMessage(), trackerException);
            }
            catch (Throwable throwable) {
                throw new TRHostException("Pre-process fails", throwable);
            }
        }
    }

    public void postProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TrackerTorrentListener)list.get(i)).postProcess(new TrackerTorrentRequestImpl(tRHostTorrentRequest));
                continue;
            }
            catch (TrackerException trackerException) {
                throw new TRHostException(trackerException.getMessage(), trackerException);
            }
            catch (Throwable throwable) {
                throw new TRHostException("Post-process fails", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TrackerTorrentListener trackerTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList<TrackerTorrentListener> arrayList = new ArrayList<TrackerTorrentListener>(this.listeners_cow);
            arrayList.add(trackerTorrentListener);
            if (arrayList.size() == 1) {
                this.host_torrent.addListener(this);
            }
            this.listeners_cow = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TrackerTorrentListener trackerTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners_cow);
            arrayList.remove(trackerTorrentListener);
            if (arrayList.size() == 0) {
                this.host_torrent.removeListener(this);
            }
            this.listeners_cow = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void torrentWillBeRemoved(TRHostTorrent tRHostTorrent) throws TRHostTorrentRemovalVetoException {
        for (int i = 0; i < this.removal_listeners.size(); ++i) {
            try {
                ((TrackerTorrentWillBeRemovedListener)this.removal_listeners.get(i)).torrentWillBeRemoved(this);
                continue;
            }
            catch (TrackerTorrentRemovalVetoException trackerTorrentRemovalVetoException) {
                throw new TRHostTorrentRemovalVetoException(trackerTorrentRemovalVetoException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovalListener(TrackerTorrentWillBeRemovedListener trackerTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(trackerTorrentWillBeRemovedListener);
            if (this.removal_listeners.size() == 1) {
                this.host_torrent.addRemovalListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener trackerTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(trackerTorrentWillBeRemovedListener);
            if (this.removal_listeners.size() == 0) {
                this.host_torrent.removeRemovalListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TrackerTorrentImpl) {
            return this.host_torrent == ((TrackerTorrentImpl)object).host_torrent;
        }
        return false;
    }

    public int hashCode() {
        return this.host_torrent.hashCode();
    }
}

