/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWCHelper;

public class TrackerWebContextImpl
extends TrackerWCHelper
implements TRTrackerServerListener2,
TRTrackerServerAuthenticationListener {
    protected TRTrackerServer server;
    protected List auth_listeners = new ArrayList();

    public TrackerWebContextImpl(TrackerImpl trackerImpl, String string, int n, int n2, InetAddress inetAddress) throws TrackerException {
        this.setTracker(trackerImpl);
        try {
            this.server = n2 == 1 ? TRTrackerServerFactory.create(string, 1, n, inetAddress, false, false) : TRTrackerServerFactory.createSSL(string, 1, n, inetAddress, false, false);
            this.server.addListener2(this);
        }
        catch (TRTrackerServerException tRTrackerServerException) {
            throw new TrackerException("TRTrackerServerFactory failed", tRTrackerServerException);
        }
    }

    public String getName() {
        return this.server.getName();
    }

    public void setEnableKeepAlive(boolean bl) {
        this.server.setEnableKeepAlive(bl);
    }

    public URL[] getURLs() {
        try {
            URL uRL = new URL((this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + "/");
            if (uRL.getPort() != this.server.getPort()) {
                Debug.out("Invalid URL '" + uRL + "' - check tracker configuration");
                uRL = new URL("http://i.am.invalid:" + this.server.getPort() + "/");
            }
            return new URL[]{uRL};
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
            return null;
        }
    }

    public boolean authenticate(URL uRL, String string, String string2) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                boolean bl = ((TrackerAuthenticationListener)this.auth_listeners.get(i)).authenticate(uRL, string, string2);
                if (!bl) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return false;
    }

    public byte[] authenticate(URL uRL, String string) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] byArray = ((TrackerAuthenticationListener)this.auth_listeners.get(i)).authenticate(uRL, string);
                if (byArray == null) continue;
                return byArray;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(trackerAuthenticationListener);
            if (this.auth_listeners.size() == 1) {
                this.server.addAuthenticationListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(trackerAuthenticationListener);
            if (this.auth_listeners.size() == 0) {
                this.server.removeAuthenticationListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void destroy() {
        super.destroy();
        this.auth_listeners.clear();
        this.server.removeAuthenticationListener(this);
        this.server.close();
    }
}

