/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.IUIIntializer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIInstanceFactory;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerEvent;
import org.gudy.azureus2.plugins.ui.UIManagerEventListener;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.UIMessage;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.model.PluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.PluginViewModel;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerEventAdapter;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginConfigModelImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginViewModelImpl;

public class UIManagerImpl
implements UIManager {
    protected static AEMonitor class_mon = new AEMonitor("UIManager:class");
    protected static boolean initialisation_complete;
    protected static CopyOnWriteList ui_listeners;
    protected static CopyOnWriteList ui_event_listeners;
    protected static List<UIInstanceFactory> ui_factories;
    protected static List<UIManagerEventAdapter> ui_event_history;
    protected static List<BasicPluginConfigModel> configModels;
    protected PluginInterface pi;
    protected PluginConfig plugin_config;
    protected String key_prefix;

    public UIManagerImpl(PluginInterface pluginInterface) {
        this.pi = pluginInterface;
        this.plugin_config = this.pi.getPluginconfig();
        this.key_prefix = this.plugin_config.getPluginConfigKeyPrefix();
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    public BasicPluginViewModel getBasicPluginViewModel(String string) {
        return this.createBasicPluginViewModel(string);
    }

    public PluginView createPluginView(PluginViewModel pluginViewModel) {
        try {
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public BasicPluginViewModel createBasicPluginViewModel(String string) {
        BasicPluginViewModelImpl basicPluginViewModelImpl = new BasicPluginViewModelImpl(this, string);
        UIManagerImpl.fireEvent(this.pi, 4, basicPluginViewModelImpl);
        return basicPluginViewModelImpl;
    }

    public void destroy(BasicPluginViewModel basicPluginViewModel) {
        UIManagerImpl.fireEvent(this.pi, 7, basicPluginViewModel);
    }

    public BasicPluginConfigModel createBasicPluginConfigModel(String string) {
        return this.createBasicPluginConfigModel("plugins", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicPluginConfigModel createBasicPluginConfigModel(String string, String string2) {
        BasicPluginConfigModelImpl basicPluginConfigModelImpl = new BasicPluginConfigModelImpl(this, string, string2);
        try {
            class_mon.enter();
            configModels.add(basicPluginConfigModelImpl);
            Object var5_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
        UIManagerImpl.fireEvent(this.pi, 5, basicPluginConfigModelImpl);
        return basicPluginConfigModelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(BasicPluginConfigModel basicPluginConfigModel) {
        try {
            class_mon.enter();
            configModels.remove(basicPluginConfigModel);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
        UIManagerImpl.fireEvent(this.pi, 8, basicPluginConfigModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginConfigModel[] getPluginConfigModels() {
        try {
            class_mon.enter();
            PluginConfigModel[] pluginConfigModelArray = configModels.toArray(new PluginConfigModel[0]);
            Object var3_2 = null;
            class_mon.exit();
            return pluginConfigModelArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public void copyToClipBoard(String string) throws UIException {
        boolean bl = UIManagerImpl.fireEvent(this.pi, 6, string);
        if (!bl) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    public void openURL(URL uRL) throws UIException {
        boolean bl = UIManagerImpl.fireEvent(this.pi, 9, uRL);
        if (!bl) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialisationComplete() {
        try {
            class_mon.enter();
            initialisation_complete = true;
            for (int i = 0; i < ui_factories.size(); ++i) {
                UIInstanceFactory uIInstanceFactory = ui_factories.get(i);
                for (Object[] objectArray : ui_listeners) {
                    try {
                        ((UIManagerListener)objectArray[0]).UIAttached(uIInstanceFactory.getInstance((PluginInterface)objectArray[1]));
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            Object var6_5 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public void attachUI(UIInstanceFactory uIInstanceFactory) throws UIException {
        this.attachUI(uIInstanceFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUI(UIInstanceFactory uIInstanceFactory, IUIIntializer iUIIntializer) {
        try {
            class_mon.enter();
            ui_factories.add(uIInstanceFactory);
            if (initialisation_complete) {
                for (Object[] objectArray : ui_listeners) {
                    PluginInterface pluginInterface = (PluginInterface)objectArray[1];
                    String string = pluginInterface.getPluginName();
                    if (iUIIntializer != null) {
                        iUIIntializer.reportCurrentTask(MessageText.getString("splash.plugin.UIinit", new String[]{string}));
                        iUIIntializer.increaseProgress();
                    }
                    try {
                        ((UIManagerListener)objectArray[0]).UIAttached(uIInstanceFactory.getInstance(pluginInterface));
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            Object var9_8 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUI(UIInstanceFactory uIInstanceFactory) throws UIException {
        try {
            class_mon.enter();
            uIInstanceFactory.detach();
            ui_factories.remove(uIInstanceFactory);
            if (initialisation_complete) {
                for (Object[] objectArray : ui_listeners) {
                    try {
                        ((UIManagerListener)objectArray[0]).UIDetached(uIInstanceFactory.getInstance((PluginInterface)objectArray[1]));
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            Object var6_5 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIListener(UIManagerListener uIManagerListener) {
        try {
            class_mon.enter();
            ui_listeners.add(new Object[]{uIManagerListener, this.pi});
            if (initialisation_complete) {
                for (int i = 0; i < ui_factories.size(); ++i) {
                    UIInstanceFactory uIInstanceFactory = ui_factories.get(i);
                    try {
                        uIManagerListener.UIAttached(uIInstanceFactory.getInstance(this.pi));
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            Object var6_5 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIListener(UIManagerListener uIManagerListener) {
        try {
            class_mon.enter();
            Iterator iterator = ui_listeners.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (objectArray[0] != uIManagerListener) continue;
                iterator.remove();
            }
            Object var5_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIEventListener(UIManagerEventListener uIManagerEventListener) {
        ArrayList<UIManagerEventAdapter> arrayList;
        try {
            class_mon.enter();
            ui_event_listeners.add(uIManagerEventListener);
            arrayList = new ArrayList<UIManagerEventAdapter>(ui_event_history);
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                uIManagerEventListener.eventOccurred((UIManagerEvent)arrayList.get(i));
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIEventListener(UIManagerEventListener uIManagerEventListener) {
        try {
            class_mon.enter();
            ui_event_listeners.remove(uIManagerEventListener);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public boolean hasUIInstances() {
        return !ui_factories.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIInstance[] getUIInstances() {
        try {
            class_mon.enter();
            ArrayList<UIInstance> arrayList = new ArrayList<UIInstance>(ui_factories.size());
            for (int i = 0; i < ui_factories.size(); ++i) {
                UIInstanceFactory uIInstanceFactory = ui_factories.get(i);
                arrayList.add(uIInstanceFactory.getInstance(this.pi));
            }
            UIInstance[] uIInstanceArray = arrayList.toArray(new UIInstance[arrayList.size()]);
            Object var5_5 = null;
            class_mon.exit();
            return uIInstanceArray;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static boolean fireEvent(PluginInterface pluginInterface, int n, Object object) {
        return UIManagerImpl.fireEvent(new UIManagerEventAdapter(pluginInterface, n, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fireEvent(UIManagerEventAdapter uIManagerEventAdapter) {
        int n;
        boolean bl = false;
        Iterator iterator = ui_event_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                if (!((UIManagerEventListener)iterator.next()).eventOccurred(uIManagerEventAdapter)) continue;
                bl = true;
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if ((n = uIManagerEventAdapter.getType()) == 4 || n == 5 || n == 12 || n == 15 || n == 17 || n == 19) {
            bl = true;
            try {
                class_mon.enter();
                ui_event_history.add(uIManagerEventAdapter);
                Object var5_5 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        if (n == 7 || n == 8) {
            bl = true;
            try {
                class_mon.enter();
                Iterator<UIManagerEventAdapter> iterator2 = ui_event_history.iterator();
                while (iterator2.hasNext()) {
                    UIManagerEvent uIManagerEvent = iterator2.next();
                    int n2 = uIManagerEvent.getType();
                    if (n2 != 4 && n2 != 5 || uIManagerEvent.getData() != uIManagerEventAdapter.getData()) continue;
                    iterator2.remove();
                    break;
                }
                Object var8_11 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        return bl;
    }

    public void showTextMessage(String string, String string2, String string3) {
        UIManagerImpl.fireEvent(this.pi, 1, new String[]{string, string2, string3});
    }

    public long showMessageBox(String string, String string2, long l) {
        UIManagerEventAdapter uIManagerEventAdapter = new UIManagerEventAdapter(this.pi, 21, new Object[]{string, string2, new Long(l)});
        if (!UIManagerImpl.fireEvent(uIManagerEventAdapter)) {
            return 0L;
        }
        return (Long)uIManagerEventAdapter.getResult();
    }

    public void openTorrent(Torrent torrent) {
        UIManagerImpl.fireEvent(this.pi, 22, torrent);
    }

    public void openFile(File file) {
        UIManagerImpl.fireEvent(this.pi, 24, file);
    }

    public void showFile(File file) {
        UIManagerImpl.fireEvent(this.pi, 23, file);
    }

    public boolean showConfigSection(String string) {
        UIManagerEventAdapter uIManagerEventAdapter = new UIManagerEventAdapter(this.pi, 13, string);
        if (!UIManagerImpl.fireEvent(uIManagerEventAdapter)) {
            return false;
        }
        if (uIManagerEventAdapter.getResult() instanceof Boolean) {
            return false;
        }
        return (Boolean)uIManagerEventAdapter.getResult();
    }

    public UIInputReceiver getInputReceiver() {
        UIInstance[] uIInstanceArray = this.getUIInstances();
        UIInputReceiver uIInputReceiver = null;
        for (int i = 0; i < uIInstanceArray.length; ++i) {
            uIInputReceiver = uIInstanceArray[i].getInputReceiver();
            if (uIInputReceiver == null) continue;
            return uIInputReceiver;
        }
        return null;
    }

    public UIMessage createMessage() {
        UIInstance[] uIInstanceArray = this.getUIInstances();
        UIMessage uIMessage = null;
        for (int i = 0; i < uIInstanceArray.length; ++i) {
            uIMessage = uIInstanceArray[i].createMessage();
            if (uIMessage == null) continue;
            return uIMessage;
        }
        return null;
    }

    public BasicPluginViewModel createLoggingViewModel(LoggerChannel loggerChannel, boolean bl) {
        String string = bl ? this.pi.getPluginName() : loggerChannel.getName();
        BasicPluginViewModel basicPluginViewModel = this.createBasicPluginViewModel(string);
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        basicPluginViewModel.getStatus().setVisible(false);
        basicPluginViewModel.attachLoggerChannel(loggerChannel);
        return basicPluginViewModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload(PluginInterface pluginInterface) {
        try {
            Object[] objectArray;
            class_mon.enter();
            Iterator iterator = ui_listeners.iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                if (pluginInterface != (PluginInterface)objectArray[1]) continue;
                iterator.remove();
            }
            objectArray = ui_event_history.iterator();
            while (objectArray.hasNext()) {
                UIManagerEventAdapter uIManagerEventAdapter = (UIManagerEventAdapter)objectArray.next();
                if (uIManagerEventAdapter.getPluginInterface() != pluginInterface) continue;
                objectArray.remove();
            }
            Object var5_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    static {
        ui_listeners = new CopyOnWriteList();
        ui_event_listeners = new CopyOnWriteList();
        ui_factories = new ArrayList<UIInstanceFactory>();
        ui_event_history = new ArrayList<UIManagerEventAdapter>();
        configModels = new ArrayList<BasicPluginConfigModel>();
    }
}

