/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.security.MessageDigest;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class PasswordParameterImpl
extends ParameterImpl
implements PasswordParameter {
    protected byte[] defaultValue;
    protected int encoding_type;

    public PasswordParameterImpl(PluginConfigImpl pluginConfigImpl, String string, String string2, int n, byte[] byArray) {
        super(pluginConfigImpl, string, string2);
        if (byArray == null) {
            this.defaultValue = new byte[0];
        } else {
            this.defaultValue = byArray;
            if (n == 2) {
                SHA1Hasher sHA1Hasher = new SHA1Hasher();
                this.defaultValue = sHA1Hasher.calculateHash(this.defaultValue);
            } else if (n == 3) {
                try {
                    this.defaultValue = MessageDigest.getInstance("md5").digest(this.defaultValue);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        pluginConfigImpl.notifyParamExists(this.getKey());
        COConfigurationManager.setByteDefault(this.getKey(), this.defaultValue);
        this.encoding_type = n;
    }

    public byte[] getDefaultValue() {
        return this.defaultValue;
    }

    public int getEncodingType() {
        return this.encoding_type;
    }

    public byte[] getValue() {
        return this.config.getUnsafeByteParameter(this.getKey(), this.getDefaultValue());
    }
}

