/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPChecker;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerFactory;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.AggregatedDispatcher;
import org.gudy.azureus2.plugins.utils.AggregatedList;
import org.gudy.azureus2.plugins.utils.AggregatedListAcceptor;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInitiator;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.subscriptions.Subscription;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionException;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionManager;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionResult;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.LocaleUtilitiesImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.MonitorImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.SemaphoreImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UTTimerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourceuploader.ResourceUploaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SESecurityManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSFeedImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilitiesImpl
implements Utilities {
    private static InetAddress last_public_ip_address;
    private static long last_public_ip_address_time;
    private AzureusCore core;
    private PluginInterface pi;
    private static ThreadLocal<PluginInterface> tls;
    private static List<searchManager> search_managers;
    private static List<Object[]> search_providers;
    private static CopyOnWriteList<Utilities.FeatureEnabler> feature_enablers;
    private static List delayed_tasks;
    private static AESemaphore delayed_tasks_sem;
    private static AEThread2 delayed_task_thread;

    public UtilitiesImpl(AzureusCore azureusCore, PluginInterface pluginInterface) {
        this.core = azureusCore;
        this.pi = pluginInterface;
    }

    @Override
    public String getAzureusUserDir() {
        String string = SystemProperties.getUserPath();
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public String getAzureusProgramDir() {
        String string = SystemProperties.getApplicationPath();
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public boolean isWindows() {
        return Constants.isWindows;
    }

    @Override
    public boolean isLinux() {
        return Constants.isLinux;
    }

    @Override
    public boolean isUnix() {
        return Constants.isUnix;
    }

    @Override
    public boolean isFreeBSD() {
        return Constants.isFreeBSD;
    }

    @Override
    public boolean isSolaris() {
        return Constants.isSolaris;
    }

    @Override
    public boolean isOSX() {
        return Constants.isOSX;
    }

    @Override
    public boolean isCVSVersion() {
        return Constants.isCVSVersion();
    }

    @Override
    public InputStream getImageAsStream(String string) {
        return UtilitiesImpl.class.getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/icons/" + string);
    }

    @Override
    public Semaphore getSemaphore() {
        return new SemaphoreImpl(this.pi);
    }

    @Override
    public Monitor getMonitor() {
        return new MonitorImpl(this.pi);
    }

    @Override
    public ByteBuffer allocateDirectByteBuffer(int n) {
        return DirectByteBufferPool.getBuffer((byte)1, n).getBuffer((byte)1);
    }

    @Override
    public void freeDirectByteBuffer(ByteBuffer byteBuffer) {
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(int n) {
        return new PooledByteBufferImpl(n);
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(byte[] byArray) {
        return new PooledByteBufferImpl(byArray);
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(Map map) throws IOException {
        return new PooledByteBufferImpl(BEncoder.encode(map));
    }

    @Override
    public Formatters getFormatters() {
        return new FormattersImpl();
    }

    @Override
    public LocaleUtilities getLocaleUtilities() {
        return new LocaleUtilitiesImpl(this.pi);
    }

    @Override
    public UTTimer createTimer(String string) {
        return new UTTimerImpl(this.pi, string, false);
    }

    @Override
    public UTTimer createTimer(String string, boolean bl) {
        return new UTTimerImpl(this.pi, string, bl);
    }

    @Override
    public UTTimer createTimer(String string, int n) {
        return new UTTimerImpl(this.pi, string, n);
    }

    @Override
    public void createThread(String string, final Runnable runnable) {
        AEThread2 aEThread2 = new AEThread2(this.pi.getPluginName() + "::" + string, true){

            public void run() {
                UtilitiesImpl.callWithPluginThreadContext(UtilitiesImpl.this.pi, runnable);
            }
        };
        aEThread2.start();
    }

    @Override
    public void createProcess(String string) throws PluginException {
        try {
            PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
            platformManager.createProcess(string, false);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            try {
                Runtime.getRuntime().exec(string);
            }
            catch (Throwable throwable2) {
                throw new PluginException("Failed to create process", throwable2);
            }
        }
    }

    @Override
    public ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    @Override
    public ResourceUploaderFactory getResourceUploaderFactory() {
        return ResourceUploaderFactoryImpl.getSingleton();
    }

    @Override
    public SESecurityManager getSecurityManager() {
        return new SESecurityManagerImpl(this.core);
    }

    @Override
    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory() {
        return new SimpleXMLParserDocumentFactoryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RSSFeed getRSSFeed(InputStream inputStream) throws SimpleXMLParserDocumentException {
        RSSFeedImpl rSSFeedImpl;
        try {
            rSSFeedImpl = new RSSFeedImpl((Utilities)this, inputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                inputStream.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rSSFeedImpl;
    }

    @Override
    public RSSFeed getRSSFeed(URL uRL) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return this.getRSSFeed(this.getResourceDownloaderFactory().create(uRL));
    }

    @Override
    public RSSFeed getRSSFeed(ResourceDownloader resourceDownloader) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return new RSSFeedImpl((Utilities)this, resourceDownloader);
    }

    @Override
    public InetAddress getPublicAddress(boolean bl) {
        if (bl) {
            String string = VersionCheckClient.getSingleton().getExternalIpAddress(false, true);
            if (string != null && string.length() > 0) {
                try {
                    return InetAddress.getByName(string);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            return null;
        }
        return this.getPublicAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getPublicAddress() {
        InetAddress inetAddress;
        long l;
        block12: {
            l = SystemTime.getCurrentTime();
            if (l < last_public_ip_address_time) {
                last_public_ip_address_time = l;
            } else if (last_public_ip_address != null && l - last_public_ip_address_time < 900000L) {
                return last_public_ip_address;
            }
            inetAddress = null;
            try {
                String string = VersionCheckClient.getSingleton().getExternalIpAddress(false, false);
                if (string != null && string.length() > 0) {
                    inetAddress = InetAddress.getByName(string);
                    break block12;
                }
                ExternalIPChecker externalIPChecker = ExternalIPCheckerFactory.create();
                ExternalIPCheckerService[] externalIPCheckerServiceArray = externalIPChecker.getServices();
                final String[] stringArray = new String[]{null};
                for (int i = 0; i < externalIPCheckerServiceArray.length && stringArray[0] == null; ++i) {
                    ExternalIPCheckerService externalIPCheckerService = externalIPCheckerServiceArray[i];
                    if (externalIPCheckerService.supportsCheck()) {
                        Object var13_12;
                        final AESemaphore aESemaphore = new AESemaphore("Utilities:getExtIP");
                        ExternalIPCheckerServiceListener externalIPCheckerServiceListener = new ExternalIPCheckerServiceListener(){

                            public void checkComplete(ExternalIPCheckerService externalIPCheckerService, String string) {
                                stringArray[0] = string;
                                aESemaphore.release();
                            }

                            public void checkFailed(ExternalIPCheckerService externalIPCheckerService, String string) {
                                aESemaphore.release();
                            }

                            public void reportProgress(ExternalIPCheckerService externalIPCheckerService, String string) {
                            }
                        };
                        externalIPCheckerServiceArray[i].addListener(externalIPCheckerServiceListener);
                        try {
                            externalIPCheckerServiceArray[i].initiateCheck(60000L);
                            aESemaphore.reserve(60000L);
                            var13_12 = null;
                            externalIPCheckerServiceArray[i].removeListener(externalIPCheckerServiceListener);
                        }
                        catch (Throwable throwable) {
                            var13_12 = null;
                            externalIPCheckerServiceArray[i].removeListener(externalIPCheckerServiceListener);
                            throw throwable;
                        }
                    }
                    if (stringArray[0] == null) continue;
                    inetAddress = InetAddress.getByName(stringArray[0]);
                    break;
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (inetAddress == null) {
            inetAddress = last_public_ip_address;
        } else {
            last_public_ip_address = inetAddress;
            last_public_ip_address_time = l;
        }
        return inetAddress;
    }

    @Override
    public String reverseDNSLookup(InetAddress inetAddress) {
        final AESemaphore aESemaphore = new AESemaphore("Utilities:reverseDNS");
        final String[] stringArray = new String[]{null};
        IPToHostNameResolver.addResolverRequest(inetAddress.getHostAddress(), new IPToHostNameResolverListener(){

            public void IPResolutionComplete(String string, boolean bl) {
                if (bl) {
                    stringArray[0] = string;
                }
                aESemaphore.release();
            }
        });
        aESemaphore.reserve(60000L);
        return stringArray[0];
    }

    @Override
    public long getCurrentSystemTime() {
        return SystemTime.getCurrentTime();
    }

    @Override
    public ByteArrayWrapper createWrapper(byte[] byArray) {
        return new HashWrapper(byArray);
    }

    @Override
    public AggregatedDispatcher createAggregatedDispatcher(final long l, final long l2) {
        return new AggregatedDispatcher(){
            private AggregatedList list;
            {
                this.list = UtilitiesImpl.this.createAggregatedList(new AggregatedListAcceptor(){

                    public void accept(List list) {
                        for (int i = 0; i < list.size(); ++i) {
                            try {
                                ((Runnable)list.get(i)).run();
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }
                }, l, l2);
            }

            public void add(Runnable runnable) {
                this.list.add(runnable);
            }

            public Runnable remove(Runnable runnable) {
                return (Runnable)this.list.remove(runnable);
            }

            public void destroy() {
                this.list.destroy();
            }
        };
    }

    @Override
    public AggregatedList createAggregatedList(final AggregatedListAcceptor aggregatedListAcceptor, final long l, final long l2) {
        return new AggregatedList(){
            AEMonitor timer_mon = new AEMonitor("aggregatedList");
            Timer timer = new Timer("AggregatedList");
            TimerEvent event;
            List list = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(Object object) {
                List list = null;
                try {
                    this.timer_mon.enter();
                    if (l2 > 0L && l2 == (long)this.list.size()) {
                        list = this.list;
                        this.list = new ArrayList();
                    }
                    this.list.add(object);
                    long l3 = SystemTime.getCurrentTime();
                    if (this.event != null) {
                        this.event.cancel();
                    }
                    this.event = this.timer.addEvent(l3 + l, new TimerEventPerformer(){

                        public void perform(TimerEvent timerEvent2) {
                            this.dispatch();
                        }
                    });
                    Object var6_4 = null;
                    this.timer_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.timer_mon.exit();
                    throw throwable;
                }
                if (list != null) {
                    this.dispatch(list);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object remove(Object object) {
                Object object2 = null;
                try {
                    this.timer_mon.enter();
                    Object object3 = object2 = this.list.remove(object) ? object : null;
                    if (object2 != null) {
                        long l3 = SystemTime.getCurrentTime();
                        if (this.event != null) {
                            this.event.cancel();
                        }
                        this.event = this.list.size() == 0 ? null : this.timer.addEvent(l3 + l, new TimerEventPerformer(){

                            public void perform(TimerEvent timerEvent2) {
                                this.dispatch();
                            }
                        });
                    }
                    Object var6_4 = null;
                    this.timer_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.timer_mon.exit();
                    throw throwable;
                }
                return object2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void dispatch() {
                List list;
                try {
                    this.timer_mon.enter();
                    list = this.list;
                    this.list = new ArrayList();
                    Object var3_2 = null;
                    this.timer_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.timer_mon.exit();
                    throw throwable;
                }
                this.dispatch(list);
            }

            protected void dispatch(List list) {
                if (list.size() > 0) {
                    try {
                        aggregatedListAcceptor.accept(list);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }

            public void destroy() {
                this.dispatch();
                this.timer.destroy();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void callWithPluginThreadContext(PluginInterface pluginInterface, Runnable runnable) {
        PluginInterface pluginInterface2 = tls.get();
        try {
            tls.set(pluginInterface);
            runnable.run();
            Object var4_3 = null;
            tls.set(pluginInterface2);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            tls.set(pluginInterface2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends Exception> void callWithPluginThreadContext(PluginInterface pluginInterface, runnableWithException<T> runnableWithException2) throws T {
        PluginInterface pluginInterface2 = tls.get();
        try {
            tls.set(pluginInterface);
            runnableWithException2.run();
            Object var4_3 = null;
            tls.set(pluginInterface2);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            tls.set(pluginInterface2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T callWithPluginThreadContext(PluginInterface pluginInterface, runnableWithReturn<T> runnableWithReturn2) {
        T t;
        PluginInterface pluginInterface2 = tls.get();
        try {
            tls.set(pluginInterface);
            t = runnableWithReturn2.run();
            Object var5_4 = null;
            tls.set(pluginInterface2);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            tls.set(pluginInterface2);
            throw throwable;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, S extends Exception> T callWithPluginThreadContext(PluginInterface pluginInterface, runnableWithReturnAndException<T, S> runnableWithReturnAndException2) throws S {
        T t;
        PluginInterface pluginInterface2 = tls.get();
        try {
            tls.set(pluginInterface);
            t = runnableWithReturnAndException2.run();
            Object var5_4 = null;
            tls.set(pluginInterface2);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            tls.set(pluginInterface2);
            throw throwable;
        }
        return t;
    }

    public static PluginInterface getPluginThreadContext() {
        return tls.get();
    }

    @Override
    public Map readResilientBEncodedFile(File file, String string, boolean bl) {
        return FileUtil.readResilientFile(file, string, bl);
    }

    @Override
    public void writeResilientBEncodedFile(File file, String string, Map map, boolean bl) {
        FileUtil.writeResilientFile(file, string, map, bl);
    }

    @Override
    public void deleteResilientBEncodedFile(File file, String string, boolean bl) {
        FileUtil.deleteResilientFile(new File(file, string));
    }

    @Override
    public int compareVersions(String string, String string2) {
        return Constants.compareVersions(string, string2);
    }

    @Override
    public String normaliseFileName(String string) {
        return FileUtil.convertOSSpecificChars(string, false);
    }

    @Override
    public DelayedTask createDelayedTask(Runnable runnable) {
        return UtilitiesImpl.addDelayedTask(this.pi.getPluginName(), runnable);
    }

    public static DelayedTask addDelayedTask(String string, Runnable runnable) {
        DelayedTaskImpl delayedTaskImpl = new DelayedTaskImpl(string);
        delayedTaskImpl.setTask(runnable);
        return delayedTaskImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueTask(DelayedTaskImpl delayedTaskImpl, int n) {
        List list = delayed_tasks;
        synchronized (list) {
            delayed_tasks.add(n == -1 ? delayed_tasks.size() : n, delayedTaskImpl);
            delayed_tasks_sem.release();
            if (delayed_task_thread == null) {
                delayed_task_thread = new AEThread2("Utilities:delayedTask", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            PluginInitializer.addInitThread();
                            while (true) {
                                Object object;
                                if (!delayed_tasks_sem.reserve(5000L)) {
                                    object = delayed_tasks;
                                    synchronized (object) {
                                        if (delayed_tasks.isEmpty()) {
                                            delayed_task_thread = null;
                                            break;
                                        }
                                    }
                                }
                                List list = delayed_tasks;
                                synchronized (list) {
                                    object = (DelayedTaskImpl)delayed_tasks.remove(0);
                                }
                                ((DelayedTaskImpl)object).run();
                            }
                            Object var5_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            PluginInitializer.removeInitThread();
                            throw throwable;
                        }
                        PluginInitializer.removeInitThread();
                    }
                };
                delayed_task_thread.setPriority(1);
                delayed_task_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSearchProvider(SearchProvider searchProvider) throws SearchException {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            search_providers.add(new Object[]{this.pi, searchProvider});
            ArrayList<searchManager> arrayList = new ArrayList<searchManager>(search_managers);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (int i = 0; i < arrayList.size(); ++i) {
                ((searchManager)arrayList.get(i)).addProvider(this.pi, searchProvider);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchInitiator getSearchInitiator() throws SearchException {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            ArrayList<searchManager> arrayList = new ArrayList<searchManager>(search_managers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (arrayList.size() == 0) {
                throw new SearchException("No search managers registered - try later");
            }
            return (SearchInitiator)arrayList.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchManager(searchManager searchManager2) {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            search_managers.add(searchManager2);
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(search_providers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (int i = 0; i < arrayList.size(); ++i) {
                Object[] objectArray = (Object[])arrayList.get(i);
                searchManager2.addProvider((PluginInterface)objectArray[0], (SearchProvider)objectArray[1]);
            }
            return;
        }
    }

    @Override
    public boolean isFeatureEnabled(String string, Map<String, Object> map) {
        String string2 = this.pi.getPluginID();
        if (!string2.endsWith("_v")) {
            return false;
        }
        for (Utilities.FeatureEnabler featureEnabler : feature_enablers) {
            if (!featureEnabler.isFeatureEnabled(string2, string, map)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerFeatureEnabler(Utilities.FeatureEnabler featureEnabler) {
        if (!this.pi.getPluginID().endsWith("_v")) {
            return;
        }
        feature_enablers.add(featureEnabler);
    }

    @Override
    public void unregisterFeatureEnabler(Utilities.FeatureEnabler featureEnabler) {
        feature_enablers.remove(featureEnabler);
    }

    @Override
    public SubscriptionManager getSubscriptionManager() throws SubscriptionException {
        try {
            Method method = Class.forName("com.aelitis.azureus.core.subs.SubscriptionManagerFactory").getMethod("getSingleton", new Class[0]);
            final PluginSubscriptionManager pluginSubscriptionManager = (PluginSubscriptionManager)method.invoke(null, new Object[0]);
            return new SubscriptionManager(){

                public Subscription[] getSubscriptions() {
                    PluginSubscription[] pluginSubscriptionArray = pluginSubscriptionManager.getSubscriptions(true);
                    Subscription[] subscriptionArray = new Subscription[pluginSubscriptionArray.length];
                    for (int i = 0; i < subscriptionArray.length; ++i) {
                        final PluginSubscription pluginSubscription = pluginSubscriptionArray[i];
                        subscriptionArray[i] = new Subscription(){

                            public String getID() {
                                return pluginSubscription.getID();
                            }

                            public String getName() {
                                return pluginSubscription.getName();
                            }

                            public SubscriptionResult[] getResults() {
                                PluginSubscriptionResult[] pluginSubscriptionResultArray = pluginSubscription.getResults(false);
                                SubscriptionResult[] subscriptionResultArray = new SubscriptionResult[pluginSubscriptionResultArray.length];
                                for (int i = 0; i < subscriptionResultArray.length; ++i) {
                                    final PluginSubscriptionResult pluginSubscriptionResult = pluginSubscriptionResultArray[i];
                                    subscriptionResultArray[i] = new SubscriptionResult(){
                                        private Map<Integer, Object> map;
                                        {
                                            this.map = pluginSubscriptionResult.toPropertyMap();
                                        }

                                        public Object getProperty(int n) {
                                            return this.map.get(n);
                                        }

                                        public boolean isRead() {
                                            return pluginSubscriptionResult.getRead();
                                        }

                                        public void setRead(boolean bl) {
                                            pluginSubscriptionResult.setRead(bl);
                                        }
                                    };
                                }
                                return subscriptionResultArray;
                            }
                        };
                    }
                    return subscriptionArray;
                }
            };
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Subscriptions unavailable", throwable);
        }
    }

    static {
        tls = new ThreadLocal<PluginInterface>(){

            @Override
            public PluginInterface initialValue() {
                return null;
            }
        };
        search_managers = new ArrayList<searchManager>();
        search_providers = new ArrayList<Object[]>();
        feature_enablers = new CopyOnWriteList();
        delayed_tasks = new ArrayList();
        delayed_tasks_sem = new AESemaphore("Utilities:delayedTask");
    }

    static class DelayedTaskImpl
    implements DelayedTask {
        private String name;
        private Runnable target;
        private long create_time = SystemTime.getCurrentTime();
        private long run_time;

        private DelayedTaskImpl(String string) {
            this.name = string;
        }

        public void setTask(Runnable runnable) {
            this.target = runnable;
        }

        public void queue() {
            if (this.target == null) {
                throw new RuntimeException("Target must be set before queueing");
            }
            UtilitiesImpl.queueTask(this, -1);
        }

        public void queueFirst() {
            if (this.target == null) {
                throw new RuntimeException("Target must be set before queueing");
            }
            UtilitiesImpl.queueTask(this, 0);
        }

        protected void run() {
            try {
                this.run_time = SystemTime.getCurrentTime();
                this.target.run();
                long l = SystemTime.getCurrentTime();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LogIDs.PLUGIN, 0, "Delayed task '" + this.getName() + "': queue_time=" + (this.run_time - this.create_time) + ", exec_time=" + (l - this.run_time)));
                }
            }
            catch (Throwable throwable) {
                Debug.out("Initialisation task " + this.getName() + " failed to complete", throwable);
            }
        }

        protected String getName() {
            return this.name + " (" + this.target.getClass() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface runnableWithReturnAndException<T, S extends Exception> {
        public T run() throws S;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface runnableWithException<T extends Exception> {
        public void run() throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface runnableWithReturn<T> {
        public T run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PluginSubscriptionResult {
        public Map<Integer, Object> toPropertyMap();

        public void setRead(boolean var1);

        public boolean getRead();
    }

    public static interface PluginSubscription {
        public String getID();

        public String getName();

        public PluginSubscriptionResult[] getResults(boolean var1);
    }

    public static interface PluginSubscriptionManager {
        public PluginSubscription[] getSubscriptions(boolean var1);
    }

    public static interface searchManager
    extends SearchInitiator {
        public void addProvider(PluginInterface var1, SearchProvider var2);
    }
}

