/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderDelayedFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderAlternateImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderDelayedImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFileImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderMetaRefreshImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderRetryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderTimeoutImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderTorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderURLImpl;

public class ResourceDownloaderFactoryImpl
implements ResourceDownloaderFactory {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static ResourceDownloaderFactoryImpl singleton = new ResourceDownloaderFactoryImpl();
    private static final String[] SF_MIRRORS = new String[]{"jaist", "nchc", "keihanna", "optusnet", "peterhost", "ovh", "puzzle", "switch", "mesh", "kent", "surfnet", "heanet", "citkit", "internap", "cogent", "umn", "easynews", "ufpr"};

    public static ResourceDownloaderFactory getSingleton() {
        return singleton;
    }

    public ResourceDownloader create(File file) {
        return new ResourceDownloaderFileImpl(null, file);
    }

    public ResourceDownloader create(URL uRL) {
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            try {
                return new ResourceDownloaderFileImpl(null, new File(new URI(uRL.toString())));
            }
            catch (Throwable throwable) {
                return new ResourceDownloaderURLImpl(null, uRL);
            }
        }
        return new ResourceDownloaderURLImpl(null, uRL);
    }

    public ResourceDownloader create(URL uRL, boolean bl) {
        ResourceDownloader resourceDownloader = this.create(uRL);
        if (bl && resourceDownloader instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)resourceDownloader).setForceNoProxy(bl);
        }
        return resourceDownloader;
    }

    public ResourceDownloader create(URL uRL, String string) {
        return new ResourceDownloaderURLImpl(null, uRL, string, false, null, null);
    }

    public ResourceDownloader create(URL uRL, String string, String string2) {
        return new ResourceDownloaderURLImpl(null, uRL, string, string2);
    }

    public ResourceDownloader create(ResourceDownloaderDelayedFactory resourceDownloaderDelayedFactory) {
        return new ResourceDownloaderDelayedImpl(null, resourceDownloaderDelayedFactory);
    }

    public ResourceDownloader getRetryDownloader(ResourceDownloader resourceDownloader, int n) {
        ResourceDownloaderRetryImpl resourceDownloaderRetryImpl = new ResourceDownloaderRetryImpl(null, resourceDownloader, n);
        return resourceDownloaderRetryImpl;
    }

    public ResourceDownloader getTimeoutDownloader(ResourceDownloader resourceDownloader, int n) {
        ResourceDownloaderTimeoutImpl resourceDownloaderTimeoutImpl = new ResourceDownloaderTimeoutImpl(null, resourceDownloader, n);
        return resourceDownloaderTimeoutImpl;
    }

    public ResourceDownloader getAlternateDownloader(ResourceDownloader[] resourceDownloaderArray) {
        return this.getAlternateDownloader(resourceDownloaderArray, -1, false);
    }

    public ResourceDownloader getAlternateDownloader(ResourceDownloader[] resourceDownloaderArray, int n) {
        return this.getAlternateDownloader(resourceDownloaderArray, n, false);
    }

    public ResourceDownloader getRandomDownloader(ResourceDownloader[] resourceDownloaderArray) {
        return this.getAlternateDownloader(resourceDownloaderArray, -1, true);
    }

    public ResourceDownloader getRandomDownloader(ResourceDownloader[] resourceDownloaderArray, int n) {
        return this.getAlternateDownloader(resourceDownloaderArray, n, true);
    }

    protected ResourceDownloader getAlternateDownloader(ResourceDownloader[] resourceDownloaderArray, int n, boolean bl) {
        ResourceDownloaderAlternateImpl resourceDownloaderAlternateImpl = new ResourceDownloaderAlternateImpl(null, resourceDownloaderArray, n, bl);
        return resourceDownloaderAlternateImpl;
    }

    public ResourceDownloader getMetaRefreshDownloader(ResourceDownloader resourceDownloader) {
        ResourceDownloaderMetaRefreshImpl resourceDownloaderMetaRefreshImpl = new ResourceDownloaderMetaRefreshImpl(null, resourceDownloader);
        return resourceDownloaderMetaRefreshImpl;
    }

    public ResourceDownloader getTorrentDownloader(ResourceDownloader resourceDownloader, boolean bl) {
        return this.getTorrentDownloader(resourceDownloader, bl, null);
    }

    public ResourceDownloader getTorrentDownloader(ResourceDownloader resourceDownloader, boolean bl, File file) {
        return new ResourceDownloaderTorrentImpl(null, resourceDownloader, bl, file);
    }

    public ResourceDownloader getSuffixBasedDownloader(ResourceDownloader resourceDownloader) {
        ResourceDownloaderBaseImpl resourceDownloaderBaseImpl = (ResourceDownloaderBaseImpl)resourceDownloader;
        URL uRL = null;
        while (true) {
            List list;
            if ((list = resourceDownloaderBaseImpl.getChildren()).size() == 0) break;
            resourceDownloaderBaseImpl = (ResourceDownloaderBaseImpl)list.get(0);
        }
        uRL = ((ResourceDownloaderURLImpl)resourceDownloaderBaseImpl).getURL();
        if (uRL == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "ResourceDownloader: suffix based downloader failed to find leaf"));
            }
            return resourceDownloader;
        }
        if (uRL.getPath().toLowerCase().endsWith(".torrent")) {
            return this.getTorrentDownloader(resourceDownloader, true);
        }
        return resourceDownloader;
    }

    public ResourceDownloader[] getSourceforgeDownloaders(String string, String string2) {
        String string3 = "http://%s.dl.sourceforge.net/sourceforge/" + string + "/" + string2;
        ResourceDownloader[] resourceDownloaderArray = new ResourceDownloader[SF_MIRRORS.length];
        for (int i = 0; i < resourceDownloaderArray.length; ++i) {
            String string4 = string3.replaceFirst("%s", SF_MIRRORS[i]);
            try {
                resourceDownloaderArray[i] = this.create(new URL(string4));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return resourceDownloaderArray;
    }

    public ResourceDownloader getSourceforgeDownloader(String string, String string2) {
        return this.getRandomDownloader(this.getSourceforgeDownloaders(string, string2));
    }
}

