/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderFileImpl
extends ResourceDownloaderBaseImpl {
    protected boolean cancelled;
    protected File file;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTimeout");
    protected long size = -2L;

    public ResourceDownloaderFileImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, File file) {
        super(resourceDownloaderBaseImpl);
        this.file = file;
    }

    public String getName() {
        return this.file.toString();
    }

    protected void setSize(long l) {
    }

    public long getSize() throws ResourceDownloaderException {
        String string = this.file.toString();
        int n = string.lastIndexOf(".");
        String string2 = n != -1 ? string.substring(n + 1) : null;
        this.setProperty("ContentType", HTTPUtils.guessContentTypeFromFileType(string2));
        return FileUtil.getFileOrDirectorySize(this.file);
    }

    public void setProperty(String string, Object object) {
        this.setPropertySupport(string, object);
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderFileImpl resourceDownloaderFileImpl = new ResourceDownloaderFileImpl(this.getParent(), this.file);
        return resourceDownloaderFileImpl;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof ResourceDownloaderException) {
            throw (ResourceDownloaderException)this.result;
        }
        return (InputStream)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.informActivity(this.getLogIndent() + (this.file.isDirectory() ? "Processing: " : "Downloading: ") + this.getName());
                final Object object = TorrentUtils.getTLS();
                AEThread2 aEThread2 = new AEThread2("ResourceDownloaderTimeout", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        Object object2 = TorrentUtils.getTLS();
                        TorrentUtils.setTLS(object);
                        try {
                            try {
                                if (ResourceDownloaderFileImpl.this.file.isDirectory()) {
                                    ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, null);
                                }
                                ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, new FileInputStream(ResourceDownloaderFileImpl.this.file));
                            }
                            catch (Throwable throwable) {
                                ResourceDownloaderFileImpl.this.failed(ResourceDownloaderFileImpl.this, new ResourceDownloaderException("Failed to read file", throwable));
                                Debug.printStackTrace(throwable);
                                Object var4_3 = null;
                                TorrentUtils.setTLS(object2);
                                return;
                            }
                            Object var4_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            TorrentUtils.setTLS(object2);
                            throw throwable;
                        }
                        TorrentUtils.setTLS(object2);
                    }
                };
                aEThread2.start();
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void cancel() {
        this.cancel(new ResourceDownloaderCancelledException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(ResourceDownloaderException resourceDownloaderException) {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = resourceDownloaderException;
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        if (this.informComplete(inputStream)) {
            this.result = inputStream;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.result = resourceDownloaderException;
        this.done_sem.release();
        this.informFailed(resourceDownloaderException);
    }
}

