/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import java.net.URL;
import org.gudy.azureus2.core3.html.HTMLException;
import org.gudy.azureus2.core3.html.HTMLPage;
import org.gudy.azureus2.core3.html.HTMLPageFactory;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderURLImpl;

public class ResourceDownloaderMetaRefreshImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    public static final int MAX_FOLLOWS = 1;
    protected ResourceDownloaderBaseImpl delegate;
    protected ResourceDownloaderBaseImpl current_delegate;
    protected long size = -2L;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected Object result;
    protected int done_count;
    protected AESemaphore done_sem = new AESemaphore("RDMetaRefresh");

    public ResourceDownloaderMetaRefreshImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, ResourceDownloader resourceDownloader) {
        super(resourceDownloaderBaseImpl);
        this.delegate = (ResourceDownloaderBaseImpl)resourceDownloader;
        this.delegate.setParent(this);
        this.current_delegate = this.delegate;
    }

    public String getName() {
        return this.delegate.getName() + ": meta-refresh";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                this.size = this.getSizeSupport();
                Object var2_1 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
                throw throwable;
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    public void setProperty(String string, Object object) throws ResourceDownloaderException {
        this.setPropertySupport(string, object);
        this.delegate.setProperty(string, object);
    }

    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            ResourceDownloaderBaseImpl resourceDownloaderBaseImpl = this.delegate.getClone(this);
            this.addReportListener(resourceDownloaderBaseImpl);
            HTMLPage hTMLPage = HTMLPageFactory.loadPage(resourceDownloaderBaseImpl.download());
            URL uRL = hTMLPage.getMetaRefreshURL();
            if (uRL == null) {
                ResourceDownloaderBaseImpl resourceDownloaderBaseImpl2 = this.delegate.getClone(this);
                this.addReportListener(resourceDownloaderBaseImpl2);
                long l = resourceDownloaderBaseImpl2.getSize();
                this.setProperties(resourceDownloaderBaseImpl2);
                return l;
            }
            ResourceDownloaderURLImpl resourceDownloaderURLImpl = new ResourceDownloaderURLImpl(this.getParent(), uRL);
            this.addReportListener(resourceDownloaderURLImpl);
            long l = resourceDownloaderURLImpl.getSize();
            this.setProperties(resourceDownloaderURLImpl);
            return l;
        }
        catch (HTMLException hTMLException) {
            throw new ResourceDownloaderException("getSize failed", hTMLException);
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderMetaRefreshImpl resourceDownloaderMetaRefreshImpl = new ResourceDownloaderMetaRefreshImpl(resourceDownloaderBaseImpl, this.delegate.getClone(this));
        resourceDownloaderMetaRefreshImpl.setSize(this.size);
        resourceDownloaderMetaRefreshImpl.setProperties(this);
        return resourceDownloaderMetaRefreshImpl;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else {
                ++this.done_count;
                this.current_downloader = this.current_delegate.getClone(this);
                this.informActivity(this.getLogIndent() + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            }
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException();
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        boolean bl = false;
        try {
            if (this.done_count == 1) {
                HTMLPage hTMLPage;
                URL uRL;
                boolean bl2 = false;
                if (inputStream.markSupported()) {
                    inputStream.mark(inputStream.available());
                    bl2 = true;
                }
                if ((uRL = (hTMLPage = HTMLPageFactory.loadPage(inputStream, !bl2)).getMetaRefreshURL()) == null) {
                    if (!bl2) {
                        this.failed(resourceDownloader, new ResourceDownloaderException("meta refresh tag not found and input stream not recoverable"));
                    } else {
                        inputStream.reset();
                        bl = true;
                    }
                } else {
                    this.current_delegate = new ResourceDownloaderURLImpl(this, uRL);
                    this.asyncDownload();
                }
                if (bl2 && !bl) {
                    inputStream.close();
                }
            } else {
                bl = true;
            }
            if (bl && this.informComplete(inputStream)) {
                this.result = inputStream;
                this.done_sem.release();
            }
        }
        catch (Throwable throwable) {
            this.failed(resourceDownloader, new ResourceDownloaderException("meta-refresh processing fails", throwable));
        }
        return true;
    }

    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.result = resourceDownloaderException;
        this.done_sem.release();
        this.informFailed(resourceDownloaderException);
    }
}

