/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.DeleteFileOnCloseInputStream;
import com.aelitis.azureus.core.util.Java15Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    private static final int MAX_IN_MEM_READ_SIZE = 262144;
    protected URL original_url;
    protected boolean auth_supplied;
    protected String user_name;
    protected String password;
    protected InputStream input_stream;
    protected boolean cancel_download = false;
    protected boolean download_initiated;
    protected long size = -2L;
    protected boolean force_no_proxy = false;
    private final String post_data;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL) {
        this(resourceDownloaderBaseImpl, uRL, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL, String string, String string2) {
        this(resourceDownloaderBaseImpl, uRL, true, string, string2);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL, boolean bl, String string, String string2) {
        this(resourceDownloaderBaseImpl, uRL, null, bl, string, string2);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL, String string, boolean bl, String string2, String string3) {
        super(resourceDownloaderBaseImpl);
        this.original_url = uRL;
        this.post_data = string;
        this.auth_supplied = bl;
        this.user_name = string2;
        this.password = string3;
    }

    protected void setForceNoProxy(boolean bl) {
        this.force_no_proxy = bl;
    }

    protected URL getURL() {
        return this.original_url;
    }

    public String getName() {
        return this.original_url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl resourceDownloaderURLImpl = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(resourceDownloaderURLImpl);
                this.size = resourceDownloaderURLImpl.getSizeSupport();
                this.setProperties(resourceDownloaderURLImpl);
                Object var3_2 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                throw throwable;
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    public void setProperty(String string, Object object) throws ResourceDownloaderException {
        this.setPropertySupport(string, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            String string = this.original_url.getProtocol().toLowerCase();
            if (string.equals("magnet")) return -1L;
            if (string.equals("dht")) {
                return -1L;
            }
            this.reportActivity(this, "Getting size of " + this.original_url);
            try {
                Object object = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                object = AddressUtils.adjustURL((URL)object);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler((URL)object, this);
                    }
                    int n = 0;
                    while (n < 2) {
                        long l;
                        Object object2;
                        try {
                            Object object3;
                            if (((URL)object).getProtocol().equalsIgnoreCase("https")) {
                                object2 = (HttpsURLConnection)this.openConnection((URL)object);
                                ((HttpsURLConnection)object2).setHostnameVerifier(new HostnameVerifier(){

                                    public boolean verify(String string, SSLSession sSLSession) {
                                        return true;
                                    }
                                });
                                object3 = object2;
                            } else {
                                object3 = (HttpURLConnection)this.openConnection((URL)object);
                            }
                            ((HttpURLConnection)object3).setRequestMethod("HEAD");
                            ((URLConnection)object3).setRequestProperty("User-Agent", "Azureus 4.3.0.4");
                            this.setRequestProperties((HttpURLConnection)object3, false);
                            ((URLConnection)object3).connect();
                            int n2 = ((HttpURLConnection)object3).getResponseCode();
                            if (n2 != 202 && n2 != 200) {
                                this.setProperty("URL_HTTP_Response", new Long(n2));
                                throw new ResourceDownloaderException("Error on connect for '" + this.trimForDisplay((URL)object) + "': " + Integer.toString(n2) + " " + ((HttpURLConnection)object3).getResponseMessage());
                            }
                            this.getRequestProperties((HttpURLConnection)object3);
                            l = UrlUtils.getContentLength((HttpURLConnection)object3);
                        }
                        catch (SSLException sSLException) {
                            if (n != 0) throw sSLException;
                            if (SESecurityManager.installServerCertificates((URL)object) == null) throw sSLException;
                        }
                        catch (IOException iOException) {
                            if (n != 0) throw iOException;
                            object2 = UrlUtils.getIPV4Fallback((URL)object);
                            if (object2 == null) throw iOException;
                            object = object2;
                        }
                        Object var9_15 = null;
                        if (!this.auth_supplied) return l;
                        SESecurityManager.setPasswordHandler((URL)object, null);
                        return l;
                        ++n;
                    }
                    throw new ResourceDownloaderException("Should never get here");
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    if (!this.auth_supplied) throw throwable;
                    SESecurityManager.setPasswordHandler((URL)object, null);
                    throw throwable;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.original_url + "':" + malformedURLException.getMessage(), malformedURLException);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + unknownHostException.getMessage() + "'", unknownHostException);
            }
            catch (IOException iOException) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", iOException);
            }
        }
        catch (Throwable throwable) {
            ResourceDownloaderException resourceDownloaderException;
            if (throwable instanceof ResourceDownloaderException) {
                resourceDownloaderException = (ResourceDownloaderException)throwable;
                throw resourceDownloaderException;
            }
            Debug.out(throwable);
            resourceDownloaderException = new ResourceDownloaderException("Unexpected error", throwable);
            throw resourceDownloaderException;
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderURLImpl resourceDownloaderURLImpl = new ResourceDownloaderURLImpl(resourceDownloaderBaseImpl, this.original_url, this.post_data, this.auth_supplied, this.user_name, this.password);
        resourceDownloaderURLImpl.setSize(this.size);
        resourceDownloaderURLImpl.setProperties(this);
        resourceDownloaderURLImpl.setForceNoProxy(this.force_no_proxy);
        return resourceDownloaderURLImpl;
    }

    public void asyncDownload() {
        final Object object = TorrentUtils.getTLS();
        AEThread2 aEThread2 = new AEThread2("ResourceDownloader:asyncDownload - " + this.trimForDisplay(this.original_url), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object object2 = TorrentUtils.getTLS();
                TorrentUtils.setTLS(object);
                try {
                    try {
                        ResourceDownloaderURLImpl.this.download();
                    }
                    catch (ResourceDownloaderException resourceDownloaderException) {
                        Object var4_3 = null;
                        TorrentUtils.setTLS(object2);
                        return;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    TorrentUtils.setTLS(object2);
                    throw throwable;
                }
                TorrentUtils.setTLS(object2);
            }
        };
        aEThread2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream download() throws ResourceDownloaderException {
        try {
            String string;
            this.reportActivity(this, this.getLogIndent() + "Downloading: " + this.trimForDisplay(this.original_url));
            try {
                this.this_mon.enter();
                if (this.download_initiated) {
                    throw new ResourceDownloaderException("Download already initiated");
                }
                this.download_initiated = true;
                string = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.this_mon.exit();
                throw throwable;
            }
            try {
                int n;
                boolean bl;
                Object object = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                string = ((URL)object).getProtocol().toLowerCase();
                if (((URL)object).getPort() == -1 && !string.equals("magnet") && !string.equals("dht")) {
                    bl = string.equals("http") ? 80 != 0 : 443 != 0;
                    try {
                        String string2 = this.original_url.toString().replaceAll(" ", "%20");
                        n = string2.indexOf("://");
                        n = string2.indexOf("/", n + 4);
                        object = n == -1 ? new URL(string2 + ":" + (int)(bl ? 1 : 0) + "/") : new URL(string2.substring(0, n) + ":" + (int)(bl ? 1 : 0) + string2.substring(n));
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                object = AddressUtils.adjustURL((URL)object);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler((URL)object, this);
                    }
                    bl = true;
                    boolean bl2 = true;
                    n = 0;
                    while (n < 2) {
                        if (!bl2) throw new ResourceDownloaderException("Should never get here");
                        bl2 = false;
                        for (int i = 0; i < 2; ++i) {
                            Object var24_36;
                            Object object2;
                            File file = null;
                            try {
                                boolean bl3;
                                Object object3;
                                block59: {
                                    Object object4;
                                    block60: {
                                        Object var20_35;
                                        Object object5;
                                        int n2;
                                        HttpURLConnection httpURLConnection;
                                        block58: {
                                            Object object6;
                                            if (((URL)object).getProtocol().equalsIgnoreCase("https")) {
                                                object6 = (HttpsURLConnection)this.openConnection((URL)object);
                                                ((HttpsURLConnection)object6).setHostnameVerifier(new HostnameVerifier(){

                                                    public boolean verify(String string, SSLSession sSLSession) {
                                                        return true;
                                                    }
                                                });
                                                httpURLConnection = object6;
                                            } else {
                                                httpURLConnection = (HttpURLConnection)this.openConnection((URL)object);
                                            }
                                            httpURLConnection.setRequestProperty("User-Agent", "Azureus 4.3.0.4");
                                            httpURLConnection.setRequestProperty("Connection", "close");
                                            if (bl) {
                                                httpURLConnection.addRequestProperty("Accept-Encoding", "gzip");
                                            }
                                            this.setRequestProperties(httpURLConnection, bl);
                                            if (this.post_data != null) {
                                                httpURLConnection.setDoOutput(true);
                                                httpURLConnection.setRequestMethod("POST");
                                                object6 = new OutputStreamWriter(httpURLConnection.getOutputStream());
                                                ((Writer)object6).write(this.post_data);
                                                ((OutputStreamWriter)object6).flush();
                                            }
                                            httpURLConnection.connect();
                                            n2 = httpURLConnection.getResponseCode();
                                            if ((n2 == 302 || n2 == 301) && (object2 = httpURLConnection.getHeaderField("location")) != null && ((URL)object).getProtocol().equalsIgnoreCase("http")) {
                                                try {
                                                    object5 = new URL(URLDecoder.decode((String)object2, "UTF-8"));
                                                    if (!((URL)object5).getProtocol().equalsIgnoreCase("https")) break block58;
                                                    object = object5;
                                                    bl2 = true;
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                var24_36 = null;
                                                if (file != null) {
                                                    file.delete();
                                                }
                                                break;
                                            }
                                        }
                                        if (n2 != 202 && n2 != 200) {
                                            this.setProperty("URL_HTTP_Response", new Long(n2));
                                            throw new ResourceDownloaderException("Error on connect for '" + this.trimForDisplay((URL)object) + "': " + Integer.toString(n2) + " " + httpURLConnection.getResponseMessage());
                                        }
                                        this.getRequestProperties(httpURLConnection);
                                        boolean bl4 = false;
                                        try {
                                            this.this_mon.enter();
                                            this.input_stream = httpURLConnection.getInputStream();
                                            object5 = httpURLConnection.getHeaderField("content-encoding");
                                            if (object5 != null) {
                                                if (((String)object5).equalsIgnoreCase("gzip")) {
                                                    bl4 = true;
                                                    this.input_stream = new GZIPInputStream(this.input_stream);
                                                } else if (((String)object5).equalsIgnoreCase("deflate")) {
                                                    bl4 = true;
                                                    this.input_stream = new InflaterInputStream(this.input_stream);
                                                }
                                            }
                                            object3 = null;
                                            this.this_mon.exit();
                                        }
                                        catch (Throwable throwable) {
                                            object3 = null;
                                            this.this_mon.exit();
                                            throw throwable;
                                        }
                                        object5 = null;
                                        FileOutputStream fileOutputStream = null;
                                        try {
                                            int n3;
                                            long l;
                                            object3 = new byte[32768];
                                            long l2 = 0L;
                                            long l3 = l = bl4 ? -1L : UrlUtils.getContentLength(httpURLConnection);
                                            Object object7 = l > 0L ? new ByteArrayOutputStream(l > 262144L ? 262144 : (int)l) : (object5 = new ByteArrayOutputStream());
                                            while (!this.cancel_download && (n3 = this.input_stream.read((byte[])object3)) > 0) {
                                                if (l2 > 262144L) {
                                                    if (fileOutputStream == null) {
                                                        file = AETemporaryFileHandler.createTempFile();
                                                        fileOutputStream = new FileOutputStream(file);
                                                        fileOutputStream.write(((ByteArrayOutputStream)object5).toByteArray());
                                                        object5 = null;
                                                    }
                                                    fileOutputStream.write((byte[])object3, 0, n3);
                                                } else {
                                                    ((ByteArrayOutputStream)object5).write((byte[])object3, 0, n3);
                                                }
                                                this.informAmountComplete(l2 += (long)n3);
                                                if (l <= 0L) continue;
                                                this.informPercentDone((int)(100L * l2 / l));
                                            }
                                            if (l > 0L && l2 != l) {
                                                if (l2 <= l) throw new IOException("Premature end of stream");
                                                Debug.outNoStack("Inconsistent stream length for '" + this.trimForDisplay(this.original_url) + "': expected = " + l + ", actual = " + l2);
                                            }
                                            var20_35 = null;
                                            if (fileOutputStream != null) {
                                                fileOutputStream.close();
                                            }
                                            this.input_stream.close();
                                        }
                                        catch (Throwable throwable) {
                                            var20_35 = null;
                                            if (fileOutputStream != null) {
                                                fileOutputStream.close();
                                            }
                                            this.input_stream.close();
                                            throw throwable;
                                        }
                                        if (file != null) {
                                            object3 = new DeleteFileOnCloseInputStream(file);
                                            file = null;
                                        } else {
                                            object3 = new ByteArrayInputStream(((ByteArrayOutputStream)object5).toByteArray());
                                        }
                                        bl3 = false;
                                        try {
                                            if (!this.informComplete((InputStream)object3)) break block59;
                                            bl3 = true;
                                            object4 = object3;
                                            Object var22_39 = null;
                                            if (bl3) break block60;
                                        }
                                        catch (Throwable throwable) {
                                            Object var22_41 = null;
                                            if (bl3) throw throwable;
                                            ((InputStream)object3).close();
                                            throw throwable;
                                        }
                                        ((InputStream)object3).close();
                                    }
                                    var24_36 = null;
                                    if (file != null) {
                                        file.delete();
                                    }
                                    Object var26_42 = null;
                                    if (!this.auth_supplied) return object4;
                                    SESecurityManager.setPasswordHandler((URL)object, null);
                                    return object4;
                                }
                                Object var22_40 = null;
                                if (bl3) throw new ResourceDownloaderException("Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                                ((InputStream)object3).close();
                                throw new ResourceDownloaderException("Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                            }
                            catch (SSLException sSLException) {
                                if (i != 0) throw sSLException;
                                if (SESecurityManager.installServerCertificates((URL)object) == null) throw sSLException;
                                var24_36 = null;
                                if (file == null) continue;
                                file.delete();
                                continue;
                            }
                            catch (ZipException zipException) {
                                if (i == 0) {
                                    bl = false;
                                    var24_36 = null;
                                    if (file == null) continue;
                                    file.delete();
                                    continue;
                                }
                                var24_36 = null;
                                if (file == null) continue;
                                file.delete();
                                continue;
                            }
                            catch (IOException iOException) {
                                if (i != 0) throw iOException;
                                String string3 = iOException.getMessage();
                                if (string3 != null && (string3 = string3.toLowerCase(MessageText.LOCALE_ENGLISH)).indexOf("gzip") != -1) {
                                    bl = false;
                                    var24_36 = null;
                                    if (file == null) continue;
                                    file.delete();
                                    continue;
                                }
                                object2 = UrlUtils.getIPV4Fallback((URL)object);
                                if (object2 == null) throw iOException;
                                object = object2;
                                var24_36 = null;
                                if (file == null) continue;
                                file.delete();
                                continue;
                            }
                            catch (Throwable throwable) {
                                var24_36 = null;
                                if (file == null) throw throwable;
                                file.delete();
                                throw throwable;
                            }
                        }
                        ++n;
                    }
                    throw new ResourceDownloaderException("Should never get here");
                }
                catch (Throwable throwable) {
                    Object var26_43 = null;
                    if (!this.auth_supplied) throw throwable;
                    SESecurityManager.setPasswordHandler((URL)object, null);
                    throw throwable;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.trimForDisplay(this.original_url) + "':" + malformedURLException.getMessage(), malformedURLException);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + unknownHostException.getMessage() + "'", unknownHostException);
            }
            catch (IOException iOException) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", iOException);
            }
        }
        catch (Throwable throwable) {
            ResourceDownloaderException resourceDownloaderException;
            if (throwable instanceof ResourceDownloaderException) {
                resourceDownloaderException = (ResourceDownloaderException)throwable;
            } else {
                Debug.out(throwable);
                resourceDownloaderException = new ResourceDownloaderException("Unexpected error", throwable);
            }
            this.informFailed(resourceDownloaderException);
            throw resourceDownloaderException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable throwable) {
                }
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.informFailed(new ResourceDownloaderCancelledException());
    }

    protected void setRequestProperties(HttpURLConnection httpURLConnection, boolean bl) {
        Map map = this.getLCKeyProperties();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (!string.startsWith("url_") || !(v instanceof String) || (string = string.substring(4)).equals("accept-encoding") && !bl) continue;
            httpURLConnection.setRequestProperty(string, (String)v);
        }
    }

    protected void getRequestProperties(HttpURLConnection httpURLConnection) {
        try {
            this.setProperty("ContentType", httpURLConnection.getContentType());
            this.setProperty("URL_URL", httpURLConnection.getURL());
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string = entry.getKey();
                List<String> list = entry.getValue();
                if (string == null) continue;
                this.setProperty("URL_" + string, list);
            }
            this.setPropertiesSet();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public PasswordAuthentication getAuthentication(String string, URL uRL) {
        if (this.user_name == null || this.password == null) {
            String string2 = uRL.getUserInfo();
            if (string2 == null) {
                return null;
            }
            String string3 = string2;
            String string4 = "";
            int n = string2.indexOf(58);
            if (n != -1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            }
            return new PasswordAuthentication(string3, string4.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    public void setAuthenticationOutcome(String string, URL uRL, boolean bl) {
    }

    public void clearPasswords() {
    }

    private URLConnection openConnection(URL uRL) throws IOException {
        if (this.force_no_proxy) {
            return Java15Utils.openConnectionForceNoProxy(uRL);
        }
        return uRL.openConnection();
    }

    protected String trimForDisplay(URL uRL) {
        String string = uRL.toString();
        int n = string.indexOf(63);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

