/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.io.InputStream;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSChannelImpl;

public class RSSFeedImpl
implements RSSFeed {
    private boolean is_atom;
    private RSSChannel[] channels;

    public RSSFeedImpl(Utilities utilities, ResourceDownloader resourceDownloader) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        this(utilities, resourceDownloader.download());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSSFeedImpl(Utilities utilities, InputStream inputStream) throws SimpleXMLParserDocumentException {
        try {
            SimpleXMLParserDocument simpleXMLParserDocument = utilities.getSimpleXMLParserDocumentFactory().create(inputStream);
            String string = simpleXMLParserDocument.getName();
            this.is_atom = string != null && string.equalsIgnoreCase("feed");
            ArrayList<RSSChannelImpl> arrayList = new ArrayList<RSSChannelImpl>();
            if (this.is_atom) {
                arrayList.add(new RSSChannelImpl(simpleXMLParserDocument, true));
            } else {
                SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocument.getChildren();
                for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
                    SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = simpleXMLParserDocumentNodeArray[i];
                    String string2 = simpleXMLParserDocumentNode.getName().toLowerCase();
                    if (!string2.equals("channel")) continue;
                    arrayList.add(new RSSChannelImpl(simpleXMLParserDocumentNode, false));
                }
            }
            this.channels = new RSSChannel[arrayList.size()];
            arrayList.toArray(this.channels);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                inputStream.close();
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public boolean isAtomFeed() {
        return this.is_atom;
    }

    public RSSChannel[] getChannels() {
        return this.channels;
    }
}

