/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.AbstractSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberSetting<T extends Number>
extends AbstractSetting {
    protected final T MAX_VALUE;
    protected final T MIN_VALUE;
    private final boolean remote;

    protected AbstractNumberSetting(Properties properties, Properties properties2, String string, String string2, boolean bl, T t, T t2) {
        super(properties, properties2, string, string2);
        this.remote = bl;
        if (t2 != null && t != null && ((Comparable)t2).compareTo(t) < 0) {
            throw new IllegalArgumentException("max less than min");
        }
        this.MAX_VALUE = t2;
        this.MIN_VALUE = t;
        this.setValueInternal(this.getValueAsString());
    }

    @Override
    protected void setValueInternal(String string) {
        if (this.remote) {
            assert (this.MAX_VALUE != null) : "remote setting created with no max";
            assert (this.MIN_VALUE != null) : "remote setting created with no min";
        }
        string = this.normalizeValue(string);
        super.setValueInternal(string);
    }

    protected String normalizeValue(String string) {
        Comparable<T> comparable = null;
        try {
            comparable = this.convertToComparable(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.DEFAULT_VALUE;
        }
        if (this.MAX_VALUE != null && comparable.compareTo(this.MAX_VALUE) > 0) {
            return this.MAX_VALUE.toString();
        }
        if (this.MIN_VALUE != null && comparable.compareTo(this.MIN_VALUE) < 0) {
            return this.MIN_VALUE.toString();
        }
        return string;
    }

    protected abstract Comparable<T> convertToComparable(String var1);
}

