/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.LongSetting;

public final class PowerOfTwoSetting
extends LongSetting {
    PowerOfTwoSetting(Properties properties, Properties properties2, String string, long l) {
        super(properties, properties2, string, l);
        if (!PowerOfTwoSetting.isPowerOfTwo(l)) {
            throw new IllegalArgumentException("Default value is not a power of two");
        }
    }

    PowerOfTwoSetting(Properties properties, Properties properties2, String string, long l, long l2, long l3) {
        super(properties, properties2, string, l, l2, l3);
        if (!PowerOfTwoSetting.isPowerOfTwo(l)) {
            throw new IllegalArgumentException("Default value is not a power of two");
        }
        if (!PowerOfTwoSetting.isPowerOfTwo(l3)) {
            throw new IllegalArgumentException("Max value is not a power of two");
        }
        if (!PowerOfTwoSetting.isPowerOfTwo(l2)) {
            throw new IllegalArgumentException("Min value is not a power of two");
        }
    }

    private static final boolean isPowerOfTwo(long l) {
        if (l <= 0L) {
            return false;
        }
        return ((l ^ 0xFFFFFFFFFFFFFFFFL) + 1L & l) == l;
    }

    protected String normalizeValue(String string) {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.DEFAULT_VALUE;
        }
        if (l <= 0L) {
            if (this.MIN_VALUE != null) {
                return ((Long)this.MIN_VALUE).toString();
            }
            return super.normalizeValue("1");
        }
        long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) + 1L & l;
        if (l2 != l) {
            while ((l2 = ((l -= l2) ^ 0xFFFFFFFFFFFFFFFFL) + 1L & l) != l) {
            }
            if (l == 0L) {
                l = 1L;
            }
            string = String.valueOf(l);
        }
        return super.normalizeValue(string);
    }
}

