/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;

public class IPPortCombo
implements IpPort {
    private final InetSocketAddress addr;
    public static final String DELIM = ":";

    public static IPPortCombo getCombo(byte[] byArray) throws InvalidDataException {
        return new IPPortCombo(byArray);
    }

    private IPPortCombo(byte[] byArray) throws InvalidDataException {
        InetAddress inetAddress;
        if (byArray.length != 6) {
            throw new InvalidDataException("Weird Input");
        }
        int n = ByteOrder.ushort2int((short)ByteOrder.leb2short((byte[])byArray, (int)4));
        if (!NetworkUtils.isValidPort(n)) {
            throw new InvalidDataException("Bad Port: " + n);
        }
        try {
            byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3]};
            inetAddress = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidDataException("bad host.");
        }
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new InvalidDataException("invalid addr: " + inetAddress);
        }
        this.addr = new InetSocketAddress(inetAddress, n);
    }

    public IPPortCombo(String string, int n) throws UnknownHostException, IllegalArgumentException {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Bad Port: " + n);
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new IllegalArgumentException("invalid addr: " + inetAddress);
        }
        this.addr = new InetSocketAddress(inetAddress, n);
    }

    public IPPortCombo(InetSocketAddress inetSocketAddress) throws IllegalArgumentException {
        if (!NetworkUtils.isValidPort(inetSocketAddress.getPort())) {
            throw new IllegalArgumentException("Bad Port: " + inetSocketAddress);
        }
        if (!NetworkUtils.isValidAddress(inetSocketAddress.getAddress())) {
            throw new IllegalArgumentException("invalid addr: " + inetSocketAddress);
        }
        this.addr = inetSocketAddress;
    }

    public int getPort() {
        return this.addr.getPort();
    }

    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    public String getAddress() {
        return this.getInetAddress().getHostAddress();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[6];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = this.getInetAddress().getAddress()[i];
        }
        ByteOrder.short2leb((short)((short)this.getPort()), (byte[])byArray, (int)4);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object instanceof IPPortCombo) {
            IPPortCombo iPPortCombo = (IPPortCombo)object;
            return this.getAddress().equals(iPPortCombo.getAddress()) && this.getPort() == iPPortCombo.getPort();
        }
        return false;
    }

    public int hashCode() {
        return this.getAddress().hashCode() * this.getPort();
    }

    public String toString() {
        return this.getAddress() + DELIM + this.getPort();
    }
}

