/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.MessageDigest;
import org.limewire.io.CRC32MessageDigest;

public class SecureInputStream
extends FilterInputStream {
    private final MessageDigest md;
    private final byte[] buffer;
    private int pos = 0;
    private int length = -1;

    public SecureInputStream(InputStream inputStream) throws IOException {
        this(inputStream, new CRC32MessageDigest());
    }

    public SecureInputStream(InputStream inputStream, MessageDigest messageDigest) throws IOException {
        super(inputStream);
        int n;
        int n2;
        int n3;
        if (messageDigest == null) {
            throw new NullPointerException("MessageDigest is null");
        }
        int n4 = 0;
        for (int i = 0; i < 4; ++i) {
            n3 = inputStream.read();
            if (n3 < 0) {
                throw new EOFException("Couldn't read the length of the header");
            }
            n4 = n4 << 8 | n3 & 0xFF;
        }
        if (n4 <= 0 || n4 >= 512) {
            throw new StreamCorruptedException("Invalid length of the header: " + n4);
        }
        byte[] byArray = new byte[n4];
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = inputStream.read();
            if (n2 < 0) {
                throw new EOFException("Couldn't read the header");
            }
            byArray[n3] = (byte)(n2 & 0xFF);
        }
        messageDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = messageDigest.digest();
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            n = inputStream.read();
            if (n < 0) {
                throw new EOFException("Couldn't read the checksum of length " + byArray2.length);
            }
            if (byArray2[n2] == (byte)(n & 0xFF)) continue;
            throw new StreamCorruptedException("Header checksums do not match");
        }
        String string = null;
        n = 0;
        int n5 = 0;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        string = dataInputStream.readUTF();
        n = dataInputStream.readInt();
        n5 = dataInputStream.readInt();
        dataInputStream.close();
        if (!string.equals(messageDigest.getAlgorithm())) {
            throw new StreamCorruptedException("Expected a MessageDigest of type " + string + " but is " + messageDigest.getAlgorithm());
        }
        if (n != messageDigest.getDigestLength()) {
            throw new StreamCorruptedException("Expected a MessageDigest with length " + n + " but is " + messageDigest.getDigestLength());
        }
        messageDigest.reset();
        this.md = messageDigest;
        this.buffer = new byte[n5];
    }

    public int getBlockSize() {
        return this.buffer.length;
    }

    public MessageDigest getMessageDigest() {
        return this.md;
    }

    private int refill() throws IOException {
        int n;
        assert (this.pos >= this.length);
        this.pos = 0;
        this.length = 0;
        this.md.reset();
        while (this.length < this.buffer.length && (n = this.in.read()) >= 0) {
            this.buffer[this.length++] = (byte)(n & 0xFF);
        }
        if (this.length == 0) {
            return -1;
        }
        n = this.md.getDigestLength();
        this.length -= n;
        if (this.length <= 0) {
            throw new StreamCorruptedException("Illegal payload length: " + this.length);
        }
        this.md.update(this.buffer, 0, this.length);
        byte[] byArray = this.md.digest();
        assert (byArray.length == n);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this.buffer[this.length + i]) continue;
            throw new StreamCorruptedException("Checksums do not match");
        }
        return this.length;
    }

    public int read() throws IOException {
        if (this.pos >= this.length) {
            this.refill();
            if (this.pos >= this.length) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            if (this.pos >= this.length) {
                this.refill();
                if (this.pos >= this.length) break;
            }
            n4 = Math.min(this.length - this.pos, n2 - n3);
            System.arraycopy(this.buffer, this.pos, byArray, n + n3, n4);
            this.pos += n4;
        }
        return n3 > 0 ? n3 : -1;
    }
}

