/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class ID3Unsynchronization {
    public static boolean requiresUnsynchronization(byte[] abySource) {
        int i = 0;
        while (i < abySource.length - 1) {
            if ((abySource[i] & 0xFF) == 255 && (abySource[i + 1] & 0xE0) == 224) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static byte[] unsynchronize(byte[] abySource) {
        ByteArrayInputStream oBAIS = new ByteArrayInputStream(abySource);
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        int count = 0;
        while (oBAIS.available() > 0) {
            int iVal = oBAIS.read();
            ++count;
            oBAOS.write(iVal);
            if ((iVal & 0xFF) != 255 || oBAIS.available() <= 0) continue;
            oBAIS.mark(1);
            int iNextVal = oBAIS.read();
            if ((iNextVal & 0xE0) == 224) {
                oBAOS.write(0);
                oBAOS.write(iNextVal);
                continue;
            }
            if (iNextVal == 0) {
                oBAOS.write(0);
                oBAOS.write(iNextVal);
                continue;
            }
            oBAIS.reset();
        }
        if ((abySource[abySource.length - 1] & 0xFF) == 255) {
            oBAOS.write(0);
        }
        return oBAOS.toByteArray();
    }

    public static ByteBuffer synchronize(ByteBuffer source) {
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        while (source.hasRemaining()) {
            byte unsyncByteValue;
            byte byteValue = source.get();
            oBAOS.write(byteValue);
            if ((byteValue & 0xFF) != 255 || !source.hasRemaining() || (unsyncByteValue = source.get()) == 0) continue;
            oBAOS.write(unsyncByteValue);
        }
        return ByteBuffer.wrap(oBAOS.toByteArray());
    }
}

