/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.Throttle;
import org.limewire.nio.ThrottleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBThrottle
implements Throttle {
    private static final int DEFAULT_TICK_TIME = 100;
    private final int MILLIS_PER_TICK;
    private final int MAXIMUM_TO_GIVE;
    private final int MINIMUM_TO_GIVE;
    private final boolean _write;
    private final int _processOp;
    private volatile int _bytesPerTick;
    private volatile int _available;
    private long _nextTickTime = -1L;
    private Set<ThrottleListener> _requests = new HashSet<ThrottleListener>();
    private Map<Object, ThrottleListener> _interested = new LinkedHashMap<Object, ThrottleListener>();
    private Map<Object, SelectionKey> _ready = new HashMap<Object, SelectionKey>();
    private boolean _active = false;

    public NBThrottle(boolean bl, float f) {
        this(bl, f, true, 100);
    }

    public NBThrottle(boolean bl, float f, int n, int n2) {
        this(bl, f, true, n == 0 ? 100 : n2 / n);
    }

    protected NBThrottle(boolean bl, float f, boolean bl2, int n) {
        this.MILLIS_PER_TICK = Math.min(100, Math.max(50, n));
        int n2 = 1000 / this.MILLIS_PER_TICK;
        this._write = bl;
        this._processOp = bl ? 4 : 1;
        this._bytesPerTick = (int)(f / (float)n2);
        if (bl2) {
            NIODispatcher.instance().addThrottle(this);
        }
        if (bl) {
            this.MAXIMUM_TO_GIVE = 1400;
            this.MINIMUM_TO_GIVE = 30;
        } else {
            this.MAXIMUM_TO_GIVE = Integer.MAX_VALUE;
            this.MINIMUM_TO_GIVE = 1;
        }
    }

    @Override
    public void setRate(float f) {
        int n = 1000 / this.MILLIS_PER_TICK;
        this._bytesPerTick = (int)(f / (float)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectableKeys(Collection<? extends SelectionKey> collection) {
        if (this._available >= this.MINIMUM_TO_GIVE && !this._interested.isEmpty()) {
            Object object;
            Iterator<? extends SelectionKey> iterator = collection.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                try {
                    if (!selectionKey.isValid() || !(this._write ? selectionKey.isWritable() : selectionKey.isReadable()) || !this._interested.containsKey(object = NIODispatcher.instance().attachment(selectionKey.attachment()))) continue;
                    this._ready.put(object, selectionKey);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    iterator.remove();
                }
            }
            this._active = true;
            long l = System.currentTimeMillis();
            object = this._interested.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<Object, ThrottleListener> entry = object.next();
                ThrottleListener throttleListener = entry.getValue();
                Object object2 = entry.getKey();
                SelectionKey selectionKey = this._ready.remove(object2);
                if (!throttleListener.isOpen()) {
                    object.remove();
                    continue;
                }
                if (selectionKey == null) continue;
                object.remove();
                throttleListener.requestBandwidth();
                try {
                    NIODispatcher.instance().process(l, selectionKey, selectionKey.attachment(), this._processOp);
                }
                finally {
                    throttleListener.releaseBandwidth();
                }
                if (this._available >= this.MINIMUM_TO_GIVE) continue;
                break;
            }
            this._active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interest(ThrottleListener throttleListener) {
        boolean bl;
        Set<ThrottleListener> set = this._requests;
        synchronized (set) {
            bl = this._requests.isEmpty();
            this._requests.add(throttleListener);
        }
        if (bl || this._available >= this.MINIMUM_TO_GIVE) {
            NIODispatcher.instance().wakeup();
        }
    }

    @Override
    public int request() {
        if (!this._active) {
            return 0;
        }
        int n = Math.min(this._available, this.MAXIMUM_TO_GIVE);
        this._available -= n;
        return n;
    }

    @Override
    public void release(int n) {
        if (this._active) {
            this._available += n;
        }
    }

    public void limit(int n) {
        this._bytesPerTick = n * this.MILLIS_PER_TICK / 1000;
    }

    void tick(long l) {
        if (l >= this._nextTickTime) {
            this._available = this._bytesPerTick;
            this._nextTickTime = l + (long)this.MILLIS_PER_TICK;
            this.spreadBandwidth();
        } else if (this._available >= this.MINIMUM_TO_GIVE) {
            this.spreadBandwidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextTickTime() {
        Set<ThrottleListener> set = this._requests;
        synchronized (set) {
            if (this._requests.isEmpty() && this._interested.isEmpty()) {
                return Long.MAX_VALUE;
            }
        }
        return this._nextTickTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spreadBandwidth() {
        Set<ThrottleListener> set = this._requests;
        synchronized (set) {
            if (!this._requests.isEmpty()) {
                for (ThrottleListener throttleListener : this._requests) {
                    Object object = throttleListener.getAttachment();
                    if (object == null) {
                        throw new IllegalStateException("must have an attachment - listener: " + throttleListener);
                    }
                    if (!throttleListener.bandwidthAvailable()) continue;
                    this._interested.put(object, throttleListener);
                }
                this._requests.clear();
            }
        }
    }
}

