/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.limewire.nio.BufferInputStream;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.ReadTimeout;
import org.limewire.nio.timeout.SoTimeout;
import org.limewire.util.BufferUtils;

class NIOInputStream
implements ChannelReadObserver,
InterestScatteringByteChannel,
ReadTimeout {
    private final Shutdownable shutdownHandler;
    private final SoTimeout soTimeoutHandler;
    private InterestReadableByteChannel channel;
    private BufferInputStream source;
    private volatile Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;
    private boolean lastFilled = false;

    NIOInputStream(SoTimeout soTimeout, Shutdownable shutdownable, InterestReadableByteChannel interestReadableByteChannel) {
        this.soTimeoutHandler = soTimeout;
        this.shutdownHandler = shutdownable;
        this.channel = interestReadableByteChannel;
    }

    synchronized NIOInputStream init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("Already closed!");
        }
        this.buffer = NIODispatcher.instance().getBufferCache().getHeap();
        this.source = new BufferInputStream(this.buffer, this, this.shutdownHandler, this.channel, this);
        this.bufferLock = this.source.getBufferLock();
        return this;
    }

    public int read(ByteBuffer byteBuffer) {
        return BufferUtils.transfer((ByteBuffer)this.buffer, (ByteBuffer)byteBuffer);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) {
        return BufferUtils.transfer((ByteBuffer)this.buffer, (ByteBuffer[])byteBufferArray, (int)n, (int)n2, (boolean)true);
    }

    public long read(ByteBuffer[] byteBufferArray) {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    synchronized InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRead() throws IOException {
        if (this.bufferLock == null) {
            int n = this.channel.read(BufferUtils.getEmptyBuffer());
            if (n == -1) {
                throw new ClosedChannelException();
            }
        } else {
            Object object = this.bufferLock;
            synchronized (object) {
                int n = 0;
                while (this.buffer.hasRemaining() && (n = this.channel.read(this.buffer)) > 0) {
                }
                if (n == -1) {
                    this.source.finished();
                }
                if (this.buffer.position() > 0 || n == -1) {
                    this.bufferLock.notify();
                }
                if (!this.buffer.hasRemaining()) {
                    this.lastFilled = true;
                    this.channel.interestRead(false);
                } else {
                    this.lastFilled = false;
                }
                if (n == -1) {
                    this.channel.interestRead(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readHappening() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.lastFilled) {
                NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                    public void run() {
                        try {
                            NIOInputStream.this.handleRead();
                        }
                        catch (IOException iOException) {
                            NIOInputStream.this.channel.interestRead(true);
                            NIOInputStream.this.shutdownHandler.shutdown();
                        }
                    }
                });
            }
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.source != null) {
            this.source.shutdown();
        }
        if (this.buffer != null) {
            NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                public void run() {
                    NIODispatcher.instance().getBufferCache().release(NIOInputStream.this.buffer);
                }
            });
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("unsupported operation", iOException);
    }

    public void close() throws IOException {
    }

    public boolean isOpen() {
        return true;
    }

    public void interestRead(boolean bl) {
        this.channel.interestRead(bl);
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        Object object = this.bufferLock;
        synchronized (object) {
            this.channel = interestReadableByteChannel;
            this.source.setReadChannel(interestReadableByteChannel);
        }
    }

    public long getReadTimeout() {
        try {
            return this.soTimeoutHandler.getSoTimeout();
        }
        catch (SocketException socketException) {
            return -1L;
        }
    }
}

