/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnewayExchanger<V, E extends Throwable> {
    private boolean done = false;
    private boolean cancelled = false;
    private final boolean oneShot;
    private V value;
    private E exception;

    public OnewayExchanger() {
        this(false);
    }

    public OnewayExchanger(boolean bl) {
        this.oneShot = bl;
    }

    public synchronized V get() throws InterruptedException, E {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new Error(timeoutException);
        }
    }

    public synchronized V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, E {
        if (!this.done) {
            if (l == 0L) {
                this.wait();
            } else {
                timeUnit.timedWait(this, l);
            }
            if (!this.done) {
                throw new TimeoutException();
            }
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public synchronized V tryGet() throws InterruptedException, E {
        if (this.done) {
            return this.get();
        }
        return null;
    }

    public synchronized boolean cancel() {
        if (this.done) {
            return this.cancelled;
        }
        this.done = true;
        this.cancelled = true;
        this.notifyAll();
        return true;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean throwsException() {
        return this.cancelled || this.exception != null;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public synchronized void setValue(V v) {
        if (this.cancelled) {
            return;
        }
        if (this.done && this.oneShot) {
            throw new IllegalStateException("The OnewayExchanger is configured for a single shot");
        }
        this.done = true;
        this.value = v;
        this.notifyAll();
    }

    public synchronized void setException(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.cancelled) {
            return;
        }
        if (this.done && this.oneShot) {
            throw new IllegalStateException("The OnewayExchanger is configured for a single shot");
        }
        this.done = true;
        this.exception = e;
        this.notifyAll();
    }

    public synchronized void reset() {
        if (this.oneShot) {
            throw new IllegalStateException("The OnewayExchanger is configured for a single shot");
        }
        this.done = false;
        this.cancelled = false;
        this.value = null;
        this.exception = null;
    }
}

