/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lifecycle;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceRegistryListener;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.lifecycle.StagedRegisterBuilder;
import org.limewire.lifecycle.StagedRegisterBuilderImpl;

@Singleton
class ServiceRegistryImpl
implements ServiceRegistry {
    private static final Log LOG = LogFactory.getLog(ServiceRegistryImpl.class);
    private final List<StagedRegisterBuilderImpl> builders = new ArrayList<StagedRegisterBuilderImpl>();
    private final Map<Object, List<ServiceHolder>> services = new HashMap<Object, List<ServiceHolder>>();
    private final List<ServiceHolder> startedServices = new ArrayList<ServiceHolder>();
    private final List<ServiceRegistryListener> registryListeners = new ArrayList<ServiceRegistryListener>();

    ServiceRegistryImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        ServiceStage[] serviceStageArray = this.builders.iterator();
        while (serviceStageArray.hasNext()) {
            void object;
            List<ServiceHolder> list;
            StagedRegisterBuilderImpl stagedRegisterBuilderImpl = serviceStageArray.next();
            Object object2 = stagedRegisterBuilderImpl.getCustomStage();
            if (object2 == null) {
                object2 = stagedRegisterBuilderImpl.getStage();
            }
            if ((list = this.services.get(object2)) == null) {
                ArrayList arrayList = new ArrayList();
                this.services.put(object2, arrayList);
            }
            object.add(new ServiceHolder(stagedRegisterBuilderImpl.getService()));
            serviceStageArray.remove();
        }
        for (ServiceStage serviceStage : this.getStagesInOrder()) {
            if (this.services.get((Object)serviceStage) == null) continue;
            for (ServiceHolder serviceHolder : this.services.get((Object)serviceStage)) {
                serviceHolder.init();
            }
        }
        for (Map.Entry entry : this.services.entrySet()) {
            if (entry.getKey().getClass() == ServiceStage.class || entry.getValue() == null) continue;
            for (ServiceHolder serviceHolder : (List)entry.getValue()) {
                serviceHolder.init();
            }
        }
    }

    public void start(Object object) {
        this.initialize();
        this.startStage(object);
    }

    public void start() {
        this.initialize();
        for (ServiceStage serviceStage : this.getStagesInOrder()) {
            this.startStage((Object)serviceStage);
        }
    }

    private void startStage(Object object) {
        List<ServiceHolder> list = this.services.get(object);
        if (list != null) {
            Iterator<ServiceHolder> iterator = list.iterator();
            while (iterator.hasNext()) {
                ServiceHolder serviceHolder = iterator.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("starting service: " + serviceHolder.service.service.getClass().getSimpleName()));
                }
                serviceHolder.start();
                this.startedServices.add(serviceHolder);
                iterator.remove();
            }
            for (ServiceHolder serviceHolder : this.startedServices) {
                try {
                    serviceHolder.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public void stop() {
        int n;
        for (n = this.startedServices.size() - 1; n >= 0; --n) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("stopping service: " + this.startedServices.get(n).service.service.getClass().getSimpleName()));
            }
            this.startedServices.get(n).stop();
        }
        for (n = this.startedServices.size() - 1; n >= 0; --n) {
            try {
                this.startedServices.get(n).join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.startedServices.remove(n);
        }
    }

    public StagedRegisterBuilder register(Service service) {
        StagedRegisterBuilderImpl stagedRegisterBuilderImpl = new StagedRegisterBuilderImpl(service);
        this.builders.add(stagedRegisterBuilderImpl);
        return stagedRegisterBuilderImpl;
    }

    public void addListener(ServiceRegistryListener serviceRegistryListener) {
        this.registryListeners.add(serviceRegistryListener);
    }

    ServiceStage[] getStagesInOrder() {
        return new ServiceStage[]{ServiceStage.EARLY, ServiceStage.NORMAL, ServiceStage.LATE};
    }

    private class ServiceHolder {
        private final AnnotatedService service;
        private boolean initted;
        private boolean started;
        private boolean stopped;

        public ServiceHolder(Service service) {
            this.service = new AnnotatedService(service);
        }

        void init() {
            if (!this.initted) {
                this.initted = true;
                for (ServiceRegistryListener serviceRegistryListener : ServiceRegistryImpl.this.registryListeners) {
                    serviceRegistryListener.initializing(this.service);
                }
                this.service.initialize();
            }
        }

        void start() {
            if (!this.started) {
                this.started = true;
                for (ServiceRegistryListener serviceRegistryListener : ServiceRegistryImpl.this.registryListeners) {
                    serviceRegistryListener.starting(this.service);
                }
                this.service.start();
            }
        }

        void stop() {
            if (!this.stopped) {
                this.stopped = true;
                for (ServiceRegistryListener serviceRegistryListener : ServiceRegistryImpl.this.registryListeners) {
                    serviceRegistryListener.stopping(this.service);
                }
                this.service.stop();
            }
        }

        void join() throws InterruptedException {
            this.service.join();
        }

        private class AnnotatedService
        implements Service {
            private final Service service;
            private Thread serviceExecutor;

            AnnotatedService(Service service) {
                this.service = service;
            }

            void join() throws InterruptedException {
                if (this.serviceExecutor != null) {
                    this.serviceExecutor.join();
                    this.serviceExecutor = null;
                }
            }

            public void initialize() {
                this.service.initialize();
            }

            public String getServiceName() {
                return this.service.getServiceName();
            }

            public void start() {
                if (this.isAsyncStart()) {
                    this.serviceExecutor = this.asyncStart();
                } else {
                    this.service.start();
                }
            }

            private Thread asyncStart() {
                Asynchronous asynchronous = this.getStartAsynchronous();
                Thread thread = ThreadExecutor.newManagedThread(new Runnable(){

                    public void run() {
                        AnnotatedService.this.service.start();
                    }
                }, "ServiceRegistry-start-" + this.service.getServiceName());
                thread.setDaemon(asynchronous.daemon());
                thread = this.wrapWithWaitingThreadIfNeeded(thread, asynchronous);
                thread.start();
                return thread;
            }

            public void stop() {
                if (this.isAsyncStop()) {
                    this.serviceExecutor = this.asyncStop();
                } else {
                    this.service.stop();
                }
            }

            private Thread asyncStop() {
                Asynchronous asynchronous = this.getStopAsynchronous();
                Thread thread = ThreadExecutor.newManagedThread(new Runnable(){

                    public void run() {
                        AnnotatedService.this.service.stop();
                    }
                }, "ServiceRegistry-stop-" + this.service.getServiceName());
                thread.setDaemon(asynchronous.daemon());
                thread = this.wrapWithWaitingThreadIfNeeded(thread, asynchronous);
                thread.start();
                return thread;
            }

            private boolean isAsyncStop() {
                return this.getAsynchronousAnnotation("stop") != null;
            }

            private boolean isAsyncStart() {
                return this.getAsynchronousAnnotation("start") != null;
            }

            private Asynchronous getStopAsynchronous() {
                return this.getAsynchronousAnnotation("stop");
            }

            private Asynchronous getStartAsynchronous() {
                return this.getAsynchronousAnnotation("start");
            }

            private Asynchronous getAsynchronousAnnotation(String string) {
                try {
                    return this.service.getClass().getMethod(string, new Class[0]).getAnnotation(Asynchronous.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException(noSuchMethodException);
                }
            }

            private Thread wrapWithWaitingThreadIfNeeded(final Thread thread, final Asynchronous asynchronous) {
                Thread thread2;
                if (asynchronous.timeout() > 0) {
                    Thread thread3 = ThreadExecutor.newManagedThread(new Runnable(){

                        public void run() {
                            thread.start();
                            try {
                                thread.join(asynchronous.timeout() * 1000);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }, "ServiceRegistry-waiting-thread-" + this.service.getServiceName());
                    thread3.setDaemon(false);
                    thread2 = thread3;
                } else {
                    thread2 = thread;
                }
                return thread2;
            }
        }
    }
}

